/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.api.SendCallback;
import com.dtyunxi.huieryun.mq.provider.rabbit.RabbitMQHelper;
import com.dtyunxi.huieryun.mq.provider.rabbit.assembler.MessageAssembler;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageInfo;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageManager;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageManagerWithBroadcast;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageManagerWithTopics;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.RabbitMqManager;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.retry.vo.RetryerRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.rabbitmq.client.Channel;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitProducer
extends AbstractProducer {
    private static final RabbitProducer single = new RabbitProducer();
    private static final Logger logger = LoggerFactory.getLogger(RabbitProducer.class);
    private RabbitMqManager rabbitMqManager;
    private Channel channel;
    private ThreadPoolExecutor threadPool;

    private RabbitProducer() {
    }

    public static RabbitProducer getInstance() {
        return single;
    }

    public ThreadPoolExecutor getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = (ThreadPoolExecutor)SpringBeanUtil.getBean(ThreadPoolExecutor.class);
        }
        return this.threadPool;
    }

    public void createProducer(MessageRegistryVo messageRegistryVo) {
        logger.info("before createProducer , messageRegistryVo={}", (Object)messageRegistryVo);
        this.rabbitMqManager = RabbitMQHelper.connectRabbitMqManager(messageRegistryVo);
        this.messageRegistryVo = messageRegistryVo;
        this.channel = this.rabbitMqManager.createChannel();
        this.serializeCode = messageRegistryVo.getSerializeCode();
        logger.info("after createProducer , RabbitProducer={}", (Object)this);
    }

    private void addServiceContext(MessageInfo messageInfo) {
        if (!this.messageRegistryVo.isPassSvcContext()) {
            return;
        }
        HashMap<String, Object> headers = new HashMap<String, Object>();
        ServiceContext.getContext().getKeys().forEach((k, v) -> {
            if (k != null && v != null) {
                headers.put("_context-" + k, v.toString());
            }
        });
        messageInfo.setHeaders(headers);
    }

    protected Boolean connectMQServer() {
        return null;
    }

    public MessageResponse sendSingleMessage(String topicName, String queueName, Object message, long delayTime) {
        try {
            MessageInfo messageInfo = this.packMessage(topicName, queueName, message, delayTime);
            this.addServiceContext(messageInfo);
            String result = this.sendSingleMessage(messageInfo);
            return new MessageResponse((Object)result);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{topicName, queueName, message, delayTime, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private String sendSingleMessage(MessageInfo messageInfo) throws Exception {
        Callable<String> sendMessageCallable = this.createSingleMessageCallable(messageInfo);
        return sendMessageCallable.call();
    }

    private Callable<String> createSingleMessageCallable(final MessageInfo msg) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    if (null == RabbitProducer.this.channel || !RabbitProducer.this.channel.isOpen()) {
                        RabbitProducer.this.channel = RabbitProducer.this.rabbitMqManager.createChannel();
                    }
                    if (null == RabbitProducer.this.channel) {
                        throw new BusinessRuntimeException("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
                    }
                    MessageManager messageManager = new MessageManager(RabbitProducer.this.messageRegistryVo, RabbitProducer.this.channel);
                    return messageManager.sendMessage(msg);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{msg.getTopicName(), msg.getRoutingKey(), msg.getMessage(), msg.getDelayTime(), e});
                    throw e;
                }
            }
        };
    }

    private Callable<Boolean> createAsyncSingleMessageCallable(final MessageInfo msg, final SendCallback callback) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    if (null == RabbitProducer.this.channel || !RabbitProducer.this.channel.isOpen()) {
                        RabbitProducer.this.channel = RabbitProducer.this.rabbitMqManager.createChannel();
                    }
                    if (null == RabbitProducer.this.channel) {
                        logger.error("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
                        return false;
                    }
                    MessageManager messageManager = new MessageManager(RabbitProducer.this.messageRegistryVo, RabbitProducer.this.channel);
                    callback.onSuccess(messageManager.sendMessage(msg));
                    return true;
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{msg.getTopicName(), msg.getRoutingKey(), msg.getMessage(), msg.getDelayTime(), e});
                    callback.onException(e, msg.getMessageId());
                    return false;
                }
            }
        };
    }

    public MessageResponse sendAsyncSingleMessage(String topic, String queueName, Object message, long delayTime, SendCallback callback) {
        MessageInfo messageInfo = this.packMessage(topic, queueName, message, delayTime);
        this.addServiceContext(messageInfo);
        Callable<Boolean> sendMessageCallable = this.createAsyncSingleMessageCallable(messageInfo, callback);
        RetryerRegistryVo retryerRegistryVo = this.getRetryerRegistryVo();
        if (retryerRegistryVo.isRetryEnable()) {
            this.getRetryService().retryWithResultAndIncreaseStrategy((Object)true, retryerRegistryVo.getInitialSleepTime(), retryerRegistryVo.getIncrementSleepTime(), retryerRegistryVo.getAttemptNumber(), sendMessageCallable);
        } else {
            this.getThreadPool().submit(sendMessageCallable);
        }
        return MessageResponse.SUCCESS;
    }

    public MessageResponse sendMessage(String topicName, String routingKey, Object message, long delayTime) {
        try {
            MessageInfo messageInfo = this.packMessage(topicName, routingKey, message, delayTime);
            this.addServiceContext(messageInfo);
            String result = this.sendMessage(messageInfo);
            return new MessageResponse((Object)result);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{} message{} delayTime={}", new Object[]{topicName, routingKey, message, delayTime, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private String sendMessage(MessageInfo messageInfo) throws Exception {
        Callable<String> sendMessageCallable = this.createTopicsMessageCallable(messageInfo);
        return sendMessageCallable.call();
    }

    private Callable<String> createTopicsMessageCallable(final MessageInfo msg) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    if (null == RabbitProducer.this.channel || !RabbitProducer.this.channel.isOpen()) {
                        RabbitProducer.this.channel = RabbitProducer.this.rabbitMqManager.createChannel();
                    }
                    if (null == RabbitProducer.this.channel) {
                        throw new BusinessRuntimeException("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
                    }
                    MessageManagerWithTopics messageManager = new MessageManagerWithTopics(RabbitProducer.this.messageRegistryVo, RabbitProducer.this.channel);
                    return messageManager.sendMessage(msg);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{msg.getTopicName(), msg.getRoutingKey(), msg.getMessage(), msg.getDelayTime(), e});
                    throw e;
                }
            }
        };
    }

    public MessageResponse sendAsyncMessage(String routingKey, Object message, SendCallback callback) {
        String topicName = this.getTopicName();
        return this.sendAsyncMessage(topicName, routingKey, message, 0L, callback);
    }

    public MessageResponse sendAsyncMessage(String routingKey, Object message, long delayTime, SendCallback callback) {
        String topicName = this.getTopicName();
        return this.sendAsyncMessage(topicName, routingKey, message, delayTime, callback);
    }

    public MessageResponse sendAsyncMessage(String topicName, String routingKey, Object message, long delayTime, SendCallback callback) {
        try {
            MessageInfo messageInfo = this.packMessage(topicName, routingKey, message, delayTime);
            this.addServiceContext(messageInfo);
            this.sendAsyncMessage(messageInfo, callback);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private MessageInfo packMessage(String topicName, String routingKey, Object message, long delayTime) {
        MessageInfo messageInfo = new MessageInfo(this.getMessageId(), topicName, routingKey, message, delayTime);
        if (this.serializeCode.isJdkSerializer()) {
            return messageInfo;
        }
        messageInfo.putHeader("mqMessageBodyClassInfo", JacksonUtil.toJson(message.getClass()));
        return messageInfo;
    }

    private void sendAsyncMessage(MessageInfo messageInfo, SendCallback callback) throws Exception {
        Callable<Boolean> sendMessageCallable = this.createAsyncTopicsMessageCallable(messageInfo, callback);
        RetryerRegistryVo retryerRegistryVo = this.getRetryerRegistryVo();
        if (retryerRegistryVo.isRetryEnable()) {
            this.getRetryService().retryWithResultAndIncreaseStrategy((Object)true, retryerRegistryVo.getInitialSleepTime(), retryerRegistryVo.getIncrementSleepTime(), retryerRegistryVo.getAttemptNumber(), sendMessageCallable);
        } else {
            this.getThreadPool().submit(sendMessageCallable);
        }
    }

    private Callable<Boolean> createAsyncTopicsMessageCallable(final MessageInfo msg, final SendCallback callback) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    if (null == RabbitProducer.this.channel || !RabbitProducer.this.channel.isOpen()) {
                        RabbitProducer.this.channel = RabbitProducer.this.rabbitMqManager.createChannel();
                    }
                    if (null == RabbitProducer.this.channel) {
                        logger.error("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
                        return false;
                    }
                    MessageManagerWithTopics messageManager = new MessageManagerWithTopics(RabbitProducer.this.messageRegistryVo, RabbitProducer.this.channel);
                    callback.onSuccess(messageManager.sendMessage(msg));
                    return true;
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{msg.getTopicName(), msg.getRoutingKey(), msg.getMessage(), msg.getDelayTime(), e});
                    callback.onException(e, msg.getMessageId());
                    return false;
                }
            }
        };
    }

    public MessageResponse sendBroadcastMessage(String topicName, String routingKey, Object message, long delayTime) {
        try {
            MessageInfo messageInfo = this.packMessage(topicName, routingKey, message, delayTime);
            this.addServiceContext(messageInfo);
            String result = this.sendBroadcastMessage(messageInfo);
            return new MessageResponse((Object)result);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{} message{} delayTime={}", new Object[]{topicName, routingKey, message, delayTime, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private String sendBroadcastMessage(MessageInfo messageInfo) throws Exception {
        Callable<String> sendMessageCallable = this.createBroadcastMessageCallable(messageInfo);
        return sendMessageCallable.call();
    }

    private Callable<String> createBroadcastMessageCallable(final MessageInfo msg) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    if (null == RabbitProducer.this.channel || !RabbitProducer.this.channel.isOpen()) {
                        RabbitProducer.this.channel = RabbitProducer.this.rabbitMqManager.createChannel();
                    }
                    if (null == RabbitProducer.this.channel) {
                        throw new BusinessRuntimeException("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
                    }
                    MessageManagerWithBroadcast messageManager = new MessageManagerWithBroadcast(RabbitProducer.this.messageRegistryVo, RabbitProducer.this.channel);
                    return messageManager.sendMessage(msg);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{msg.getTopicName(), msg.getRoutingKey(), msg.getMessage(), msg.getDelayTime(), e});
                    throw e;
                }
            }
        };
    }

    public MessageResponse sendAsyncBroadcastMessage(String topicName, String routingKey, Object message, long delayTime, SendCallback callback) {
        try {
            MessageInfo messageInfo = this.packMessage(topicName, routingKey, message, delayTime);
            this.addServiceContext(messageInfo);
            this.sendAsyncBroadcastMessage(messageInfo, callback);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private void sendAsyncBroadcastMessage(MessageInfo messageInfo, SendCallback callback) throws Exception {
        Callable<Boolean> sendMessageCallable = this.createAsyncBroadcastMessageCallable(messageInfo, callback);
        RetryerRegistryVo retryerRegistryVo = this.getRetryerRegistryVo();
        if (retryerRegistryVo.isRetryEnable()) {
            this.getRetryService().retryWithResultAndIncreaseStrategy((Object)true, retryerRegistryVo.getInitialSleepTime(), retryerRegistryVo.getIncrementSleepTime(), retryerRegistryVo.getAttemptNumber(), sendMessageCallable);
        } else {
            this.getThreadPool().submit(sendMessageCallable);
        }
    }

    public MessageResponse sendMessage(MQMessageVo messageVo) {
        MessageInfo messageInfo = MessageAssembler.messageVoToMessage(messageVo);
        try {
            this.addServiceContext(messageInfo);
            String result = this.sendMessage(messageInfo);
            return new MessageResponse((Object)result);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{} message{} delayTime={}", new Object[]{messageInfo.getTopicName(), messageInfo.getRoutingKey(), messageInfo.getMessage(), messageInfo.getDelayTime(), e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public MessageResponse sendAsyncMessage(MQMessageVo messageVo, SendCallback callback) {
        MessageInfo messageInfo = MessageAssembler.messageVoToMessage(messageVo);
        try {
            this.addServiceContext(messageInfo);
            this.sendAsyncMessage(messageInfo, callback);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{messageInfo.getTopicName(), messageInfo.getRoutingKey(), e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private Callable<Boolean> createAsyncBroadcastMessageCallable(final MessageInfo msg, final SendCallback callback) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    if (null == RabbitProducer.this.channel || !RabbitProducer.this.channel.isOpen()) {
                        RabbitProducer.this.channel = RabbitProducer.this.rabbitMqManager.createChannel();
                    }
                    if (null == RabbitProducer.this.channel) {
                        logger.error("\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed");
                        return false;
                    }
                    MessageManagerWithBroadcast messageManager = new MessageManagerWithBroadcast(RabbitProducer.this.messageRegistryVo, RabbitProducer.this.channel);
                    callback.onSuccess(messageManager.sendMessage(msg));
                    return true;
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{msg.getTopicName(), msg.getRoutingKey(), msg.getMessage(), msg.getDelayTime(), e});
                    callback.onException(e, msg.getMessageId());
                    return false;
                }
            }
        };
    }

    public String toString() {
        return "RabbitProducer [" + (this.messageRegistryVo != null ? "messageRegistryVo=" + this.messageRegistryVo + ", " : "") + "]";
    }
}

