/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.dto.ResponseDto;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IMqLogQueryService;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.MQConstants;
import com.dtyunxi.huieryun.mq.dao.MqLogQueryDto;
import com.dtyunxi.huieryun.mq.das.MqLogDas;
import com.dtyunxi.huieryun.mq.das.MqLogQueryDas;
import com.dtyunxi.huieryun.mq.eo.MqLogEo;
import com.dtyunxi.huieryun.mq.provider.base.MqLogConfig;
import com.dtyunxi.rest.Page;
import com.dtyunxi.util.SpringBeanUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mqLogQueryService")
public class MqLogQueryApiImpl
implements IMqLogQueryService {
    private static Logger logger = LoggerFactory.getLogger(MqLogQueryApiImpl.class);

    @Override
    public ResponseDto<List<MqLogEo>> queryByCondition(MqLogQueryDto queryDto) {
        MqLogQueryDas mqLogQueryDas = this.getMqLogQueryDas();
        if (mqLogQueryDas != null) {
            List<MqLogEo> list = mqLogQueryDas.queryMqLog(queryDto);
            return new ResponseDto(list);
        }
        return new ResponseDto(null);
    }

    @Override
    public ResponseDto<Page<MqLogEo>> queryPageByCondition(MqLogQueryDto queryDto, Integer pageNo, Integer pageSize) {
        MqLogQueryDas mqLogQueryDas = this.getMqLogQueryDas();
        if (mqLogQueryDas != null) {
            long total = mqLogQueryDas.queryCount(queryDto);
            List<MqLogEo> listResult = mqLogQueryDas.queryPageByEo(queryDto, pageNo, pageSize);
            Page page = new Page();
            page.setCurrentPage(pageNo.intValue());
            page.setPageSize(pageSize.intValue());
            page.setTotal(total);
            page.setData(listResult);
            return new ResponseDto((Object)page);
        }
        return new ResponseDto(null);
    }

    @Override
    public ResponseDto<Void> sendMessageByIds(List<Long> ids) {
        MqLogQueryDas mqLogQueryDas = this.getMqLogQueryDas();
        if (mqLogQueryDas != null) {
            MqLogQueryDto queryDto = new MqLogQueryDto();
            queryDto.setIds(ids);
            List<MqLogEo> list = mqLogQueryDas.queryMqLog(queryDto);
            this.sendMessage(ids, list);
        }
        return ResponseDto.VOID;
    }

    protected void sendMessage(List<Long> ids, List<MqLogEo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            IProducer producer = this.getProducter();
            MqLogDas mqLogDas = this.getMqLogDas();
            for (MqLogEo mqLogEo : list) {
                String topic = this.getTopicName(mqLogEo.getMqTopic(), mqLogEo.getMqSendType());
                try {
                    if (MQConstants.MQ_SEDN_TYPE_SINGLE.equals(mqLogEo.getMqSendType())) {
                        producer.sendSingleMessage(topic, mqLogEo.getMqRoutingKey(), JSON.parseObject((String)mqLogEo.getMqMessage(), Class.forName(mqLogEo.getClassName())));
                        continue;
                    }
                    producer.sendMessage(topic, mqLogEo.getMqRoutingKey(), JSON.parseObject((String)mqLogEo.getMqMessage(), Class.forName(mqLogEo.getClassName())));
                }
                catch (Exception e) {
                    logger.error("\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,log:{}", (Object)e.getMessage());
                }
            }
            mqLogDas.updateByIds(ids);
        }
    }

    private String getTopicName(String mqTopic, Integer mqSendType) {
        if (StringUtils.isEmpty((CharSequence)mqTopic)) {
            return MQConstants.MQ_SEDN_TYPE_SINGLE == mqSendType ? "default.direct.exchange" : "default.topic.exchange";
        }
        return mqTopic;
    }

    private IProducer getProducter() {
        IProducer producer = null;
        try {
            IMQService mqService = (IMQService)MqLogConfig.getInstance().getBean("mqService");
            producer = mqService.createProducer();
        }
        catch (Exception e) {
            producer = (IProducer)MqLogConfig.getInstance().getBean("producer");
        }
        return producer;
    }

    protected MqLogDas getMqLogDas() {
        MqLogDas mqLogDas = (MqLogDas)MqLogConfig.getInstance().getBean("mqLogDas");
        if (null == mqLogDas) {
            try {
                mqLogDas = (MqLogDas)SpringBeanUtil.getBean((String)"mqLogDas");
                MqLogConfig.getInstance().addBean("mqLogDas", mqLogDas);
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316MqLogDas bean\u5931\u8d25");
            }
        }
        return mqLogDas;
    }

    protected MqLogQueryDas getMqLogQueryDas() {
        MqLogQueryDas mqLogQueryDas = (MqLogQueryDas)MqLogConfig.getInstance().getBean("mqLogQueryDas");
        if (null == mqLogQueryDas) {
            try {
                mqLogQueryDas = (MqLogQueryDas)SpringBeanUtil.getBean((String)"mqLogQueryDas");
                MqLogConfig.getInstance().addBean("mqLogQueryDas", mqLogQueryDas);
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316MqLogQueryDas bean\u5931\u8d25");
            }
        }
        return mqLogQueryDas;
    }
}

