/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConsumer
extends DefaultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionConsumer.class);
    private IMessageProcessor processor;
    private int retryCount = 0;
    private Channel channel;

    public SubscriptionConsumer(Channel channel, IMessageProcessor processor) {
        super(channel);
        this.processor = processor;
        this.channel = channel;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        MessageResponse result = MessageResponse.ERROR;
        try {
            result = this.processor.process(SerializeCode.deSerialize(body));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if ("error".equals(result.getResultMsg())) {
            logger.info("\u6d88\u606f {} \u5904\u7406\u5931\u8d25", (Object)envelope.getDeliveryTag());
            this.dealMessageAck(envelope);
        } else {
            logger.info("\u6d88\u606f {} \u5904\u7406\u6210\u529f", (Object)envelope.getDeliveryTag());
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            this.retryCount = 0;
        }
    }

    private void dealMessageAck(Envelope envelope) throws IOException {
        ++this.retryCount;
        if (this.retryCount < 10) {
            logger.info("\u6d88\u8d39\u6d88\u606f {} \u5931\u8d25.\u7b2c{}\u6b21 \u91cd\u65b0\u653e\u5165\u961f\u5217", (Object)envelope.getDeliveryTag(), (Object)this.retryCount);
            this.channel.basicNack(envelope.getDeliveryTag(), false, true);
        } else {
            logger.info("\u6d88\u8d39\u6d88\u606f {} \u5904\u7406\u5931\u8d25\u5df2\u7ecf\u8d85\u8fc710\u6b21. \u62d2\u7edd\u8be5\u6d88\u606f", (Object)envelope.getDeliveryTag(), (Object)this.retryCount);
            this.channel.basicReject(envelope.getDeliveryTag(), false);
        }
    }

    protected int getWaiTime(int retryCount) {
        int waitTime = 0;
        switch (retryCount) {
            case 1: {
                waitTime = retryCount * 30;
                break;
            }
            case 2: {
                waitTime = retryCount * 60;
                break;
            }
            case 3: {
                waitTime = retryCount * 100;
                break;
            }
            case 4: {
                waitTime = retryCount * 150;
                break;
            }
            case 5: {
                waitTime = retryCount * 240;
                break;
            }
            case 6: {
                waitTime = retryCount * 400;
                break;
            }
            case 7: {
                waitTime = retryCount * 500;
                break;
            }
            case 8: {
                waitTime = retryCount * 600;
                break;
            }
            case 9: {
                waitTime = retryCount * 700;
                break;
            }
        }
        return waitTime;
    }
}

