/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.mq.api.AbstractConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.rocket.impl.factory.RocketConsumerFactory;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class RocketConsumer
extends AbstractConsumer {
    private static Logger logger = LoggerFactory.getLogger(RocketConsumer.class);
    private static volatile RocketConsumer single = null;

    private RocketConsumer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocketConsumer getInstance() {
        if (single != null) return single;
        Class<RocketConsumer> clazz = RocketConsumer.class;
        synchronized (RocketConsumer.class) {
            single = new RocketConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public void createConsumer(MessageRegistryVo topicInfo) {
        this.messageRegistryVo = topicInfo;
    }

    @Override
    public <T> MessageResponse receiveMessage(String topicName, String queueName, IMessageProcessor<T> processor) {
        logger.info("receiveMessage,topicName:{},queueName:{}", (Object)topicName, (Object)queueName);
        return this.subscribe(topicName, queueName, processor);
    }

    @Override
    public <T> MessageResponse subscribe(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(topicName, null, routingKey, processor);
    }

    @Override
    public <T> MessageResponse subscribe(String topicName, String queueName, String routingKey, final IMessageProcessor<T> processor) {
        logger.info("subscribe,topicName:{},queueName:{},routingKey:{}", new Object[]{topicName, queueName, routingKey});
        try {
            MessageRegistryVo vo = new MessageRegistryVo();
            BeanUtils.copyProperties((Object)this.messageRegistryVo, (Object)vo);
            vo.setTopicName(topicName + "_" + queueName + "_" + routingKey);
            DefaultMQPushConsumer defaultMQPushConsumer = RocketConsumerFactory.getRocketConsumer(vo);
            defaultMQPushConsumer.subscribe(topicName, routingKey);
            if (queueName == null) {
                defaultMQPushConsumer.registerMessageListener(new MessageListenerOrderly(){

                    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
                        context.setAutoCommit(true);
                        MessageExt msg = msgs.get(0);
                        Object serialize = SerializeCode.deSerialize(msg.getBody());
                        MessageResponse process = processor.process(serialize);
                        if ("error".equals(process.getResultMsg())) {
                            logger.info("\u6d88\u606f {} \u5904\u7406\u5931\u8d25", (Object)JSON.toJSONString((Object)serialize));
                            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                        }
                        logger.info("\u6d88\u606f {} \u5904\u7406\u6210\u529f", (Object)JSON.toJSONString((Object)serialize));
                        return ConsumeOrderlyStatus.SUCCESS;
                    }
                });
            } else {
                defaultMQPushConsumer.registerMessageListener(new MessageListenerConcurrently(){

                    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                        MessageExt msg = msgs.get(0);
                        Object serialize = SerializeCode.deSerialize(msg.getBody());
                        MessageResponse process = processor.process(serialize);
                        if ("error".equals(process.getResultMsg())) {
                            logger.info("\u6d88\u606f {} \u5904\u7406\u5931\u8d25", (Object)JSON.toJSONString((Object)serialize));
                            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                        }
                        logger.info("\u6d88\u606f {} \u5904\u7406\u6210\u529f", (Object)JSON.toJSONString((Object)serialize));
                        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
                    }
                });
            }
            defaultMQPushConsumer.start();
            System.out.println("ConsumerStarted.");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName:{},queueName:{},routingKey:{}", new Object[]{topicName, queueName, routingKey, e});
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    @Override
    public <T> MessageResponse subscribe(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        logger.info("subscribe,topicName:{},routingKeys:{}", (Object)topicName, (Object)routingKeys);
        return this.subscribe(topicName, this.getSubExpression(routingKeys), processor);
    }

    @Override
    public MessageResponse unsubscribe(String topic, String routingKey) {
        return null;
    }
}

