/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.packer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.huieryun.mq.packer.CustomDoubleSerializer;
import com.dtyunxi.huieryun.mq.packer.CustomFloatSerializer;
import com.dtyunxi.huieryun.mq.packer.CustomIntegerSerializer;
import com.dtyunxi.huieryun.mq.packer.CustomLongSerializer;
import com.dtyunxi.huieryun.mq.packer.ISerializeBytePacker;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializeBytePacker
implements ISerializeBytePacker {
    private static Logger logger = LoggerFactory.getLogger(JsonSerializeBytePacker.class);
    private static Charset CHARSET = Charset.forName("utf8");
    private static SerializeConfig config = SerializeConfig.globalInstance;

    @Override
    public byte[] serialize(Object obj) {
        String jsonString = JSON.toJSONString((Object)obj, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            return jsonString.getBytes(CHARSET);
        }
        return new byte[0];
    }

    @Override
    public <T> Object deSerialize(byte[] in, Class<?> clazz) {
        if (in != null && in.length > 0) {
            String jsonString = new String(in, CHARSET);
            return JSON.parseObject((String)jsonString, clazz);
        }
        return null;
    }

    @Override
    public <T> Object deSerialize(byte[] in, Type type) {
        if (in != null && in.length > 0) {
            String jsonString = new String(in, CHARSET);
            return JSON.parseObject((String)jsonString, (Type)type, (Feature[])new Feature[0]);
        }
        return null;
    }

    static {
        config.put(Double.class, (ObjectSerializer)CustomDoubleSerializer.instance);
        config.put(Float.class, (ObjectSerializer)CustomFloatSerializer.instance);
        config.put(Byte.class, (ObjectSerializer)CustomIntegerSerializer.instance);
        config.put(Short.class, (ObjectSerializer)CustomIntegerSerializer.instance);
        config.put(Long.class, (ObjectSerializer)CustomLongSerializer.instance);
    }
}

