/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.vo;

import com.dtyunxi.exceptions.SystemException;
import com.dtyunxi.huieryun.mq.packer.ISerializeBytePacker;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(description="\u6d88\u606f\u914d\u7f6e")
public class MessageRegistryVo
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MessageRegistryVo.class);
    private static final long serialVersionUID = -1109182977408026745L;
    @ApiModelProperty(value="\u8c03\u7528\u7c7b\u578b")
    protected String type;
    @ApiModelProperty(value="\u8fde\u63a5\u5730\u5740 url\u6216IP")
    protected String host;
    @ApiModelProperty(value="\u7aef\u53e3\u53f7\uff0c\u5f53Host\u4e3aIP\u65f6")
    protected String port;
    @ApiModelProperty(value="\u7528\u6237\u540d\u6216\u963f\u91cc\u4e91AK")
    protected String username;
    @ApiModelProperty(value="\u5bc6\u7801\u6216\u963f\u91cc\u4e91SK")
    protected String password;
    @ApiModelProperty(value="RabbitMQ\u865a\u62df\u4e3b\u673a")
    protected String virtualHost = "/";
    @ApiModelProperty(value="\u901a\u9053")
    protected String tunnel;
    @ApiModelProperty(value="\u591a\u4e2a\u5730\u5740\u6216\u8005RocketMQ\u96c6\u7fa4\u5730\u5740\u5217\u8868\u6216\u8005kafka brokers\u5730\u5740\u5217\u8868")
    protected String[] addresses;
    @ApiModelProperty(value="\u4e3b\u9898\u540d\u79f0")
    protected String topicName;
    @ApiModelProperty(value="\u963f\u91cc\u4e91\u751f\u4ea7\u8005ID")
    @Deprecated
    protected String producerId;
    @ApiModelProperty(value="\u6d88\u8d39\u8005ID\u6216\u8005\u6d88\u8d39\u8005\u6240\u5c5e\u7ec4\u540d\u6216\u8005kafka \u6d88\u8d39\u8005groupId")
    protected String consumerId;
    @ApiModelProperty(value="\u8bbe\u7f6e\u6d88\u8d39\u7ebf\u7a0b\u6570\u91cf,\u9ed8\u8ba4\u521d\u59cb\u5316CPU\u6838\u6570")
    protected int consumeThreadNums = Runtime.getRuntime().availableProcessors();
    @ApiModelProperty(value="\u5f53\u524d\u7ebf\u7a0b\u7684\u670d\u52a1\u4e0a\u4e0b\u6587\u53d8\u91cf\u4f20\u9012")
    protected boolean passSvcContext = false;
    @ApiModelProperty(value="MQ\u5b9e\u4f8b\u5e8f\u5217\u5316\u5668\uff0c\u4e3a\u7a7a\u65f6\u4f7f\u7528\u5168\u5c40\u5e8f\u5217\u5316\u5668")
    protected String instancePacker = null;
    private SerializeCode serializeCode;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public String getAddressesString() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        if (this.addresses.length == 1) {
            return this.addresses[0];
        }
        StringBuilder builder = new StringBuilder();
        for (String addresse : this.addresses) {
            if (builder.length() > 1) {
                builder.append(";");
            }
            builder.append(addresse);
        }
        return builder.toString();
    }

    public int getConsumeThreadNums() {
        return this.consumeThreadNums;
    }

    public void setConsumeThreadNums(int consumeThreadNums) {
        this.consumeThreadNums = consumeThreadNums;
    }

    public boolean isPassSvcContext() {
        return this.passSvcContext;
    }

    public void setPassSvcContext(boolean passSvcContext) {
        this.passSvcContext = passSvcContext;
    }

    public void setAddress(String address) {
        if (StringUtils.isNotEmpty((CharSequence)address)) {
            String[] addr = address.split(",");
            this.addresses = new String[addr.length];
            for (int i = 0; i < addr.length; ++i) {
                this.addresses[i] = addr[i];
            }
        }
    }

    public String getInstancePacker() {
        return this.instancePacker;
    }

    public void setInstancePacker(String instancePacker) {
        this.instancePacker = instancePacker;
    }

    public synchronized SerializeCode getSerializeCode() {
        if (this.serializeCode != null) {
            return this.serializeCode;
        }
        ISerializeBytePacker serializeBytePacker = null;
        if (StringUtils.isNotBlank((CharSequence)this.instancePacker)) {
            Class<?> instancePackerClass = null;
            try {
                instancePackerClass = Class.forName(this.instancePacker);
                serializeBytePacker = (ISerializeBytePacker)instancePackerClass.getConstructor(null).newInstance(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("\u521d\u59cb\u5316\u5e8f\u5217\u5316\u5668\u51fa\u9519\uff01", (Throwable)e);
                throw new SystemException((Throwable)e);
            }
        }
        return new SerializeCode(serializeBytePacker);
    }

    public String toString() {
        return "MessageRegistryVo [type=" + this.type + ", host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + "]";
    }
}

