/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.io.BaseEncoding;
import io.minio.PostPolicy;
import io.minio.Signer;
import io.minio.Time;
import io.minio.credentials.Credentials;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class AwsPostPolicy
extends PostPolicy {
    private static final List<String> RESERVED_ELEMENTS = Arrays.asList("bucket", "x-amz-algorithm", "x-amz-credential", "x-amz-date", "policy", "x-amz-signature");
    private static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String EQ = "eq";
    private static final String STARTS_WITH = "starts-with";
    protected static final String LF = "\n";
    private String bucketName;
    private ZonedDateTime expiration;
    private Map<String, Map<String, String>> conditions;
    private Integer lowerLimit = null;
    private Integer upperLimit = null;

    public AwsPostPolicy(@Nonnull String bucketName, @Nonnull ZonedDateTime expiration) {
        super(bucketName, expiration);
        LinkedHashMap<String, Map<String, String>> conditions = new LinkedHashMap<String, Map<String, String>>();
        conditions.put(EQ, new LinkedHashMap());
        conditions.put(STARTS_WITH, new LinkedHashMap());
        this.bucketName = bucketName;
        this.expiration = expiration;
        this.conditions = conditions;
    }

    private String trimDollar(String element) {
        return element.startsWith("$") ? element.substring(1, element.length()) : element;
    }

    public void addEqualsCondition(@Nonnull String element, @Nonnull String value) {
        if (element.isEmpty()) {
            throw new IllegalArgumentException("condition element cannot be empty");
        }
        if ("success_action_redirect".equals(element = this.trimDollar(element)) || "redirect".equals(element) || "content-length-range".equals(element)) {
            throw new IllegalArgumentException(element + " is unsupported for equals condition");
        }
        if (RESERVED_ELEMENTS.contains(element)) {
            throw new IllegalArgumentException(element + " cannot be set");
        }
        this.conditions.get(EQ).put(element, value);
    }

    public void removeEqualsCondition(@Nonnull String element) {
        if (element.isEmpty()) {
            throw new IllegalArgumentException("condition element cannot be empty");
        }
        this.conditions.get(EQ).remove(this.trimDollar(element));
    }

    public void addStartsWithCondition(@Nonnull String element, @Nonnull String value) {
        if (element.isEmpty()) {
            throw new IllegalArgumentException("condition element cannot be empty");
        }
        if ("success_action_status".equals(element = this.trimDollar(element)) || "content-length-range".equals(element) || element.startsWith("x-amz-") && !element.startsWith("x-amz-meta-")) {
            throw new IllegalArgumentException(element + " is unsupported for starts-with condition");
        }
        if (RESERVED_ELEMENTS.contains(element)) {
            throw new IllegalArgumentException(element + " cannot be set");
        }
        this.conditions.get(STARTS_WITH).put(element, value);
    }

    public void removeStartsWithCondition(String element) {
        if (element.isEmpty()) {
            throw new IllegalArgumentException("condition element cannot be empty");
        }
        this.conditions.get(STARTS_WITH).remove(this.trimDollar(element));
    }

    public void addContentLengthRangeCondition(int lowerLimit, int upperLimit) {
        if (lowerLimit < 0) {
            throw new IllegalArgumentException("lower limit cannot be negative number");
        }
        if (upperLimit < 0) {
            throw new IllegalArgumentException("upper limit cannot be negative number");
        }
        if (lowerLimit > upperLimit) {
            throw new IllegalArgumentException("lower limit cannot be greater than upper limit");
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public void removeContentLengthRangeCondition() {
        this.lowerLimit = null;
        this.upperLimit = null;
    }

    private String quote(String value) {
        return "\"" + value + "\"";
    }

    private StringBuilder addCondition(StringBuilder sb, String condition, String element, String value, boolean isEnd) {
        sb.append("    [").append(this.quote(condition)).append(", ").append(this.quote("$" + element)).append(", ").append(this.quote(value)).append("]");
        return isEnd ? sb : sb.append(",\n");
    }

    public Map<String, String> formData(@Nonnull Credentials creds, @Nonnull String region) throws NoSuchAlgorithmException, InvalidKeyException {
        if (creds == null) {
            throw new IllegalArgumentException("credentials cannot be null");
        }
        if (region.isEmpty()) {
            throw new IllegalArgumentException("region cannot be empty");
        }
        StringBuilder sb = new StringBuilder().append("{\n");
        sb.append("  ").append(this.quote("expiration")).append(": ").append(this.quote(this.expiration.format(Time.EXPIRATION_DATE_FORMAT))).append(",\n");
        sb.append("  ").append(this.quote("conditions")).append(": [\n");
        this.addCondition(sb, EQ, "bucket", this.bucketName, false);
        for (Map.Entry<String, Map<String, String>> condition : this.conditions.entrySet()) {
            for (Map.Entry<String, String> entry : condition.getValue().entrySet()) {
                this.addCondition(sb, condition.getKey(), entry.getKey(), entry.getValue(), false);
            }
        }
        if (this.lowerLimit != null && this.upperLimit != null) {
            sb.append("    [").append(this.quote("content-length-range")).append(", ").append(this.lowerLimit.toString()).append(", ").append(this.upperLimit.toString()).append("],\n");
        }
        ZonedDateTime utcNow = ZonedDateTime.now(Time.UTC);
        String credential = Signer.credential((String)creds.accessKey(), (ZonedDateTime)utcNow, (String)region);
        String amzDate = utcNow.format(Time.AMZ_DATE_FORMAT);
        this.addCondition(sb, EQ, "x-amz-algorithm", ALGORITHM, false);
        this.addCondition(sb, EQ, "x-amz-credential", credential, false);
        if (creds.sessionToken() != null) {
            this.addCondition(sb, EQ, "x-amz-security-token", creds.sessionToken(), false);
        }
        this.addCondition(sb, EQ, "x-amz-date", amzDate, true);
        sb.append("  ]\n");
        sb.append("}");
        String policy = BaseEncoding.base64().encode(sb.toString().getBytes(StandardCharsets.UTF_8));
        String signature = Signer.postPresignV4((String)policy, (String)creds.secretKey(), (ZonedDateTime)utcNow, (String)region);
        HashMap<String, String> formData = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> condition : this.conditions.entrySet()) {
            for (Map.Entry<String, String> entry : condition.getValue().entrySet()) {
                formData.put(entry.getKey(), entry.getValue());
            }
        }
        formData.put("x-amz-algorithm", ALGORITHM);
        formData.put("x-amz-credential", credential);
        if (creds.sessionToken() != null) {
            formData.put("x-amz-security-token", creds.sessionToken());
        }
        formData.put("x-amz-date", amzDate);
        formData.put("policy", policy);
        formData.put("x-amz-signature", signature);
        return formData;
    }

    public String bucket() {
        return this.bucketName;
    }
}

