/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.api;

import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.provider.AliyunObjectStorage;
import com.dtyunxi.huieryun.oss.provider.AmazonS3ObjectStorage;
import com.dtyunxi.huieryun.oss.provider.LocalFileStorage;
import com.dtyunxi.huieryun.oss.provider.SimpleFileStorage;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageFactory {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStorageFactory.class);

    public static IObjectStorageService createObjectStorage(OssRegistryVo ossRegistryVo) {
        AbstractObjectStorageService objectStorageService;
        switch (ossRegistryVo.getOssType().toUpperCase()) {
            case "ALIYUNOSS": {
                objectStorageService = new AliyunObjectStorage();
                break;
            }
            case "LOCALFILESTORAGE": {
                objectStorageService = new LocalFileStorage();
                break;
            }
            case "SIMPLEFILESTORAGE": {
                objectStorageService = new SimpleFileStorage();
                break;
            }
            case "AMAZONS3": {
                objectStorageService = new AmazonS3ObjectStorage();
                break;
            }
            default: {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b");
            }
        }
        objectStorageService.init(ossRegistryVo);
        return objectStorageService;
    }
}

