/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.provider.amazonaws.util.HttpUtils;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.JacksonUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunObjectStorage
extends AbstractObjectStorageService {
    private static final Logger logger = LoggerFactory.getLogger(AliyunObjectStorage.class);
    private OSSClient ossClient = null;

    public OSSClient getOSSClient() {
        return this.ossClient;
    }

    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
        String endpoint = ossRegistryVo.getEndpoint();
        if (StringUtils.isNotEmpty((CharSequence)ossRegistryVo.getBucketName())) {
            endpoint = endpoint.replaceAll(ossRegistryVo.getBucketName() + ".", "");
        }
        this.ossClient = new OSSClient(endpoint, ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret());
    }

    @Override
    public String put(String group, String key, InputStream inputstream) {
        OSSClient ossclient = this.getOSSClient();
        PutObjectResult result = ossclient.putObject(group, key, inputstream);
        return result.getETag();
    }

    @Override
    public void delete(String group, String key) {
        OSSClient ossclient = this.getOSSClient();
        ossclient.deleteObject(group, key);
    }

    @Override
    public boolean exists(String group, String key) {
        OSSClient ossclient = this.getOSSClient();
        Boolean existsBool = ossclient.doesObjectExist(group, key);
        return existsBool;
    }

    @Override
    public Map<String, String> creatPoliy() {
        return this.creatPoliy(this.ossRegistryVo);
    }

    @Override
    public OutputStream get(String key) {
        OutputStream outputStream = null;
        outputStream = key.indexOf("aliyuncs.com") != -1 ? this.getOutputStreamByUrl(key) : this.getOutputStreamByKey(key);
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getOutputStreamByUrl(String fileUrl) {
        ByteArrayOutputStream outputStream = null;
        HttpURLConnection connection = null;
        try {
            URL endpointUrl = new URL(fileUrl);
            connection = HttpUtils.createHttpConnection(endpointUrl, "GET", null);
            InputStream is = connection.getInputStream();
            outputStream = this.getByteArrayOutputStream(is);
        }
        catch (Exception e) {
            logger.error("error getOutputStreamByUrl : ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getByteArrayOutputStream(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int lenght = 0;
        try {
            while ((lenght = is.read(buffer)) != -1) {
                out.write(buffer, 0, lenght);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to close InputStream :", (Throwable)e);
            }
        }
        return out;
    }

    private OutputStream getOutputStreamByKey(String key) {
        OSSClient ossClient = this.getOSSClient();
        OSSObject ossObject = ossClient.getObject(new GetObjectRequest(this.ossRegistryVo.getBucketName(), key));
        return this.getOutputStreamByKey(ossObject);
    }

    private OutputStream getOutputStreamByKey(OSSObject ossObject) {
        ByteArrayOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            LogUtils.logException((String)"Cannot read object content stream: ", (Object)ex);
            throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), (Throwable)ex);
        }
        finally {
            IOUtils.safeClose((OutputStream)outputStream);
            IOUtils.safeClose((InputStream)ossObject.getObjectContent());
        }
        return outputStream;
    }

    private OutputStream getOutputStreamByKey(String key, String bucketName) {
        OSSClient ossClient = this.getOSSClient();
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        OSSObject ossObject = ossClient.getObject(new GetObjectRequest(bucketName, key));
        return this.getOutputStreamByKey(ossObject);
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        OSSClient ossclient = this.getOSSClient();
        PutObjectResult result = ossclient.putObject(group, key, new File(fileUrl));
        return result.getETag();
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        return null;
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        return null;
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo registryVo) {
        String dir = registryVo.getDir();
        OSSClient client = new OSSClient(registryVo.getEndpoint(), registryVo.getAccessKeyId(), registryVo.getAccessKeySecret());
        long expireTime = 120L;
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        try {
            String postPolicy = client.generatePostPolicy((java.util.Date)expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", registryVo.getAccessKeyId());
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", registryVo.getEndpoint());
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            respMap.put("cdnHost", registryVo.getCdnHost());
            respMap.put("extProperty", registryVo.getExtProperty() == null ? "" : JacksonUtil.toJson((Object)registryVo.getExtProperty()));
            LinkedHashMap<String, String> linkedHashMap = respMap;
            return linkedHashMap;
        }
        catch (ClientException | UnsupportedEncodingException e) {
            logger.error("Compute Signature Failure:", e);
            throw new RuntimeException("Compute Signature Failure:", e);
        }
        finally {
            client.shutdown();
        }
    }

    @Override
    public OutputStream get(String key, String bucketName) {
        OutputStream outputStream = null;
        outputStream = key.indexOf("aliyuncs.com") != -1 ? this.getOutputStreamByUrl(key) : this.getOutputStreamByKey(key, bucketName);
        return outputStream;
    }
}

