/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileStorage
extends AbstractObjectStorageService {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileStorage.class);

    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
    }

    @Override
    public String put(String group, String key, InputStream inputstream) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.addBinaryBody("file", inputstream, ContentType.APPLICATION_OCTET_STREAM, key);
        HttpEntity entity = entityBuilder.build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(this.getUrl("upload", group, key));
        post.setEntity(entity);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u7801\uff1a{}", (Object)response.getStatusLine());
        }
        catch (IOException e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getUrl(String ops, String group, String key) {
        String paramGroup = "group=" + group;
        String paramKey = "key=" + key;
        return this.ossRegistryVo.getEndpoint() + "/" + ops + "?" + paramGroup + "&" + paramKey;
    }

    @Override
    public void delete(String group, String key) {
        try {
            HttpDelete httpDelete = new HttpDelete(this.getUrl("delete", group, key));
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpDelete);
            logger.info("\u5220\u9664\u6587\u4ef6\u54cd\u5e94\u7801\uff1a{}", (Object)httpResponse.getStatusLine());
        }
        catch (IOException e) {
            logger.error("\u5220\u9664\u5931\u8d25\uff01group={},key={}", new Object[]{group, key, e});
        }
    }

    @Override
    public boolean exists(String group, String key) {
        try {
            String value;
            HttpGet httpGet = new HttpGet(this.getUrl("exists", group, key));
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity != null && (value = EntityUtils.toString((HttpEntity)responseEntity)) != null && value.startsWith("true")) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error("\u5224\u65ad\u6587\u4ef6\u5931\u8d25\uff01group={},key={}", new Object[]{group, key, e});
        }
        return false;
    }

    public void download(String group, String key) {
        try {
            HttpGet httpGet = new HttpGet(this.getUrl("download", group, key));
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u54cd\u5e94\u7801\uff1a{}", (Object)response.getStatusLine());
        }
        catch (IOException e) {
            logger.error("\u5224\u65ad\u6587\u4ef6\u5931\u8d25\uff01group={},key={}", new Object[]{group, key, e});
        }
    }

    @Override
    public Map<String, String> creatPoliy() {
        return null;
    }

    @Override
    public OutputStream get(String filename) {
        return null;
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        return null;
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        return null;
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        return null;
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo registryVo) {
        return this.creatPoliy();
    }

    @Override
    public OutputStream get(String key, String bucketName) {
        return this.get(key);
    }
}

