/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.api;

import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.api.PutCallBack;
import com.dtyunxi.huieryun.oss.vo.ObjectStorageDto;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class AbstractObjectStorageService
implements IObjectStorageService {
    protected OssRegistryVo ossRegistryVo;
    protected ThreadPoolTaskExecutor threadPool;
    protected static final String BACKSLASH = "/";

    public abstract void init(OssRegistryVo var1, ThreadPoolTaskExecutor var2);

    @Override
    public Map<String, String> createPolicy() {
        return this.createPolicy(this.ossRegistryVo, null);
    }

    @Override
    public Map<String, String> createPolicy(OssRegistryVo registryVo) {
        return this.createPolicy(registryVo, null);
    }

    @Override
    public Map<String, String> createPolicy(String fileType) {
        return this.createPolicy(this.ossRegistryVo, null);
    }

    protected String getSaveFilePath(String fileName) {
        if (fileName.contains(BACKSLASH)) {
            String[] arrays = fileName.split(BACKSLASH);
            String dir = this.ossRegistryVo.getDir().replace(BACKSLASH, "");
            if (Arrays.asList(arrays).contains(dir)) {
                return fileName;
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.ossRegistryVo.getDir());
        builder.append(fileName);
        return builder.toString();
    }

    @Override
    public String putAsync(String bucketName, String objectName, byte[] bytes, PutCallBack putCallBack) {
        ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
        return this.putAsync(bucketName, objectName, inputstream, putCallBack);
    }

    @Override
    public String putAsync(String bucketName, String objectName, InputStream inputstream, PutCallBack putCallBack) {
        String filePath = this.getSaveFilePath(objectName);
        ObjectStorageDto objectStorageDto = new ObjectStorageDto();
        objectStorageDto.setBucketName(bucketName);
        objectStorageDto.setObjectName(filePath);
        objectStorageDto.setInputStream(inputstream);
        this.threadPool.submit(this.createAsyncPutCallable(objectStorageDto, putCallBack));
        return filePath;
    }

    @Override
    public String putAsync(String bucketName, String objectName, String fileUrl, PutCallBack putCallBack) {
        try {
            InputStream inputStream = new URL(fileUrl).openStream();
            return this.putAsync(bucketName, objectName, inputStream, putCallBack);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
    }

    @Override
    public String getFileUrl(String objectName) {
        String endpoint = this.ossRegistryVo.getEndpoint();
        String bucketName = this.ossRegistryVo.getBucketName();
        String filePath = this.getSaveFilePath(objectName);
        if (endpoint.startsWith("https://" + bucketName)) {
            return endpoint + BACKSLASH + filePath;
        }
        return endpoint + BACKSLASH + bucketName + BACKSLASH + filePath;
    }

    protected Callable<Boolean> createAsyncPutCallable(ObjectStorageDto objectStorageDto, PutCallBack putCallBack) {
        return () -> {
            try {
                InputStream inputStream = objectStorageDto.getInputStream();
                if (null != inputStream) {
                    this.put(objectStorageDto.getBucketName(), objectStorageDto.getObjectName(), objectStorageDto.getInputStream());
                } else {
                    this.put(objectStorageDto.getBucketName(), objectStorageDto.getObjectName(), objectStorageDto.getFileUrl());
                }
                putCallBack.onSuccess(this.ossRegistryVo.getEndpoint() + BACKSLASH + objectStorageDto.getObjectName());
            }
            catch (Exception e) {
                putCallBack.onException(e, objectStorageDto.getObjectName());
            }
            return true;
        };
    }
}

