/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.api;

import cn.hutool.core.io.FileUtil;
import com.dtyunxi.annotation.DeprecatedDescForJDK8;
import com.dtyunxi.huieryun.oss.api.IObjectInputStreamProcessor;
import com.dtyunxi.huieryun.oss.api.PutCallBack;
import com.dtyunxi.huieryun.oss.enums.ObjectStorageType;
import com.dtyunxi.huieryun.oss.provider.domain.BatchDownloadParam;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;

public interface IObjectStorageService {
    @Deprecated
    public static final String TYPE_ALIYUNOSS = ObjectStorageType.ALIYUNOSS.name();
    @Deprecated
    public static final String TYPE_LOCALFILESTORAGE = ObjectStorageType.LOCALFILESTORAGE.name();
    @Deprecated
    public static final String TYPE_SIMPLEFILESTORAGE = ObjectStorageType.SIMPLEFILESTORAGE.name();
    @Deprecated
    public static final String TYPE_AMAZONS3 = ObjectStorageType.AMAZONS3.name();

    default public String put(String bucketName, String objectName, byte[] bytes) {
        return this.put(bucketName, objectName, new ByteArrayInputStream(bytes));
    }

    public String put(String var1, String var2, InputStream var3);

    default public String put(String bucketName, String objectName, String fileUrl) {
        try {
            InputStream inputStream = null;
            try {
                URL url = new URL(fileUrl);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                inputStream = FileUtil.getInputStream((String)fileUrl);
            }
            return this.put(bucketName, objectName, inputStream);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read filename: ", (Throwable)e);
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
    }

    public String putAsync(String var1, String var2, byte[] var3, PutCallBack var4);

    public String putAsync(String var1, String var2, InputStream var3, PutCallBack var4);

    public String putAsync(String var1, String var2, String var3, PutCallBack var4);

    public void delete(String var1, String var2);

    public boolean exists(String var1, String var2);

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="createPolicy()", forRemoval=true)
    default public Map<String, String> creatPoliy() {
        return this.createPolicy();
    }

    public Map<String, String> createPolicy();

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="createPolicy(String fileType)", forRemoval=true)
    default public Map<String, String> creatPoliy(String fileType) {
        return this.createPolicy(fileType);
    }

    public Map<String, String> createPolicy(String var1);

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="createPolicy(OssRegistryVo registryVo)", forRemoval=true)
    default public Map<String, String> creatPoliy(OssRegistryVo registryVo) {
        return this.createPolicy(registryVo);
    }

    public Map<String, String> createPolicy(OssRegistryVo var1);

    @Deprecated
    @DeprecatedDescForJDK8(since="1.2.0", replaceBy="createPolicy(OssRegistryVo registryVo)", forRemoval=true)
    default public Map<String, String> creatPoliy(OssRegistryVo registryVo, String fileType) {
        return this.createPolicy(registryVo, fileType);
    }

    public Map<String, String> createPolicy(OssRegistryVo var1, String var2);

    public Map<String, String> createSts(OssRegistryVo var1, TempSignCreateParam var2);

    public OutputStream get(String var1);

    default public void get(String fileURI, IObjectInputStreamProcessor processor) {
        this.get(fileURI, null, processor);
    }

    public Map<String, String> createGetFileSignerHeader(String var1);

    public String getFileUrlWithQureyParamter(String var1, int var2);

    public OutputStream get(String var1, String var2);

    public void get(String var1, String var2, IObjectInputStreamProcessor var3);

    default public String getBatchFileUri(BatchDownloadParam batchDownloadParam) {
        throw new UnsupportedOperationException("\u8be5\u65b9\u6cd5\u76ee\u524d\u53ea\u652f\u6301\u963f\u91cc\u4e91\u5bf9\u8c61\u5b58\u50a8\uff01");
    }

    public String getFileUrl(String var1);

    public Logger getLogger();
}

