/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.rest;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.api.ObjectStorageFactory;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.enums.ObjectStorageType;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/huieryun/objectstorage/policy"})
@Api(tags={"\u83b7\u53d6OSS\u7684\u8bbf\u95ee\u8bb8\u53ef"})
public class OssPolicyController {
    private static Logger logger = LoggerFactory.getLogger(OssPolicyController.class);
    private static final Pattern GET_HOST_FROM_ENDPIONT = Pattern.compile("(http://|https://)?([a-zA-Z\\-0-9]+).([a-zA-Z\\-0-9.]+)");

    public OssPolicyController(Environment env) {
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u4e34\u65f6\u6388\u6743", notes="\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u4e34\u65f6\u6388\u6743", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/getpolicy"}, method={RequestMethod.GET})
    public RestResponse<?> applyPolicy(@PathVariable(required=false) String appId, @RequestParam(value="bucketKey", required=false) String bucketKey, @RequestParam(value="fileType", required=false) String fileType) {
        logger.info("OssConstant.APP_ID:{}, appId:{}", (Object)OssConstant.APP_ID, (Object)appId);
        OssRegistryVo registryVo = OssConstant.registryVo;
        if (StringUtils.isNotEmpty((CharSequence)bucketKey)) {
            registryVo = this.assembleRegistryVo(bucketKey);
        }
        if (null == registryVo) {
            return new RestResponse("10001", "bucketKey \u9519\u8bef\uff01");
        }
        try {
            IObjectStorageService service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)OssConstant.registryVo);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileType}) && !fileType.contains("/")) {
                fileType = fileType + "/";
            }
            Map respMap = service.createPolicy(registryVo, fileType);
            return new RestResponse((Object)respMap);
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u9519\u8bef,{} ", (Object)e.getMessage(), (Object)e);
            return new RestResponse("500", "\u6388\u6743\u9519\u8bef");
        }
    }

    @ApiOperation(value="sts\u7b7e\u540d\u63a5\u53e3", notes="sts\u7b7e\u540d\u63a5\u53e3,\u4ec5\u652f\u6301\u963f\u91cc\u4e91OSS", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/sts"}, method={RequestMethod.GET})
    public RestResponse<?> stsAuth(@PathVariable(required=false) String appId, @RequestParam(value="bucketKey", required=false) String bucketKey) {
        OssRegistryVo registryVo = OssConstant.registryVo;
        if (StringUtils.isNotEmpty((CharSequence)bucketKey)) {
            registryVo = this.assembleRegistryVo(bucketKey);
        }
        if (null == registryVo) {
            return new RestResponse("10001", "bucketKey \u9519\u8bef\uff01");
        }
        String bucketName = registryVo.getBucketName();
        String endPoint = registryVo.getEndpoint();
        if (StringUtils.isBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)endPoint)) {
            Matcher m = GET_HOST_FROM_ENDPIONT.matcher(endPoint);
            if (!m.find()) {
                throw new BusinessRuntimeException("\u672a\u4ece{" + endPoint + "}\u4e2d\u63d0\u53d6BucketName,\u53caoss\u8282\u70b9\u5730\u5740.\u82e5\u9759\u6001\u7f51\u7ad9\u5730\u5740\u4e3a\u81ea\u5b9a\u4e49\u57df\u540d\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u4fee\u6539\u4ee3\u7801");
            }
            bucketName = m.group(2);
            endPoint = m.group(3);
            registryVo = this.assembleRegistryVo(bucketName);
            registryVo.setEndpoint(endPoint);
        }
        IObjectStorageService service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)registryVo);
        TempSignCreateParam tempSignCreateParam = new TempSignCreateParam();
        tempSignCreateParam.setDurationSecond(1000L);
        Map respMap = service.createSts(registryVo, tempSignCreateParam);
        if (null == respMap) {
            return new RestResponse("500", "\u6388\u6743\u9519\u8bef");
        }
        return new RestResponse((Object)respMap);
    }

    @ApiOperation(value="sts\u7b7e\u540d\u63a5\u53e3", notes="sts\u7b7e\u540d\u63a5\u53e3", response=RestResponse.class)
    @RequestMapping(value={"/sts"}, method={RequestMethod.POST})
    public RestResponse<?> createTemporarySignature(@RequestBody TempSignCreateParam tempSignCreateDto) {
        IObjectStorageService service;
        Map respMap;
        if (tempSignCreateDto == null) {
            return new RestResponse("10001", "\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570\uff0c\u8bf7\u7528POST\u65b9\u6cd5\u53d1\u8d77");
        }
        String appId = tempSignCreateDto.getAppId();
        OssRegistryVo registryVo = OssConstant.registryVo;
        String bucketKey = registryVo.getBucketName();
        if (StringUtils.isNotEmpty((CharSequence)bucketKey)) {
            registryVo = this.assembleRegistryVo(bucketKey);
        }
        if (null == registryVo) {
            return new RestResponse("10001", "bucketKey \u9519\u8bef\uff01");
        }
        String bucketName = registryVo.getBucketName();
        String endPoint = registryVo.getEndpoint();
        if (StringUtils.isBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)endPoint)) {
            Matcher m = GET_HOST_FROM_ENDPIONT.matcher(endPoint);
            if (!m.find()) {
                throw new BusinessRuntimeException("\u672a\u4ece{" + endPoint + "}\u4e2d\u63d0\u53d6BucketName,\u53caoss\u8282\u70b9\u5730\u5740.\u82e5\u9759\u6001\u7f51\u7ad9\u5730\u5740\u4e3a\u81ea\u5b9a\u4e49\u57df\u540d\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u4fee\u6539\u4ee3\u7801");
            }
            bucketName = m.group(2);
            endPoint = m.group(3);
            registryVo = this.assembleRegistryVo(bucketName);
            registryVo.setEndpoint(endPoint);
        }
        if (tempSignCreateDto.getDurationSecond() <= 0L) {
            tempSignCreateDto.setDurationSecond(60L);
        }
        if (null == (respMap = (service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)registryVo)).createSts(registryVo, tempSignCreateDto))) {
            return new RestResponse("500", "\u6388\u6743\u9519\u8bef");
        }
        return new RestResponse((Object)respMap);
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u6388\u6743\u7684\u4e0b\u8f7d\u5730\u5740", notes="\u83b7\u53d6\u6587\u4ef6\u6388\u6743\u7684\u4e0b\u8f7d\u5730\u5740", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/get-authorized-file-url"}, method={RequestMethod.GET})
    public RestResponse<String> getAuthorizedFileUrl(@PathVariable(required=false) String appId, @RequestParam String fileURI) {
        logger.info("OssConstant.APP_ID:{}, appId:{}", (Object)OssConstant.APP_ID, (Object)appId);
        if (null == OssConstant.registryVo) {
            return new RestResponse("10001", "bucketKey \u9519\u8bef\uff01");
        }
        OssRegistryVo ossRegistryVo = OssConstant.registryVo;
        IObjectStorageService service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)ossRegistryVo);
        if (fileURI.startsWith(ossRegistryVo.getBucketName())) {
            fileURI = fileURI.replaceFirst(ossRegistryVo.getBucketName(), "");
        }
        if (fileURI.startsWith("/") && !ossRegistryVo.getOssType().equalsIgnoreCase(ObjectStorageType.AMAZONS3.name())) {
            fileURI = fileURI.replaceFirst("/", "");
        }
        return new RestResponse((Object)service.getFileUrlWithQureyParamter(fileURI, ossRegistryVo.getExpireHour()));
    }

    private OssRegistryVo assembleRegistryVo(String bucketKey) {
        OssRegistryVo registryVo = null;
        String bucketName = null;
        if (null != OssConstant.registryVo) {
            if (null != OssConstant.registryVo.getExtProperty()) {
                bucketName = (String)OssConstant.registryVo.getExtProperty().get(bucketKey);
            }
            if (StrUtil.isBlank(bucketName)) {
                bucketName = bucketKey;
            }
            registryVo = (OssRegistryVo)ObjectUtil.cloneByStream((Object)OssConstant.registryVo);
        }
        if (null != registryVo) {
            if (StringUtils.isNotEmpty((CharSequence)registryVo.getEndpoint()) && StringUtils.isNotEmpty((CharSequence)registryVo.getBucketName())) {
                registryVo.setEndpoint(registryVo.getEndpoint().replaceAll(registryVo.getBucketName(), bucketName));
            }
            registryVo.setBucketName(bucketName);
        }
        return registryVo;
    }
}

