/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.provider.es6;

import com.dtyunxi.huieryun.opensearch.api.AbstractSearchIndexService;
import com.dtyunxi.huieryun.opensearch.provider.es6.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchIndexDocVo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RestIndexService
extends AbstractSearchIndexService {
    private static final Logger logger = LoggerFactory.getLogger(RestIndexService.class);
    private RestHighLevelClient client = null;

    public void init(OpenSearchVo openSearchVo) {
        this.openSearchVo = openSearchVo;
        this.client = RestSearchClientUtils.createClient(openSearchVo);
    }

    public void addDatas(List<IndexDocumentVo> docs) {
        if (CollectionUtils.isEmpty(docs)) {
            return;
        }
        for (IndexDocumentVo doc : docs) {
            this.addData(doc);
        }
    }

    public void addData(IndexDocumentVo doc) {
        if (doc == null || CollectionUtils.isEmpty((Collection)doc.getContents())) {
            return;
        }
        doc.validate(false);
        if (doc.getContents().size() > 1) {
            this.addBatchDocs(doc);
        } else {
            this.addSingleDocs(doc);
        }
    }

    protected void addBatchDocs(IndexDocumentVo doc) {
        BulkResponse response;
        BulkRequest bulkRequest = new BulkRequest();
        for (IndexDocContentVo content : doc.getContents()) {
            bulkRequest.add(this.buildAddIndexRequest(doc, content));
        }
        try {
            response = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("addBatchDocs", e);
        }
        String failureMessage = this.buildFailureMessage(response);
        if (failureMessage != null) {
            throw new RuntimeException(String.format("Add batch index failure, response status=%s", failureMessage));
        }
    }

    protected void addSingleDocs(IndexDocumentVo doc) {
        IndexResponse response;
        try {
            response = this.client.index(this.buildAddIndexRequest(doc, (IndexDocContentVo)doc.getContents().get(0)), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response.status() != RestStatus.CREATED && response.status() != RestStatus.OK) {
            throw new RuntimeException(String.format("Add index failure, response status:%s", response.status().toString()));
        }
    }

    protected String buildFailureMessage(BulkResponse response) {
        if (!response.hasFailures()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < response.getItems().length; ++i) {
            BulkItemResponse itemRespone = response.getItems()[i];
            if (!itemRespone.isFailed() || itemRespone.getFailure().getCause().getClass().equals(VersionConflictEngineException.class)) continue;
            sb.append("\n[").append(i).append("]: index [").append(itemRespone.getIndex()).append("], type [").append(itemRespone.getType()).append("], id [").append(itemRespone.getId()).append("], message [").append(itemRespone.getFailureMessage()).append("]");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    protected IndexRequest buildAddIndexRequest(IndexDocumentVo doc, IndexDocContentVo content) {
        IndexRequest request = new IndexRequest(doc.getIndexName(), "_doc").id(content.getIndexId()).source(content.getDocValueMap());
        if (null != content.getRouting()) {
            request.routing(content.getRouting());
        }
        return request;
    }

    public void updateData(IndexDocumentVo doc) {
        if (doc == null || CollectionUtils.isEmpty((Collection)doc.getContents())) {
            return;
        }
        doc.validate(false);
        if (doc.getContents().size() > 1) {
            this.updateBatchDocs(doc);
        } else {
            this.updateSingleDocs(doc);
        }
    }

    protected void updateBatchDocs(IndexDocumentVo doc) {
        BulkResponse response;
        BulkRequest bulkRequest = new BulkRequest();
        for (IndexDocContentVo content : doc.getContents()) {
            bulkRequest.add(this.buildUpdateIndexRequest(doc, content));
        }
        try {
            response = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("updateBatchDocs", e);
        }
        String failureMessage = this.buildFailureMessage(response);
        if (failureMessage != null) {
            throw new RuntimeException(String.format("Update batch index failure, response status=%s", failureMessage));
        }
    }

    protected void updateSingleDocs(IndexDocumentVo doc) {
        UpdateResponse response;
        try {
            response = this.client.update(this.buildUpdateIndexRequest(doc, (IndexDocContentVo)doc.getContents().get(0)), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response.status() != RestStatus.CREATED && response.status() != RestStatus.OK) {
            throw new RuntimeException(String.format("Update index failure, response status:%s", response.status().toString()));
        }
    }

    protected UpdateRequest buildUpdateIndexRequest(IndexDocumentVo doc, IndexDocContentVo content) {
        UpdateRequest request = new UpdateRequest(doc.getIndexName(), "_doc", content.getIndexId()).docAsUpsert(true).doc(content.getDocValueMap());
        if (null != content.getRouting()) {
            request.routing(content.getRouting());
        }
        if (doc.getRetryOnConflict() > 0) {
            request.retryOnConflict(doc.getRetryOnConflict());
        }
        return request;
    }

    public void deleteData(IndexDocumentVo doc) {
        if (doc == null || CollectionUtils.isEmpty((Collection)doc.getContents())) {
            return;
        }
        doc.validate(true);
        if (doc.getContents().size() > 1) {
            this.deleteBatchDocs(doc);
        } else {
            this.deleteSingleDocs(doc);
        }
    }

    protected void deleteBatchDocs(IndexDocumentVo doc) {
        BulkResponse response;
        BulkRequest bulkRequest = new BulkRequest();
        for (IndexDocContentVo content : doc.getContents()) {
            bulkRequest.add(this.buildDeleteIndexRequest(doc, content));
        }
        try {
            response = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("deleteBatchDocs", e);
        }
        String failureMessage = this.buildFailureMessage(response);
        if (failureMessage != null) {
            throw new RuntimeException(String.format("Delete batch index failure, response status=%s", failureMessage));
        }
    }

    protected void deleteSingleDocs(IndexDocumentVo doc) {
        DeleteResponse response;
        try {
            response = this.client.delete(this.buildDeleteIndexRequest(doc, (IndexDocContentVo)doc.getContents().get(0)), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response.status() != RestStatus.OK && response.status() != RestStatus.NOT_FOUND) {
            throw new RuntimeException(String.format("Delete index failure, response status:%s", response.status().toString()));
        }
    }

    protected DeleteRequest buildDeleteIndexRequest(IndexDocumentVo doc, IndexDocContentVo content) {
        DeleteRequest request = new DeleteRequest(doc.getIndexName(), "_doc", content.getIndexId());
        if (null != content.getRouting()) {
            request.routing(content.getRouting());
        }
        return request;
    }

    public boolean existIndexDocContent(SearchIndexDocVo doc) {
        GetResponse response;
        if (doc == null) {
            return false;
        }
        doc.validate();
        try {
            response = this.client.get(new GetRequest(doc.getIndexName(), "_doc", doc.getId()), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("existIndexDocContent", e);
        }
        return response.isExists();
    }

    public List<IndexDocContentVo> getIndexDocContent(SearchIndexDocVo doc) {
        if (doc == null) {
            return null;
        }
        doc.validate();
        if (doc.getId() != null) {
            return this.queryDataById(doc);
        }
        return this.queryDataComplexConditions(doc);
    }

    protected List<IndexDocContentVo> queryDataById(SearchIndexDocVo doc) {
        GetResponse response;
        try {
            response = this.client.get(new GetRequest(doc.getIndexName(), "_doc", doc.getId()), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("existIndexDocContent", e);
        }
        ArrayList<IndexDocContentVo> indexDocs = new ArrayList<IndexDocContentVo>(1);
        if (response.isExists()) {
            IndexDocContentVo indexDoc = new IndexDocContentVo();
            indexDoc.setIndexId(response.getId());
            indexDoc.setDocValueMap(response.getSourceAsMap());
            indexDocs.add(indexDoc);
        }
        return indexDocs;
    }

    protected List<IndexDocContentVo> queryDataComplexConditions(SearchIndexDocVo doc) {
        SearchHit[] searchHits;
        SearchResponse response;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (doc.getIds() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (String[])doc.getIds()));
        }
        if (doc.getFilterFields() != null) {
            for (FilterFieldVo field : doc.getFilterFields()) {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)field.getFieldName(), (String)field.getEqualValue()));
            }
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(3L, TimeUnit.SECONDS)).size(doc.getPageSize()).fetchSource(doc.getIncludeFields(), doc.getExcludeFields()).explain(Boolean.valueOf(false)).fetchSource(true).query((QueryBuilder)boolQueryBuilder);
        SearchRequest request = new SearchRequest(new String[]{doc.getIndexName()}).source(sourceBuilder);
        if (null != doc.getRouting()) {
            request.routing(doc.getRouting());
        }
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", e);
        }
        SearchHits hits = response.getHits();
        ArrayList<IndexDocContentVo> indexDocs = new ArrayList<IndexDocContentVo>((int)hits.totalHits);
        for (SearchHit searchHit : searchHits = hits.getHits()) {
            IndexDocContentVo indexDoc = new IndexDocContentVo();
            indexDoc.setIndexId(searchHit.getId());
            indexDoc.setDocValueMap(searchHit.getSourceAsMap());
            indexDocs.add(indexDoc);
        }
        return indexDocs;
    }

    protected RestHighLevelClient getClient() {
        return this.client;
    }

    public void closeSearchClient() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            logger.error("closeSearchClient", (Throwable)e);
        }
    }
}

