/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.provider.es6;

import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.util.StringUtils;

public final class RestSearchClientUtils {
    private static Map<Integer, RestHighLevelClient> clientMap = new ConcurrentHashMap<Integer, RestHighLevelClient>(1);

    public static RestHighLevelClient createClient(OpenSearchVo openSearchVo) {
        RestHighLevelClient client;
        if (!clientMap.isEmpty() && (client = clientMap.get(openSearchVo.hashCode())) != null) {
            return client;
        }
        HttpHost[] hosts = (HttpHost[])Arrays.stream(openSearchVo.getAddresses()).map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        if (StringUtils.hasText((String)openSearchVo.getAccessKey())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(openSearchVo.getAccessKey(), openSearchVo.getSecret());
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            builder.setHttpClientConfigCallback(arg_0 -> RestSearchClientUtils.lambda$createClient$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        client = new RestHighLevelClient(builder);
        clientMap.put(openSearchVo.hashCode(), client);
        return client;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

