/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.utils;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CustomBeanUtils {
    private static final TypeReference<Map<String, Object>> mapTypeRef = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<List<Map<String, Object>>> mapsTypeRef = new TypeReference<List<Map<String, Object>>>(){};
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T populate(Map<String, ? extends Object> properties, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(objectMapper.writeValueAsBytes(properties), valueType);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("CustomBeanUtils.populate(Map<String, ? extends Object> properties,Class<T> valueType)\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    public static Map<String, Object> describe(Object bean) {
        try {
            return (Map)objectMapper.readValue(objectMapper.writeValueAsBytes(bean), mapTypeRef);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("CustomBeanUtils.describe(Object bean)\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    public static Map<String, Object> convertMap(Map<String, String> tempMap) {
        return tempMap;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(Collection<T> objList) {
        try {
            return (List)objectMapper.readValue(objectMapper.writeValueAsBytes(objList), mapsTypeRef);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("CustomBeanUtils.objectsToMaps(Collection<T> objList)\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    public static <T> String toJson(T t) {
        if (t.getClass().isPrimitive()) {
            return String.valueOf(t);
        }
        if (t.getClass().getName().startsWith("java.lang")) {
            return t.toString();
        }
        try {
            String result = objectMapper.writeValueAsString(t);
            if (null != result && !result.startsWith("{") && result.startsWith("\"")) {
                result = result.replace("\"", "");
            }
            return result;
        }
        catch (JsonProcessingException e) {
            throw new BusinessRuntimeException("CustomBeanUtils.toJson(T t)\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }
}

