/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.vo;

import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.AggFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoDistanceFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.QueryFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.RangeVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchBaseVo;
import com.dtyunxi.huieryun.opensearch.vo.SortFieldVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ApiModel(value="OSSearchVo", description="\u641c\u7d22\u6761\u4ef6")
public class OSSearchVo
extends SearchBaseVo {
    protected static final long serialVersionUID = 7821920489966297322L;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u5f53\u524d\u9875\u6570", dataType="int", required=true)
    protected int page = 0;
    @ApiModelProperty(value="\u662f\u5426\u6293\u53d6\u6e90\u6570\u636e", dataType="boolean", required=false)
    protected boolean fetchSource = true;
    @ApiModelProperty(value="\u662f\u5426\u4f7f\u7528\u6e38\u6807\u67e5\u8be2", dataType="boolean", required=false)
    protected boolean useScroll = false;
    @ApiModelProperty(value="\u6e38\u6807\u7ee7\u7eed\u4fdd\u6301\u65f6\u95f4,\u683c\u5f0f\u4e3a\uff1a1ms / 1s / 1m / 1h / 1d,\u65f6\u95f4\u5355\u4f4d\u652f\u6301\uff1ams\u3001s\u3001m\u3001h\u3001d\uff0c\u5206\u522b\u8868\u793a\u6beb\u79d2\u3001\u79d2\u3001\u5206\u3001\u65f6\u3001\u5929", dataType="String", required=false)
    protected String keepAlive;
    @ApiModelProperty(value="\u8fc7\u6ee4\u5b57\u6bb5\u5217\u8868(\u6216\u7ec4\u5408)", dataType="List<FilterFieldVo>", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<FilterFieldVo> orFilterFields;
    @ApiModelProperty(value="\u805a\u5408\u53bb\u91cd\u5b57\u6bb5\u5217\u8868", dataType="List<AggFieldVo>", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<AggFieldVo> aggFields;
    @ApiModelProperty(value="\u9ad8\u4eae\u5b57\u6bb5", dataType="String", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String highlightField;
    @ApiModelProperty(value="\u67e5\u8be2\u9700\u8981\u8fd4\u56de\u5b57\u6bb5\u5217\u8868", dataType="String[]", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String[] includeFields;
    @ApiModelProperty(value="\u67e5\u8be2\u4e0d\u9700\u8981\u8fd4\u56de\u5b57\u6bb5\u5217\u8868", dataType="String[]", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String[] excludeFields;
    @ApiModelProperty(value="\u67e5\u8be2\u5b57\u6bb5\u5217\u8868", dataType="List<QueryFieldVo>", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<QueryFieldVo> queryFields;
    @ApiModelProperty(value="\u8fc7\u6ee4\u5b57\u6bb5\u5217\u8868", dataType="List<FilterFieldVo>", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<FilterFieldVo> filterFields;
    @ApiModelProperty(value="\u6392\u5e8f\u5b57\u6bb5\u5217\u8868", dataType="List<SortFieldVo>", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<SortFieldVo> sortFields;
    @ApiModelProperty(value="geo-distance\u67e5\u8be2\u5b57\u6bb5", dataType="GeoDistanceFieldVo", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<GeoDistanceFieldVo> geoDistanceFields;
    @ApiModelProperty(value="geo-shape\u67e5\u8be2\u5b57\u6bb5", dataType="GeoShapeFieldVo", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<GeoShapeFieldVo> geoShapeFields;

    public final void addGeoDistanceQuery(GeoDistanceFieldVo ... queries) {
        if (queries == null || queries.length == 0) {
            return;
        }
        if (this.geoDistanceFields == null) {
            this.geoDistanceFields = new ArrayList<GeoDistanceFieldVo>(2);
        }
        this.geoDistanceFields.addAll(Arrays.asList(queries));
    }

    public final void addGeoShapeQuery(GeoShapeFieldVo ... queries) {
        if (queries == null || queries.length == 0) {
            return;
        }
        if (this.geoShapeFields == null) {
            this.geoShapeFields = new ArrayList<GeoShapeFieldVo>(2);
        }
        this.geoShapeFields.addAll(Arrays.asList(queries));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5173\u952e\u5b57\u67e5\u8be2", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyWord", value="\u5173\u952e\u5b57", dataType="String", required=true), @ApiImplicitParam(name="fields", value="\u54ea\u4e9b\u5217\uff0cJava\u6cdb\u5316\u7c7b\u578b\uff0c\u53ef\u4ee5\u652f\u6301\u4e00\u4e2a\u6216\u591a\u4e2a", dataType="String", required=true)})
    public final void addQuery(String keyWord, String ... fields) {
        this.addQueries(QueryFieldVo.query(keyWord, fields));
    }

    public final void addQueries(QueryFieldVo ... queries) {
        if (queries == null || queries.length == 0) {
            return;
        }
        if (this.queryFields == null) {
            this.queryFields = new ArrayList<QueryFieldVo>(2);
        }
        this.queryFields.addAll(Arrays.asList(queries));
    }

    public final List<QueryFieldVo> getQueries(String fieldName) {
        if (this.queryFields == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (QueryFieldVo queryField : this.queryFields) {
            if (!Arrays.asList(queryField.getQueryFields()).contains(fieldName)) continue;
            list.add(queryField);
        }
        return list;
    }

    public final void removeQuery(String fieldName) {
        List<QueryFieldVo> list = this.getQueries(fieldName);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.queryFields.removeAll(list);
    }

    public final void addFilters(List<FilterFieldVo> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (FilterFieldVo filterFieldVo : filters) {
            if (filterFieldVo.getLogicalSymbol().equals((Object)LogicalSymbol.AND)) {
                this.initFilterFields();
                this.filterFields.add(filterFieldVo);
                continue;
            }
            this.initOrFilterFields();
            this.orFilterFields.add(filterFieldVo);
        }
    }

    public final void removeFilters(List<FilterFieldVo> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (FilterFieldVo filterFieldVo : filters) {
            if (filterFieldVo.getLogicalSymbol().equals((Object)LogicalSymbol.AND)) {
                this.initFilterFields();
                this.filterFields.remove(filterFieldVo);
                continue;
            }
            this.initOrFilterFields();
            this.orFilterFields.remove(filterFieldVo);
        }
    }

    protected void initOrFilterFields() {
        if (this.orFilterFields == null) {
            this.orFilterFields = new ArrayList<FilterFieldVo>(5);
        }
    }

    protected void initFilterFields() {
        if (this.filterFields == null) {
            this.filterFields = new ArrayList<FilterFieldVo>(5);
        }
    }

    public final void addFilters(FilterFieldVo ... filters) {
        if (filters == null || filters.length == 0) {
            return;
        }
        this.addFilters(Arrays.asList(filters));
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5\uff0c\u9ed8\u8ba4\u4e3a\u964d\u5e8f", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="sortField", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public final void addSort(String sortField) {
        this.addSorts(SortFieldVo.build(sortField));
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6392\u5e8f\u5b57\u6bb5", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f\uff1aASC\u4e3a\u5347\u5e8f DESC\u4e3a\u964d\u5e8f", dataType="SortOrder", required=true)})
    public final void addSort(String sortField, SortOrder order) {
        this.addSorts(SortFieldVo.build(sortField, order));
    }

    public final void addSorts(List<SortFieldVo> sorts) {
        if (sorts == null || sorts.isEmpty()) {
            return;
        }
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortFieldVo>(5);
        }
        this.sortFields.addAll(sorts);
    }

    public final void addSorts(SortFieldVo ... sorts) {
        if (sorts == null || sorts.length == 0) {
            return;
        }
        this.addSorts(Arrays.asList(sorts));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5b57\u6bb5\u503c\u4e0d\u4e3a\u7a7a\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public final void addExistsFilter(String fieldName) {
        this.addFilters(FilterFieldVo.exists(fieldName));
    }

    @ApiOperation(value="\u5355\u503c\u4e0d\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addNonEqualFilter(String fieldName, String equalValue) {
        FilterFieldVo nonEqualFilter = FilterFieldVo.equal(fieldName, equalValue, LogicalSymbol.AND);
        nonEqualFilter.setNon(true);
        this.addFilters(nonEqualFilter);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addEqualFilter(String fieldName, String equalValue) {
        this.addFilters(FilterFieldVo.equal(fieldName, equalValue));
    }

    @ApiOperation(value="\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="operator", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="Operator", required=true)})
    public final void addEqualFilter(String fieldName, String equalValue, LogicalSymbol operator) {
        this.addFilters(FilterFieldVo.equal(fieldName, equalValue, operator));
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="String", required=true)})
    public final void addNonInFilter(String fieldName, String[] inValues) {
        FilterFieldVo nonInFilter = FilterFieldVo.in(fieldName, inValues);
        nonInFilter.setNon(true);
        this.addFilters(nonInFilter);
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="String", required=true)})
    public final void addInFilter(String fieldName, String[] inValues) {
        this.addFilters(FilterFieldVo.in(fieldName, inValues));
    }

    @ApiOperation(value="\u6dfb\u52a0\u591a\u503c\u4efb\u610f\u4e00\u4e2a\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="inValues", value="\u5b57\u6bb5\u503c\uff08\u6570\u7ec4\uff09", dataType="String", required=true)})
    public final void addInFilter(String fieldName, String[] inValues, LogicalSymbol operator) {
        this.addFilters(FilterFieldVo.in(fieldName, inValues, operator));
    }

    @ApiOperation(value="\u6dfb\u52a0\u533a\u95f4\u8fc7\u6ee4(\u975e)", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fromValue", value="\u5b57\u6bb5\u503c\uff08\u5927\u4e8e\u7b49\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="toValue", value="\u5b57\u6bb5\u503c\uff08\u5c0f\u4e8e\uff09", dataType="String", required=true)})
    public final void addNonRangeFilter(String fieldName, String fromValue, String toValue) {
        FilterFieldVo nonRangeFilter = FilterFieldVo.range(fieldName, fromValue, toValue);
        nonRangeFilter.setNon(true);
        this.addFilters(nonRangeFilter);
    }

    @ApiOperation(value="\u6dfb\u52a0\u533a\u95f4\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fromValue", value="\u5b57\u6bb5\u503c\uff08\u5927\u4e8e\u7b49\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="toValue", value="\u5b57\u6bb5\u503c\uff08\u5c0f\u4e8e\uff09", dataType="String", required=true)})
    public final void addRangeFilter(String fieldName, String fromValue, String toValue) {
        this.addFilters(FilterFieldVo.range(fieldName, fromValue, toValue));
    }

    @ApiOperation(value="\u533a\u95f4\u8fc7\u6ee4\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fromValue", value="\u5b57\u6bb5\u503c\uff08\u5927\u4e8e\u7b49\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="toValue", value="\u5b57\u6bb5\u503c\uff08\u5c0f\u4e8e\uff09", dataType="String", required=true), @ApiImplicitParam(name="operator", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="Operator", required=true)})
    public final void addRangeFilter(String fieldName, String fromValue, String toValue, LogicalSymbol operator) {
        this.addFilters(FilterFieldVo.range(fieldName, fromValue, toValue, operator));
    }

    @ApiOperation(value="\u6784\u5efa\u5355\u503c\u524d\u7f00\u5339\u914d", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addPrefixFilter(String fieldName, String likeValue) {
        this.addFilters(FilterFieldVo.prefix(fieldName, likeValue));
    }

    @ApiOperation(value="\u5355\u503c\u524d\u7f00\u5339\u914d\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public final void addPrefixFilter(String fieldName, String likeValue, LogicalSymbol operator) {
        this.addFilters(FilterFieldVo.prefix(fieldName, likeValue, operator));
    }

    @ApiOperation(value="\u6784\u5efa\u5355\u503c\u524d\u7f00\u5339\u914d", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldNames", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addPrefixFilter(String[] fieldNames, String likeValue) {
        this.addPrefixFilter(fieldNames, likeValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u524d\u7f00\u5339\u914d\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=FilterFieldVo.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldNames", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public final void addPrefixFilter(String[] fieldNames, String likeValue, LogicalSymbol operator) {
        FilterFieldVo compoundFilter = FilterFieldVo.compound(operator);
        for (String fieldName : fieldNames) {
            compoundFilter.addSubFilterFieldVos(FilterFieldVo.prefix(fieldName, likeValue, LogicalSymbol.OR));
        }
        this.addFilters(compoundFilter);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addWildcardFilter(String fieldName, String likeValue) {
        this.addFilters(FilterFieldVo.wildcard(fieldName, likeValue));
    }

    @ApiOperation(value="\u5355\u503c\u901a\u914d\u7b26\u5339\u914d\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public final void addWildcardFilter(String fieldName, String likeValue, LogicalSymbol operator) {
        this.addFilters(FilterFieldVo.wildcard(fieldName, likeValue, operator));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5355\u503c\u7b49\u4e8e\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldNames", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addWildcardFilter(String[] fieldNames, String likeValue) {
        this.addWildcardFilter(fieldNames, likeValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u901a\u914d\u7b26\u5339\u914d\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldNames", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="equalValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public final void addWildcardFilter(String[] fieldNames, String likeValue, LogicalSymbol operator) {
        FilterFieldVo compoundFilter = FilterFieldVo.compound(operator);
        for (String fieldName : fieldNames) {
            compoundFilter.addSubFilterFieldVos(FilterFieldVo.wildcard(fieldName, likeValue, LogicalSymbol.OR));
        }
        this.addFilters(compoundFilter);
    }

    @ApiOperation(value="\u5355\u503c\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addRegexpFilter(String fieldName, String likeValue) {
        this.addFilters(FilterFieldVo.regexp(fieldName, likeValue));
    }

    @ApiOperation(value="\u5355\u503c\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public final void addRegexpFilter(String fieldName, String likeValue, LogicalSymbol operator) {
        this.addFilters(FilterFieldVo.regexp(fieldName, likeValue, operator));
    }

    @ApiOperation(value="\u5355\u503c\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldNames", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true)})
    public final void addRegexpFilter(String[] fieldNames, String likeValue) {
        this.addRegexpFilter(fieldNames, likeValue, LogicalSymbol.AND);
    }

    @ApiOperation(value="\u5355\u503c\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u8be5\u65b9\u6cd5\u7528\u4e8e\u652f\u6301\u7ec4\u5408\uff08AND / OR\uff09\u8fc7\u6ee4", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldNames", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="likeValue", value="\u5b57\u6bb5\u503c", dataType="String", required=true), @ApiImplicitParam(name="logicalSymbol", value="\u5e03\u5c14\u64cd\u4f5c\u7b26", dataType="LogicalSymbol", required=true)})
    public final void addRegexpFilter(String[] fieldNames, String likeValue, LogicalSymbol operator) {
        FilterFieldVo compoundFilter = FilterFieldVo.compound(operator);
        for (String fieldName : fieldNames) {
            compoundFilter.addSubFilterFieldVos(FilterFieldVo.regexp(fieldName, likeValue, LogicalSymbol.OR));
        }
        this.addFilters(compoundFilter);
    }

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u7ec4\u5408\u8fc7\u6ee4\uff0c\u76f8\u5f53\u4e8eSQL(),()\u91cc\u9762\u5185\u5bb9\u901a\u8fc7\u8be5\u5b9e\u4f8b\u7684addSubFilterFieldVos\u65b9\u6cd5\u6dfb\u52a0", response=FilterFieldVo.class)
    public final FilterFieldVo createCompoundFilter(LogicalSymbol operator) {
        return FilterFieldVo.compound(operator);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7edf\u8ba1\u805a\u5408--\u6c42\u6700\u5927\u503c\u3001\u6700\u5c0f\u503c\u3001\u603b\u6570\u91cf\u3001\u5e73\u5747\u503c\u3001\u6c42\u548c", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public final void addStatAgg(String fieldName) {
        this.addAggs(AggFieldVo.stat(fieldName));
    }

    public final void addRangeAgg(RangeVo[] rangs, String fieldName) {
        this.addAggs(AggFieldVo.range(rangs, fieldName));
    }

    @ApiOperation(value="\u6dfb\u52a0\u6309\u7167\u4e24\u7ea7\u65b9\u5f0f\u8fdb\u884c\u5d4c\u5957\u805a\u5408", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="subFieldName", value="\u5d4c\u5957\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public final void addNestedAgg(String fieldName, String subFieldName) {
        this.addAggs(AggFieldVo.nested(fieldName, subFieldName));
    }

    @ApiOperation(value="\u6dfb\u52a0\u6309\u5b57\u6bb5\u503c\u8fdb\u884c\u53bb\u91cd\u805a\u5408", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public final void addTermsAgg(String fieldName) {
        this.addAggs(AggFieldVo.terms(fieldName));
    }

    @ApiOperation(value="\u6dfb\u52a0\u6309\u65e5\u671f\u7c7b\u578b\u8fdb\u884c\u805a\u5408\u51fd\u6570", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="dateIntervalExpression", value="\u65e5\u671f\u7c7b\u578b\u7edf\u8ba1\u533a\u95f4\u8868\u8fbe\u5f0f", dataType="String", required=true), @ApiImplicitParam(name="dataFormate", value="\u5b57\u6bb5\u503c\u65e5\u671f\u663e\u793a\u683c\u5f0f", dataType="String", required=true)})
    public final void addHistogramAgg(String fieldName, String dateIntervalExpression, String dataFormate) {
        this.addAggs(AggFieldVo.dateHistogram(fieldName, dateIntervalExpression, dataFormate));
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true)})
    public final void addTopHits(String fieldName) {
        this.addAggs(AggFieldVo.topHits(fieldName));
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="fetchSource", value="\u662f\u5426\u6293\u53d6\u6574\u4e2a\u6587\u6863\u6e90\u6570\u636e", dataType="fetchSource", required=true)})
    public final void addTopHits(String fieldName, boolean fetchSource) {
        this.addAggs(AggFieldVo.topHits(fieldName, fetchSource));
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570,\u9ed8\u8ba4\u4e3a1", dataType="int", required=false), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u4e3a\u964d\u5e8f", dataType="SortOrder", required=false)})
    public final void addTopHits(String fieldName, int size, SortOrder order) {
        this.addAggs(AggFieldVo.topHits(fieldName, size, order));
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true), @ApiImplicitParam(name="fetchSource", value="\u662f\u5426\u6293\u53d6\u6574\u4e2a\u6587\u6863\u6e90\u6570\u636e", dataType="fetchSource", required=true)})
    public final void addTopHits(String fieldName, int size, SortOrder order, boolean fetchSource) {
        this.addAggs(AggFieldVo.topHits(fieldName, size, order, this.includeFields, this.excludeFields, fetchSource));
    }

    @ApiOperation(value="\u6309\u6392\u5e8f\u540e\u6c42\u8be5\u5b57\u6bb5\u524d\u51e0\u4f4d\u805a\u5408\u51fd\u6570", response=Void.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d", dataType="String", required=true), @ApiImplicitParam(name="size", value="\u4e2a\u6570", dataType="int", required=true), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f", dataType="SortOrder", required=true), @ApiImplicitParam(name="includeFields", value="\u6293\u53d6\u5b57\u6bb5", dataType="String[]", required=false), @ApiImplicitParam(name="excludeFields", value="\u4e0d\u6293\u53d6\u5b57\u6bb5", dataType="String[]", required=false), @ApiImplicitParam(name="fetchSource", value="\u662f\u5426\u6293\u53d6\u6574\u4e2a\u6587\u6863\u6e90\u6570\u636e", dataType="fetchSource", required=true)})
    public final void addTopHits(String fieldName, int size, SortOrder order, String[] includeFields, String[] excludeFields, boolean fetchSource) {
        this.addAggs(AggFieldVo.topHits(fieldName, size, order, includeFields, excludeFields, fetchSource));
    }

    public final void addAggs(List<AggFieldVo> aggs) {
        if (aggs == null || aggs.isEmpty()) {
            return;
        }
        if (this.aggFields == null) {
            this.aggFields = new ArrayList<AggFieldVo>(2);
        }
        this.aggFields.addAll(aggs);
    }

    public final void addAggs(AggFieldVo ... aggs) {
        if (aggs == null || aggs.length == 0) {
            return;
        }
        this.addAggs(Arrays.asList(aggs));
    }

    public final String getHighlightField() {
        return this.highlightField;
    }

    public final void setHighlightField(String highlightField) {
        this.highlightField = highlightField;
    }

    public final boolean isFetchSource() {
        return this.fetchSource;
    }

    public final void setFetchSource(boolean fetchSource) {
        this.fetchSource = fetchSource;
    }

    public final int getStartIndex() {
        if (this.page > 0) {
            return (this.page - 1) * this.pageSize;
        }
        return 0;
    }

    public final int getPage() {
        return this.page;
    }

    public final void setPage(int page) {
        this.page = page;
    }

    public final AggFieldVo[] getAggFieldAsArray() {
        if (this.aggFields == null) {
            return null;
        }
        return this.aggFields.toArray(new AggFieldVo[this.aggFields.size()]);
    }

    public final List<AggFieldVo> getAggFields() {
        return this.aggFields;
    }

    public final String[] getIncludeFields() {
        return this.includeFields;
    }

    public final void setIncludeFields(String[] includeFields) {
        this.includeFields = includeFields;
    }

    public final String[] getExcludeFields() {
        return this.excludeFields;
    }

    public final void setExcludeFields(String[] excludeFields) {
        this.excludeFields = excludeFields;
    }

    public final List<QueryFieldVo> getQueryFields() {
        return this.queryFields;
    }

    public final List<FilterFieldVo> getFilterFields() {
        return this.filterFields;
    }

    @JsonIgnore
    public final FilterFieldVo[] getFilterFieldAsArray() {
        if (this.filterFields == null) {
            return null;
        }
        ArrayList<FilterFieldVo> mustFilterFields = new ArrayList<FilterFieldVo>(this.filterFields.size());
        for (FilterFieldVo mustFilterField : this.filterFields) {
            if (null != mustFilterField.getNon() && mustFilterField.getNon().booleanValue()) continue;
            mustFilterFields.add(mustFilterField);
        }
        return mustFilterFields.toArray(new FilterFieldVo[mustFilterFields.size()]);
    }

    public final FilterFieldVo[] getMustNoFilterFieldAsArray() {
        if (this.filterFields == null) {
            return null;
        }
        ArrayList<FilterFieldVo> mustNoFilterFields = new ArrayList<FilterFieldVo>(this.filterFields.size());
        for (FilterFieldVo mustFilterField : this.filterFields) {
            if (null == mustFilterField.getNon() || !mustFilterField.getNon().booleanValue()) continue;
            mustNoFilterFields.add(mustFilterField);
        }
        return mustNoFilterFields.toArray(new FilterFieldVo[mustNoFilterFields.size()]);
    }

    public final List<FilterFieldVo> getOrFilterFields() {
        return this.orFilterFields;
    }

    @JsonIgnore
    public final FilterFieldVo[] getOrFilterFieldAsArray() {
        if (this.orFilterFields == null) {
            return null;
        }
        return this.orFilterFields.toArray(new FilterFieldVo[this.orFilterFields.size()]);
    }

    public final List<SortFieldVo> getSortFields() {
        return this.sortFields;
    }

    public List<GeoDistanceFieldVo> getGeoDistanceFields() {
        return this.geoDistanceFields;
    }

    public boolean isUseScroll() {
        return this.useScroll;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public List<GeoShapeFieldVo> getGeoShapeFields() {
        return this.geoShapeFields;
    }

    public void setUseScroll(boolean useScroll) {
        this.useScroll = useScroll;
    }

    public void setKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setOrFilterFields(List<FilterFieldVo> orFilterFields) {
        this.orFilterFields = orFilterFields;
    }

    public void setAggFields(List<AggFieldVo> aggFields) {
        this.aggFields = aggFields;
    }

    public void setQueryFields(List<QueryFieldVo> queryFields) {
        this.queryFields = queryFields;
    }

    public void setFilterFields(List<FilterFieldVo> filterFields) {
        this.filterFields = filterFields;
    }

    public void setSortFields(List<SortFieldVo> sortFields) {
        this.sortFields = sortFields;
    }

    public void setGeoDistanceFields(List<GeoDistanceFieldVo> geoDistanceFields) {
        this.geoDistanceFields = geoDistanceFields;
    }

    public void setGeoShapeFields(List<GeoShapeFieldVo> geoShapeFields) {
        this.geoShapeFields = geoShapeFields;
    }
}

