/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.api;

import com.dtyunxi.huieryun.opensearch.api.IIndicesMappingCacheService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.vo.CommonFiledVo;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public abstract class AbstractOpenSearchService
implements IOpenSearchService {
    protected OpenSearchVo openSearchVo;
    protected IIndicesMappingCacheService indicesMappingCacheService;
    protected static final String[] SYSTEM_FIELDS = new String[]{"_score"};
    protected static final Pattern PATTERN_TIME = Pattern.compile("^(\\d+)(ms|s|m|h|d)?$");
    protected ThreadLocal<Map<String, Object>> propertiesCache = new ThreadLocal();

    protected static String[] getSystemFields() {
        return SYSTEM_FIELDS;
    }

    protected static Pattern getPatternTime() {
        return PATTERN_TIME;
    }

    public abstract void init(OpenSearchVo var1);

    protected boolean isSystemFields(String fieldName) {
        for (int i = 0; i < SYSTEM_FIELDS.length; ++i) {
            boolean result = SYSTEM_FIELDS[i].equals(fieldName);
            if (!result) continue;
            return true;
        }
        return false;
    }

    protected long getTimeLevel(String timeUnit) {
        if (null != timeUnit) {
            switch (timeUnit) {
                case "ms": {
                    return 1L;
                }
                case "s": {
                    return 1000L;
                }
                case "m": {
                    return 60000L;
                }
                case "h": {
                    return 3600000L;
                }
                case "d": {
                    return 86400000L;
                }
            }
        }
        return 3600000L;
    }

    protected void getMetaNameAndNestedFieldName(List<? extends CommonFiledVo> fields) {
        for (CommonFiledVo commonFiledVo : fields) {
            String fieldName = commonFiledVo.getFieldName();
            if (null != commonFiledVo.getFieldMetaName()) {
                fieldName = commonFiledVo.getFieldMetaName();
            }
            if (fieldName == null) {
                commonFiledVo.setNotFoundField(true);
                continue;
            }
            if (this.isSystemFields(fieldName)) {
                commonFiledVo.setFieldMetaName(fieldName);
                continue;
            }
            try {
                commonFiledVo.setFieldMetaName(this.getFieldMetaName(fieldName));
            }
            catch (RuntimeException e) {
                commonFiledVo.setNotFoundField(true);
                continue;
            }
            if (fieldName.contains(".")) {
                String[] fieldNames = fieldName.split("\\.");
                for (int i = 0; i < fieldNames.length; ++i) {
                    String fieldType = this.getFieldType(fieldNames[i]);
                    if (fieldType == null || !fieldType.equals("nested")) continue;
                    commonFiledVo.setNestedFieldName(fieldNames[i]);
                    commonFiledVo.setNestedType(true);
                    break;
                }
            }
            String subFieldName = commonFiledVo.getSubFieldName();
            if (null != commonFiledVo.getSubFieldMetaName()) {
                subFieldName = commonFiledVo.getSubFieldMetaName();
            }
            if (subFieldName == null) continue;
            try {
                commonFiledVo.setSubFieldMetaName(this.getFieldMetaName(subFieldName));
            }
            catch (RuntimeException e) {
                commonFiledVo.setNotFoundField(true);
            }
        }
    }

    protected String getFieldType(String fieldName) {
        Map<String, Object> properties = this.propertiesCache.get();
        Map obj = (Map)properties.get(fieldName);
        if (obj == null) {
            this.getLogger().warn("Can't Find FieldName,FieldName=" + fieldName);
            return null;
        }
        Object fieldType = obj.get("type");
        if (fieldType == null) {
            this.getLogger().warn("Get Field Type Failure,FieldName=" + fieldName);
            return null;
        }
        return String.valueOf(fieldType);
    }

    protected String getFieldMetaName(String fieldName) {
        String keyWord = this.getFieldAliasNameBySuffix(fieldName, "keyword");
        if (keyWord != null) {
            return keyWord;
        }
        return fieldName;
    }

    protected String getFieldAliasNameBySuffix(String fieldName, String suffix) {
        Map<String, Object> properties = this.propertiesCache.get();
        Map obj = null;
        if (fieldName.contains(".")) {
            String[] fieldNames = fieldName.split("\\.");
            obj = (Map)properties.get(fieldNames[0]);
            for (int i = 1; i < fieldNames.length; ++i) {
                obj = (Map)obj.get("properties");
                obj = (Map)obj.get(fieldNames[i]);
            }
        } else {
            obj = (Map)properties.get(fieldName);
        }
        if (obj == null) {
            String msg = String.format("FieldName :%s is not found!", fieldName);
            this.getLogger().error(msg);
            throw new BusinessRuntimeException(msg);
        }
        if (obj.containsKey("fields")) {
            if ((obj = (Map)obj.get("fields")).containsKey(suffix)) {
                return fieldName + "." + suffix;
            }
        } else {
            if (obj.containsKey("type") && obj.get("type").equals("text") && suffix.equals("keyword")) {
                return fieldName + "." + suffix;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(JacksonUtil.toJson((Object)obj));
            }
        }
        return null;
    }

    protected void prepareIndexMapping(String indexName, String typeName) {
        Map<String, Object> mapping = this.indicesMappingCacheService.getMappingFromCache(indexName);
        if (mapping != null) {
            this.propertiesCache.set(mapping);
            return;
        }
        mapping = this.getIndexMapping(indexName, typeName);
        Map properties = (Map)mapping.get("properties");
        this.propertiesCache.set(properties);
        this.indicesMappingCacheService.putMappingToCache(indexName, properties);
    }

    protected abstract Map<String, Object> getIndexMapping(String var1, String var2);

    protected abstract Logger getLogger();

    protected ThreadLocal<Map<String, Object>> getPropertiesCache() {
        return this.propertiesCache;
    }

    public void setIndicesMappingCacheService(IIndicesMappingCacheService indicesMappingCacheService) {
        this.indicesMappingCacheService = indicesMappingCacheService;
    }
}

