/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.autoconfigure;

import com.dtyunxi.huieryun.opensearch.api.BuilderCustomizer;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IIndicesMappingCacheService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.api.OpenSearchFactory;
import com.dtyunxi.huieryun.opensearch.autoconfigure.OpenSearchRegistryProperties;
import com.dtyunxi.huieryun.opensearch.impl.IndicesMappingCacheService;
import com.dtyunxi.huieryun.opensearch.runner.PrepareGetIndicesMappingsRunner;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(prefix="huieryun.opensearchvo", name={"enable"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={IOpenSearchService.class, OpenSearchFactory.class})
@EnableConfigurationProperties(value={OpenSearchRegistryProperties.class})
public class OpenSearchAutoConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchAutoConfiguration.class);
    private final OpenSearchRegistryProperties openSearchVo;

    public OpenSearchAutoConfiguration(OpenSearchRegistryProperties openSearchVo, ObjectProvider<List<BuilderCustomizer>> builderCustomizerProviders) {
        List builderCustomizers = (List)builderCustomizerProviders.getIfAvailable();
        if (!CollectionUtils.isEmpty((Collection)builderCustomizers)) {
            openSearchVo.setCustomizers(builderCustomizers);
        }
        this.openSearchVo = openSearchVo;
    }

    @Bean
    @ConditionalOnMissingBean
    public IIndicesMappingCacheService indicesMappingCacheService() {
        return new IndicesMappingCacheService();
    }

    @Bean(destroyMethod="closeSearchClient")
    @ConditionalOnMissingBean
    public ISearchIndexService searchIndexService() {
        return OpenSearchFactory.createSearchIndexService(this.openSearchVo);
    }

    @Bean(destroyMethod="closeSearchClient")
    @ConditionalOnMissingBean
    public IOpenSearchService openSearchService(IIndicesMappingCacheService indicesMappingCacheService) {
        return OpenSearchFactory.createOpenSearch(this.openSearchVo, indicesMappingCacheService);
    }

    @Bean(destroyMethod="closeSearchClient")
    @ConditionalOnMissingBean
    public IIndicesAdminService indicesAdminService(IIndicesMappingCacheService indicesMappingCacheService) {
        return OpenSearchFactory.createIndicesAdminService(this.openSearchVo, indicesMappingCacheService);
    }

    @Bean
    @ConditionalOnProperty(prefix="huieryun.opensearchvo.mapping.cache", name={"enable"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean
    public PrepareGetIndicesMappingsRunner prepareGetIndicesMappingsRunner(IIndicesAdminService indicesAdminService, OpenSearchRegistryProperties openSearchVo) {
        return new PrepareGetIndicesMappingsRunner(indicesAdminService, openSearchVo.getIndexPrefix());
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.openSearchVo) {
            logger.error("openSearchVo \u5c1a\u672a\u914d\u7f6e");
        } else {
            logger.info("OpenSearchAutoConfiguration \u5df2\u88c5\u8f7d");
        }
    }
}

