/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.vo;

import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="IndexDocumentVo", description="\u7d22\u5f15\u6587\u6863")
public class IndexDocumentVo
extends BaseVo {
    protected static final long serialVersionUID = -3570920136166523018L;
    protected static final Logger logger = LoggerFactory.getLogger(IndexDocumentVo.class);
    protected static final String DATA_INVALID = "\u4e0a\u4f20\u6570\u636e\u4f20\u5165\u53c2\u6570\u4e0d\u5408\u6cd5\uff1aindexName=%s typeName=%s";
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u540d\u79f0")
    protected String indexName;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u7c7b\u578b\u540d\u79f0")
    protected String typeName;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u5185\u5bb9")
    protected List<IndexDocContentVo> contents;
    @ApiModelProperty(value="\u7d22\u5f15\u66f4\u65b0\u51b2\u7a81\u91cd\u8bd5\u6b21\u6570\uff0c\u9ed8\u8ba4\u4e3a0\u6b21")
    protected int retryOnConflict = 0;

    public IndexDocumentVo(String indexName, String typeName) {
        this.indexName = indexName;
        this.typeName = typeName;
    }

    public IndexDocumentVo(String indexName, String typeName, List<IndexDocContentVo> contents) {
        this.indexName = indexName;
        this.typeName = typeName;
        this.contents = contents;
    }

    public final String getIndexName() {
        return this.indexName;
    }

    public final void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public final String getTypeName() {
        return this.typeName;
    }

    public final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public final List<IndexDocContentVo> getContents() {
        return this.contents;
    }

    public final void setContents(List<IndexDocContentVo> contents) {
        this.contents = contents;
    }

    public int getRetryOnConflict() {
        return this.retryOnConflict;
    }

    public void setRetryOnConflict(int retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
    }

    public final void addContent(IndexDocContentVo content) {
        if (this.contents == null) {
            this.contents = new ArrayList<IndexDocContentVo>();
        }
        this.contents.add(content);
    }

    public final void validate(boolean delete) {
        if (StringUtils.isBlank((CharSequence)this.indexName) || StringUtils.isBlank((CharSequence)this.typeName) || this.contents == null || this.contents.isEmpty()) {
            this.throwErrorTip();
        }
        for (IndexDocContentVo content : this.contents) {
            if (StringUtils.isBlank((CharSequence)content.getIndexId())) {
                this.throwErrorTip();
            }
            if (delete || content.getDocValueMap() != null && !content.getDocValueMap().isEmpty()) continue;
            this.throwErrorTip();
        }
    }

    protected final void throwErrorTip() {
        String message = String.format(DATA_INVALID, this.indexName, this.typeName);
        logger.error(message);
        throw new BusinessRuntimeException(message);
    }

    public String toString() {
        int maxLen = 10;
        return "IndexDocumentVo [" + (this.indexName != null ? "indexName=" + this.indexName + ", " : "") + (this.typeName != null ? "typeName=" + this.typeName + ", " : "") + (this.contents != null ? "contents=" + this.contents.subList(0, Math.min(this.contents.size(), 10)) : "") + "]";
    }
}

