/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.opensearch.vo;

import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.vo.AggResult;
import com.dtyunxi.huieryun.opensearch.vo.AggResultItem;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

@ApiModel(value="SearchResultVo", description="\u641c\u7d22\u7ed3\u679c\u96c6\u5b9a\u4e49")
public class SearchResultVo
extends BaseVo {
    protected static final long serialVersionUID = -2456700009882000477L;
    @ApiModelProperty(value="\u603b\u884c\u6570")
    protected long totalSize;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u8d77\u59cb\u884c")
    protected int startIndex;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u884c\u6570")
    protected int pageSize;
    @ApiModelProperty(value="\u7d22\u5f15\u6587\u6863\u7ed3\u679c\u96c6")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<Map<String, Object>> docValues;
    @ApiModelProperty(value="\u805a\u5408\u7ed3\u679c\u96c6")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected List<AggResult> aggResults;
    @ApiModelProperty(value="ElasticSearch\u6e38\u6807\u5b9e\u4f8bID")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String scrollId;

    public final int getCurrentPage() {
        return this.startIndex / this.pageSize + 1;
    }

    public final Long getTotalPageNum() {
        if (this.totalSize == 0L) {
            return 0L;
        }
        return (this.totalSize - 1L) / (long)this.pageSize + 1L;
    }

    @ApiOperation(value="\u6309\u6307\u5b9a\u6570\u636e\u884c\u8f6c\u6362\u5668\u8fdb\u884c\u6570\u636e\u8f6c\u6362\u4e3a\u6307\u5b9a\u5bf9\u8c61\u5217\u8868", response=List.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="rowMapper", value="\u7c7b\u578b\u8f6c\u6362\u5668", dataType="RowMapper<T>", required=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="List<T> \u5bf9\u8c61\u5217\u8868")})
    @JsonIgnore
    public final <T> List<T> getDocValues(RowMapper<T> rowMapper) {
        if (this.docValues == null || this.docValues.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<T> resultList = new ArrayList<T>(this.docValues.size());
        for (Map<String, Object> docValue : this.docValues) {
            T obj = rowMapper.mapRow(docValue);
            resultList.add(obj);
        }
        return resultList;
    }

    @ApiOperation(value="\u6309\u6307\u5b9a\u6570\u636e\u884c\u8f6c\u6362\u5668\u8fdb\u884c\u6570\u636e\u8f6c\u6362\u4e3a\u6307\u5b9a\u5bf9\u8c61\u5217\u8868\uff08\u987b\u8ddf\u6587\u6863JSON\u7ed3\u6784\u5339\u914d\u5bf9\u8c61\uff09", response=List.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="valueTypeRef", value="\u7c7b\u578b\u8f6c\u6362\u5668", dataType="TypeReference<List<T>>", required=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="List<T> \u5bf9\u8c61\u5217\u8868")})
    @JsonIgnore
    public final <T> List<T> getDocValues(TypeReference<List<T>> valueTypeRef) {
        if (this.docValues == null || this.docValues.isEmpty()) {
            return new ArrayList(0);
        }
        return (List)JacksonUtil.readValue((String)JacksonUtil.toJson(this.docValues), valueTypeRef);
    }

    @ApiOperation(value="\u83b7\u53d6\u805a\u5408\u7ed3\u679c\u96c6", response=String.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d\u79f0", dataType="String", required=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="String[] \u5b57\u6bb5\u540d\u79f0\u5217\u8868")})
    @JsonIgnore
    public final String[] getAggResultFieldValues(String fieldName) {
        if (StringUtils.isEmpty((Object)fieldName)) {
            return null;
        }
        if (this.aggResults == null) {
            return null;
        }
        for (AggResult aggResult : this.aggResults) {
            if (!aggResult.getFieldName().equals(fieldName)) continue;
            return aggResult.getFieldValues();
        }
        return null;
    }

    @ApiOperation(value="\u83b7\u53d6\u5d4c\u5957\u578b\u805a\u5408\u7ed3\u679c\u96c6", response=Map.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldName", value="\u5b57\u6bb5\u540d\u79f0", dataType="String", required=true), @ApiImplicitParam(name="subFieldName", value="\u5d4c\u5957\u5b57\u6bb5\u540d\u79f0", dataType="String", required=true)})
    @ApiResponses(value={@ApiResponse(code=200, message="Map<String,List<String>> key\u4e3a\u5b57\u6bb5\u540d\u79f0\uff0cList\u4e3a\u5d4c\u5957\u5b57\u6bb5\u540d\u79f0\u5217\u8868")})
    @JsonIgnore
    public final Map<String, List<String>> getNestedAggResultFieldValues(String fieldName, String subFieldName) {
        if (StringUtils.isEmpty((Object)fieldName) || StringUtils.isEmpty((Object)subFieldName)) {
            return null;
        }
        if (this.aggResults == null) {
            return null;
        }
        for (AggResult aggResult : this.aggResults) {
            if (!aggResult.isExistsFieldValues(subFieldName)) continue;
            return aggResult.getFieldValues(subFieldName);
        }
        return null;
    }

    public final List<AggResultItem> getAggResultItems(String fieldName) {
        if (StringUtils.isEmpty((Object)fieldName)) {
            return null;
        }
        if (this.aggResults == null) {
            return null;
        }
        for (AggResult aggResult : this.aggResults) {
            if (!aggResult.getFieldName().equals(fieldName)) continue;
            return aggResult.getAggResultItems();
        }
        return null;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<Map<String, Object>> getDocValues() {
        return this.docValues;
    }

    public List<AggResult> getAggResults() {
        return this.aggResults;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setDocValues(List<Map<String, Object>> docValues) {
        this.docValues = docValues;
    }

    public void setAggResults(List<AggResult> aggResults) {
        this.aggResults = aggResults;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    public String toString() {
        return "SearchResultVo(totalSize=" + this.getTotalSize() + ", startIndex=" + this.getStartIndex() + ", pageSize=" + this.getPageSize() + ", docValues=" + this.getDocValues() + ", aggResults=" + this.getAggResults() + ", scrollId=" + this.getScrollId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResultVo)) {
            return false;
        }
        SearchResultVo other = (SearchResultVo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTotalSize() != other.getTotalSize()) {
            return false;
        }
        if (this.getStartIndex() != other.getStartIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        List<Map<String, Object>> this$docValues = this.getDocValues();
        List<Map<String, Object>> other$docValues = other.getDocValues();
        if (this$docValues == null ? other$docValues != null : !((Object)this$docValues).equals(other$docValues)) {
            return false;
        }
        List<AggResult> this$aggResults = this.getAggResults();
        List<AggResult> other$aggResults = other.getAggResults();
        if (this$aggResults == null ? other$aggResults != null : !((Object)this$aggResults).equals(other$aggResults)) {
            return false;
        }
        String this$scrollId = this.getScrollId();
        String other$scrollId = other.getScrollId();
        return !(this$scrollId == null ? other$scrollId != null : !this$scrollId.equals(other$scrollId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchResultVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalSize = this.getTotalSize();
        result = result * 59 + (int)($totalSize >>> 32 ^ $totalSize);
        result = result * 59 + this.getStartIndex();
        result = result * 59 + this.getPageSize();
        List<Map<String, Object>> $docValues = this.getDocValues();
        result = result * 59 + ($docValues == null ? 43 : ((Object)$docValues).hashCode());
        List<AggResult> $aggResults = this.getAggResults();
        result = result * 59 + ($aggResults == null ? 43 : ((Object)$aggResults).hashCode());
        String $scrollId = this.getScrollId();
        result = result * 59 + ($scrollId == null ? 43 : $scrollId.hashCode());
        return result;
    }
}

