/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.api;

import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.util.JacksonUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistryChangeListener
implements RegistryChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRegistryChangeListener.class);
    private List<Object> listRegistryObj = new ArrayList<Object>();
    private boolean bool = false;

    public void addRegistryObject(Object registryObj) {
        this.listRegistryObj.add(registryObj);
    }

    public DefaultRegistryChangeListener() {
        this.bool = false;
    }

    public DefaultRegistryChangeListener(boolean bool) {
        this.bool = bool;
    }

    public void watch(IRegistryService registryService) {
        for (Object obj : this.listRegistryObj) {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                Column column = field.getAnnotation(Column.class);
                String key = column.name();
                registryService.watch(key, this);
                if (!this.bool) continue;
                try {
                    String value = registryService.get(key);
                    if (value == null) continue;
                    String type = field.getType().toString();
                    logger.info("===>>>\u5c5e\u6027\u7c7b\u578b type:{}", (Object)type);
                    if (type.endsWith("String")) {
                        field.set(obj, value);
                    } else if (type.endsWith("int") || type.endsWith("Integer")) {
                        field.set(obj, new Integer(value));
                    } else if (type.endsWith("long") || type.endsWith("Long")) {
                        field.set(obj, Long.valueOf(value));
                    } else if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                        field.set(obj, new Boolean(value));
                    } else if (type.endsWith("double") || type.endsWith("Double")) {
                        field.set(obj, Double.valueOf(value));
                    } else {
                        field.set(obj, JacksonUtil.readValue((String)value, Class.forName(type.replace("class ", ""))));
                    }
                    logger.info("\u914d\u7f6e\u4e2d\u5fc3\u521d\u59cb\u5316\u5c5e\u6027\u503c===>>>fieldName:{} , value:{}", (Object)field.getName(), (Object)value);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void onUpdate(String group, String key, String value) {
        for (Object obj : this.listRegistryObj) {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                Column column;
                if (!field.isAnnotationPresent(Column.class) || !(column = field.getAnnotation(Column.class)).name().equals(key)) continue;
                String type = field.getType().toString();
                logger.info("===>>>\u5c5e\u6027\u7c7b\u578b type:{}", (Object)type);
                try {
                    if (type.endsWith("String")) {
                        field.set(obj, value);
                    } else if (type.endsWith("int") || type.endsWith("Integer")) {
                        field.set(obj, new Integer(value));
                    } else if (type.endsWith("long") || type.endsWith("Long")) {
                        field.set(obj, Long.valueOf(value));
                    } else if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                        field.set(obj, new Boolean(value));
                    } else if (type.endsWith("double") || type.endsWith("Double")) {
                        field.set(obj, Double.valueOf(value));
                    } else {
                        field.set(obj, JacksonUtil.readValue((String)value, Class.forName(type.replace("class ", ""))));
                    }
                    logger.info("\u914d\u7f6e\u4e2d\u5fc3\u4fee\u6539\u4e86\u914d\u7f6e\uff0c\u91cd\u65b0\u8bbe\u503c===>>>fieldName:{} , value:{}", (Object)field.getName(), (Object)value);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                return;
            }
        }
    }

    @Override
    public void onDelete(String group, String key) {
    }
}

