/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.api;

import com.dtyunxi.app.DeployEnv;
import com.dtyunxi.huieryun.registry.api.AbstractRegistryService;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class RegistryServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServiceFactory.class);

    public static IRegistryService createRegistryService(String configServiceType, String[] endpoints, String group) {
        AbstractRegistryService configService = null;
        if (group == null) {
            throw new BusinessRuntimeException("Please set registry group by system parameter: -Ddtyunxi.registry.group=xxx");
        }
        if (configServiceType == null) {
            DeployEnv deployEnv = DeployEnv.getDeployEnv();
            configServiceType = DeployEnv.DEPLOY_ENV_SPRINGCLOUD == deployEnv ? "springcloudconfig" : "diamond";
            logger.warn("Fallback to default registry service {} ", (Object)configServiceType);
        }
        String className = null;
        switch (configServiceType) {
            case "nacos": {
                className = "com.dtyunxi.huieryun.registry.provider.nacos.NacosRegistryService";
                break;
            }
            case "diamond": {
                className = "com.dtyunxi.huieryun.registry.provider.edas.ConfigRegistryService";
                break;
            }
            case "etcd": {
                className = "com.dtyunxi.huieryun.registry.provider.etcd.EtcdRegistryService";
                break;
            }
            case "zookeeper": {
                className = "com.dtyunxi.huieryun.registry.provider.zookeeper.ZooKeeperRegistryService";
                break;
            }
            case "springcloudconfig": {
                className = "com.dtyunxi.huieryun.registry.provider.ScConfigRegistryService";
                break;
            }
            case "localfile": {
                className = "com.dtyunxi.huieryun.registry.provider.LocalFileRegistryService";
                break;
            }
        }
        try {
            configService = (AbstractRegistryService)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u5206\u5e03\u5f0f\u6ce8\u518c\u5ba2\u6237\u7aef\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u52a0\u8f7d\u5206\u5e03\u5f0f\u6ce8\u518c\u5ba2\u6237\u7aef\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
        logger.info("Using dtyunxi registry service {}, endpoints {}, group {}", new Object[]{configServiceType, endpoints, group});
        configService.init(endpoints, group);
        return configService;
    }

    public static IRegistryService createRegistryService(Environment env) {
        String configProvider = env.getProperty("dtyunxi.registry.provider");
        String configEndpoints = env.getProperty("dtyunxi.registry.endpoints");
        String[] endpoints = null;
        if (configEndpoints != null && !configEndpoints.trim().isEmpty()) {
            endpoints = new String[]{configEndpoints};
        }
        String configGroup = env.getProperty("dtyunxi.registry.group");
        IRegistryService configService = RegistryServiceFactory.createRegistryService(configProvider, endpoints, configGroup);
        String cipherDecodeKey = env.getProperty("dtyunxi.registry.cipherKey");
        if (cipherDecodeKey != null) {
            ((AbstractRegistryService)configService).setCipherDecodeKey(cipherDecodeKey);
        }
        return configService;
    }
}

