/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.provider;

import com.dtyunxi.huieryun.registry.api.AbstractRegistryService;
import com.dtyunxi.huieryun.registry.api.ConfigRegistration;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.huieryun.registry.vo.RegistryItemVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.CipherTextUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileRegistryService
extends AbstractRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileRegistryService.class);
    private Map<String, Map<String, String>> mapConfigs = new HashMap<String, Map<String, String>>();

    @Override
    public void init(String[] endpoints, String group) {
        try {
            this.group = group;
            ConfigRegistration configRegistration = new ConfigRegistration();
            configRegistration.registration(endpoints[0], group, (IRegistryService)this);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean put(String group, String key, String value) {
        this.getGroupMap(group).put(key, value);
        RegistryChangeListener registryChangeListener = this.getRegistryChangeListener(group, key);
        if (registryChangeListener != null) {
            registryChangeListener.onUpdate(group, key, value);
        }
        return true;
    }

    private Map<String, String> getGroupMap(String group) {
        Map<String, String> mapGroup = this.mapConfigs.get(group);
        if (mapGroup == null) {
            mapGroup = new HashMap<String, String>();
            this.mapConfigs.put(group, mapGroup);
        }
        return mapGroup;
    }

    @Override
    public String get(String group, String key) {
        String value = this.getGroupMap(group).get(key);
        value = CipherTextUtil.decode((String)this.cipherDecodeKey, (String)value);
        return value;
    }

    @Override
    public RegistryItemVo[] getPrefix(String group, String key) {
        throw new UnsupportedOperationException("FileRegistryService.getPrefix");
    }

    @Override
    public void delete(String group, String key) {
        this.getGroupMap(group).remove(key);
        RegistryChangeListener registryChangeListener = this.getRegistryChangeListener(group, key);
        if (registryChangeListener != null) {
            registryChangeListener.onDelete(group, key);
        }
    }

    @Override
    public void registerChangeListner(String group, String key, RegistryChangeListener registryChangeListener) {
    }
}

