/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.provider;

import com.dtyunxi.huieryun.registry.api.AbstractRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.huieryun.registry.vo.RegistryItemVo;
import com.dtyunxi.util.JacksonUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class ScConfigRegistryService
extends AbstractRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(ScConfigRegistryService.class);
    private Map<String, Map<String, String>> mapConfigs = new HashMap<String, Map<String, String>>();
    @Autowired
    private Environment env;

    @Override
    public void init(String[] endpoints, String group) {
        this.group = group;
    }

    @Override
    public boolean put(String group, String key, String value) {
        logger.debug("Put value to registry, group:{}, key:{}, value:{}", new Object[]{group, key, value});
        this.getGroupMap(group).put(key, value);
        return true;
    }

    private Map<String, String> getGroupMap(String group) {
        Map<String, String> mapGroup = this.mapConfigs.get(group);
        if (mapGroup == null) {
            mapGroup = new HashMap<String, String>();
            this.mapConfigs.put(group, mapGroup);
        }
        return mapGroup;
    }

    @Override
    public String get(String group, String key) {
        String value = null;
        if (this.getGroupMap(group).containsKey(key)) {
            value = this.getGroupMap(group).get(key);
        } else {
            if (key.endsWith("vo")) {
                value = this.parseVoObject(group, key);
            }
            if (value == null) {
                value = this.env.getProperty(key);
            }
            if (value != null) {
                this.put(group, key, value);
            }
        }
        logger.info("Get value from registry, group:{}, key:{}, value:{}", new Object[]{group, key, value});
        return value;
    }

    private String parseVoObject(String group, String key) {
        String value = null;
        String className = this.env.getProperty(key + ".className");
        if (className == null) {
            value = this.env.getProperty(key);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Field[] fields = clazz.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    HashMap<String, String> mapObj = new HashMap<String, String>();
                    for (Field field : fields) {
                        String fieldName = field.getName();
                        String fieldValue = this.env.getProperty(key + "." + fieldName);
                        if (fieldValue == null) continue;
                        mapObj.put(fieldName, fieldValue);
                    }
                    value = JacksonUtil.toJson(mapObj);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public RegistryItemVo[] getPrefix(String group, String key) {
        throw new UnsupportedOperationException("ConfigRegistryService.getPrefix");
    }

    @Override
    public void delete(String group, String key) {
        logger.debug("Detete key from registry, group:{}, key:{}", (Object)group, (Object)key);
        throw new UnsupportedOperationException("ConfigRegistryService.delete");
    }

    @Override
    public void registerChangeListner(String group, String key, RegistryChangeListener registryChangeListener) {
    }
}

