/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.provider.etcd;

import com.coreos.jetcd.api.Event;
import com.coreos.jetcd.api.WatchResponse;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.huieryun.registry.provider.etcd.EtcdKeyValue;
import com.dtyunxi.huieryun.registry.provider.etcd.EtcdRegistryService;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdStreamObserver
implements StreamObserver<WatchResponse> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdStreamObserver.class);
    private EtcdRegistryService etcdRegistryService;

    public EtcdStreamObserver(EtcdRegistryService etcdRegistryService) {
        this.etcdRegistryService = etcdRegistryService;
    }

    public void onNext(WatchResponse watchResponse) {
        if (!watchResponse.getCreated() && !watchResponse.getCanceled()) {
            List listEvent = watchResponse.getEventsList();
            for (Event event : listEvent) {
                RegistryChangeListener registryChangeListener;
                String key;
                String etcdKey = EtcdKeyValue.toString(event.getKv().getKey());
                String group = null;
                int index = etcdKey.indexOf("/");
                if (index > 0) {
                    group = etcdKey.substring(0, index);
                    key = etcdKey.substring(index + 1);
                } else {
                    key = etcdKey;
                }
                if ((registryChangeListener = this.etcdRegistryService.getRegistryChangeListener(group, key)) == null) continue;
                if (event.getType() == Event.EventType.PUT) {
                    logger.info("PUT event = {}", (Object)event.getKv());
                    String value = EtcdKeyValue.toString(event.getKv().getValue());
                    registryChangeListener.onUpdate(group, key, value);
                    continue;
                }
                registryChangeListener.onDelete(group, key);
            }
        } else {
            logger.info("watch id = ", (Object)watchResponse.getWatchId());
        }
    }

    public void onError(Throwable t) {
        logger.error("watch error", t);
    }

    public void onCompleted() {
        logger.info("watch onCompleted");
    }
}

