/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.retry.api;

import com.dtyunxi.huieryun.retry.api.AbstractRetryService;
import com.dtyunxi.huieryun.retry.api.IRetryService;
import com.dtyunxi.huieryun.retry.enums.RetryerTypeEnum;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryerFactory.class);

    public static final IRetryService createRetryService(RetryerTypeEnum retryerType, ThreadPoolExecutor threadPool) {
        LOGGER.debug("retryerType={}", (Object)retryerType);
        AbstractRetryService retryService = null;
        String className = null;
        if (null == retryerType) {
            retryerType = RetryerTypeEnum.GUAVA;
        }
        switch (retryerType) {
            case GUAVA: {
                className = "com.dtyunxi.huieryun.retry.guava.impl.RetryServiceGuavaImpl";
                break;
            }
            default: {
                throw new IllegalArgumentException("\u65e0\u6cd5\u652f\u6301\u91cd\u8bd5\u670d\u52a1\u7c7b\u578b\uff01");
            }
        }
        try {
            retryService = (AbstractRetryService)Class.forName(className).newInstance();
            retryService.init(threadPool);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u91cd\u8bd5\u670d\u52a1\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u91cd\u8bd5\u670d\u52a1\u63d0\u4f9b\u7c7b\uff1a" + className);
        }
        return retryService;
    }
}

