/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.retry.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@ApiModel(description="\u91cd\u8bd5\u914d\u7f6e")
public class RetryerRegistryVo
implements Serializable {
    private static final Pattern PATTERN_TIME = Pattern.compile("^(\\d+)(ms|s|m|h|d)?$");
    private static final long serialVersionUID = 9033077237479873974L;
    @ApiModelProperty(value="\u521d\u6b21\u6216\u8005\u56fa\u5b9a\u91cd\u8bd5\u7b49\u5f85\u65f6\u957f\uff0c\u683c\u5f0f\u4e3a\uff1a1ms / 1s / 1m / 1h / 1d,\u65f6\u95f4\u5355\u4f4d\u652f\u6301\uff1ams\u3001s\u3001m\u3001h\u3001d\uff0c\u5206\u522b\u8868\u793a\u79d2\u3001\u5206\u3001\u65f6\u3001\u5929")
    private String initialSleepTime;
    @ApiModelProperty(value="\u4e8c\u6b21\u91cd\u8bd5\u7b49\u5f85\u589e\u52a0\u65f6\u957f\uff0c\u683c\u5f0f\u4e3a\uff1a1ms / 1s / 1m / 1h / 1d,\u65f6\u95f4\u5355\u4f4d\u652f\u6301\uff1ams\u3001s\u3001m\u3001h\u3001d\uff0c\u5206\u522b\u8868\u793a\u79d2\u3001\u5206\u3001\u65f6\u3001\u5929")
    private String incrementSleepTime;
    @ApiModelProperty(value="\u6700\u5927\u91cd\u8bd5\u6b21\u6570")
    private int attemptNumber;
    @ApiModelProperty(value="\u662f\u5426\u5f00\u542f\u91cd\u8bd5")
    private boolean retryEnable;

    public String getInitialSleepTime() {
        return this.initialSleepTime;
    }

    public long getInitialSleepTimeLong() {
        return this.convertStringTimeToLong(this.initialSleepTime);
    }

    private long convertStringTimeToLong(String timeStr) {
        if (StringUtils.isBlank((CharSequence)timeStr)) {
            return 0L;
        }
        Matcher m = PATTERN_TIME.matcher(timeStr);
        if (!m.find()) {
            return 0L;
        }
        long time = Long.valueOf(m.group(1));
        return time * this.getTimeLevel(m.group(2));
    }

    private long getTimeLevel(String timeUnit) {
        if (null != timeUnit) {
            switch (timeUnit) {
                case "ms": {
                    return 1L;
                }
                case "s": {
                    return 1000L;
                }
                case "m": {
                    return 60000L;
                }
                case "h": {
                    return 3600000L;
                }
                case "d": {
                    return 86400000L;
                }
            }
        }
        return 1000L;
    }

    public void setInitialSleepTime(String initialSleepTime) {
        if (StringUtils.isBlank((CharSequence)initialSleepTime)) {
            return;
        }
        Matcher m = PATTERN_TIME.matcher(initialSleepTime);
        if (!m.find()) {
            throw new IllegalArgumentException("\u521d\u6b21\u6216\u8005\u56fa\u5b9a\u91cd\u8bd5\u7b49\u5f85\u65f6\u957f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        this.initialSleepTime = initialSleepTime;
    }

    public String getIncrementSleepTime() {
        return this.incrementSleepTime;
    }

    public long getIncrementSleepTimeLong() {
        return this.convertStringTimeToLong(this.incrementSleepTime);
    }

    public void setIncrementSleepTime(String incrementSleepTime) {
        if (StringUtils.isBlank((CharSequence)incrementSleepTime)) {
            return;
        }
        Matcher m = PATTERN_TIME.matcher(incrementSleepTime);
        if (!m.find()) {
            throw new IllegalArgumentException("\u4e8c\u6b21\u91cd\u8bd5\u7b49\u5f85\u589e\u52a0\u65f6\u957f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        this.incrementSleepTime = incrementSleepTime;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public void setAttemptNumber(int attemptNumber) {
        this.attemptNumber = attemptNumber;
    }

    public boolean isRetryEnable() {
        return this.retryEnable;
    }

    public void setRetryEnable(boolean retryEnable) {
        this.retryEnable = retryEnable;
    }
}

