/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.scheduler.api;

import com.dtyunxi.huieryun.scheduler.api.ISchedulerService;
import com.dtyunxi.huieryun.scheduler.exception.SchedulerInitException;
import com.dtyunxi.huieryun.scheduler.vo.JobRegistryVo;
import com.dtyunxi.huieryun.scheduler.vo.SchedulerRegistryVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerServiceFactory.class);

    public static ISchedulerService createSchedulerService(SchedulerRegistryVo schedulerRegistryVo, List<JobRegistryVo> jobVos) throws SchedulerInitException {
        ISchedulerService schedulerService = null;
        String className = null;
        switch (schedulerRegistryVo.getSchedulerType().toUpperCase()) {
            case "SCHEDULERX": {
                className = "com.dtyunxi.huieryun.scheduler.provider.elasticjob.SchedulerXSchedulerService";
                break;
            }
            case "QUARTZ": {
                className = "com.dtyunxi.huieryun.scheduler.provider.quartz.QuartzSchedulerService";
                break;
            }
            case "ELASTIC_JOB": {
                className = "com.dtyunxi.huieryun.scheduler.provider.elasticjob.ElasticJobSchedulerService";
                break;
            }
            default: {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u5ea6\u5668");
            }
        }
        try {
            schedulerService = (ISchedulerService)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
        schedulerService.init(schedulerRegistryVo, jobVos);
        return schedulerService;
    }
}

