/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.controller;

import com.dtyunxi.huieryun.searchindexbuilder.api.IIndicesManagerService;
import com.dtyunxi.huieryun.searchindexbuilder.config.ItemIndexCondition;
import com.dtyunxi.rest.RestResponse;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/indices"})
@Conditional(value={ItemIndexCondition.class})
public class IndicesManagerController {
    @Autowired
    private IIndicesManagerService indicesManagerService;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public RestResponse<String> getAllIndices() {
        return this.indicesManagerService.getAllIndices();
    }

    @RequestMapping(value={"/buildall"}, method={RequestMethod.GET})
    public RestResponse<String> buildAllIndices(@RequestParam(required=false) Map<String, ?> params) {
        if (null == params || params.isEmpty()) {
            return this.indicesManagerService.buildAllIndices();
        }
        return this.indicesManagerService.buildAllIndices(params);
    }

    @RequestMapping(value={"/build"}, method={RequestMethod.GET})
    public RestResponse<String> buildIndices(@RequestParam(value="aliasesName", required=true) String aliasesName, @RequestParam(required=false) Map<String, ?> params) {
        if (null == params || params.isEmpty()) {
            return this.indicesManagerService.buildIndices(aliasesName);
        }
        return this.indicesManagerService.buildIndices(aliasesName, params);
    }

    @RequestMapping(value={"/fixerror"}, method={RequestMethod.GET})
    public RestResponse<?> fixExceptionIndices(@RequestParam(value="aliasesName", required=true) String aliasesName) {
        return this.indicesManagerService.fixExceptionIndices(aliasesName);
    }
}

