/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.dto;

import com.dtyunxi.huieryun.opensearch.utils.CustomStringUtils;
import com.dtyunxi.huieryun.searchindexbuilder.annotations.IndicesEntityMapping;
import com.dtyunxi.huieryun.searchindexbuilder.constant.IndicesStructureType;
import com.dtyunxi.vo.BaseVo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableToIndexMappingDto
implements Serializable,
Comparable<TableToIndexMappingDto> {
    private static final long serialVersionUID = -4114154975644218572L;
    private String tableName;
    private Class<?> entityType;
    private String indicesTypeName;
    private String entityName;
    private String keyName = "id";
    private Class<?> keyClassType = Long.class;
    private IndicesStructureType indicesStructureType = IndicesStructureType.SINGLE;
    private List<String> entityFieldNames;
    private String entityIndicesServiceName;
    private String entityMapperName;
    private String indicesAliasesName;
    private String indicesPrefix;
    private String indicesFieldTypeDefineFileName;
    private boolean buildAll = false;
    private boolean pageBuildIndex = false;
    private boolean incrementUpdate = false;
    private boolean drdsShardingTable = false;
    private boolean partialUpdate = false;
    private int numberOfShards = 5;
    private int numberOfReplicas = 1;

    public TableToIndexMappingDto() {
    }

    public TableToIndexMappingDto(Class<?> entityType) {
        this.setEntityType(entityType);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
        if (entityType == null) {
            return;
        }
        IndicesEntityMapping alias = entityType.getAnnotation(IndicesEntityMapping.class);
        if (alias != null) {
            this.entityName = alias.name();
            if (!alias.indicesTypeName().equalsIgnoreCase("")) {
                this.indicesTypeName = alias.indicesTypeName().toLowerCase();
            }
            this.tableName = alias.tableName();
            this.keyName = alias.keyName();
            this.keyClassType = alias.keyClassType();
            this.indicesStructureType = alias.indicesStructureType();
            this.buildAll = alias.buildAll();
            if (this.buildAll) {
                this.pageBuildIndex = alias.pageBuildIndex();
            }
            this.incrementUpdate = alias.incrementUpdate();
            this.drdsShardingTable = alias.drdsShardingTable();
            this.partialUpdate = alias.partialUpdate();
            this.numberOfReplicas = alias.numberOfReplicas();
            this.numberOfShards = alias.numberOfShards();
        }
        if (this.entityName == null) {
            this.entityName = entityType.getSimpleName().replaceAll("Dto", "");
            this.entityName = CustomStringUtils.toClassPropertyName((String)this.entityName);
        }
    }

    public String getIndicesTypeName() {
        if (this.indicesTypeName == null) {
            this.indicesTypeName = this.entityName.toLowerCase();
        }
        return this.indicesTypeName;
    }

    public void setIndicesTypeName(String indicesTypeName) {
        this.indicesTypeName = indicesTypeName;
    }

    public String getIndicesAliasesName() {
        if (this.indicesAliasesName == null) {
            this.indicesAliasesName = String.format("%s_%s", this.getIndicesPrefix(), this.getIndicesTypeName());
        }
        return this.indicesAliasesName;
    }

    public void setIndicesAliasesName(String indicesAliasesName) {
        this.indicesAliasesName = indicesAliasesName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Class<?> getKeyClassType() {
        return this.keyClassType;
    }

    public void setKeyClassType(Class<?> keyClassType) {
        this.keyClassType = keyClassType;
    }

    public void setEntityFieldNames(List<String> entityFieldNames) {
        this.entityFieldNames = entityFieldNames;
    }

    public IndicesStructureType getIndicesStructureType() {
        return this.indicesStructureType;
    }

    public void setIndicesStructureType(IndicesStructureType indicesStructureType) {
        this.indicesStructureType = indicesStructureType;
    }

    public String getEntityIndicesServiceName() {
        if (this.entityIndicesServiceName == null) {
            this.entityIndicesServiceName = this.entityName + "IndexBuilderService";
        }
        return this.entityIndicesServiceName;
    }

    public void setEntityIndicesServiceName(String entityServiceName) {
        this.entityIndicesServiceName = entityServiceName;
    }

    public String getEntityMapperName() {
        if (this.entityMapperName == null) {
            this.entityMapperName = this.entityName + "Mapper";
        }
        return this.entityMapperName;
    }

    public void setEntityMapperName(String entityMapperName) {
        this.entityMapperName = entityMapperName;
    }

    public List<String> getEntityFieldNames() {
        if (this.entityFieldNames == null) {
            this.entityFieldNames = this.getFiledNames(this.entityType);
        }
        return this.entityFieldNames;
    }

    public List<String> getKeyClassFieldNames() {
        if (this.keyClassType == null) {
            return null;
        }
        if (this.keyClassType.getName().startsWith("java.lang")) {
            return null;
        }
        return this.getFiledNames(this.keyClassType);
    }

    private List<String> getFiledNames(Class<?> clazz) {
        ArrayList<String> filedNames = new ArrayList<String>();
        Field[] fields = null;
        while (clazz != BaseVo.class) {
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.getModifiers() == 8 || field.getModifiers() == 16) continue;
                filedNames.add(field.getName());
            }
            clazz = clazz.getSuperclass();
        }
        return filedNames;
    }

    public String getIndicesFieldTypeDefineFileName() {
        if (this.indicesFieldTypeDefineFileName == null) {
            this.indicesFieldTypeDefineFileName = String.format("/mappings/%s.json", this.getIndicesTypeName());
        }
        return this.indicesFieldTypeDefineFileName;
    }

    public String getIndicesPrefix() {
        return this.indicesPrefix;
    }

    public void setIndicesPrefix(String indicesPrefix) {
        this.indicesPrefix = indicesPrefix;
    }

    public boolean isBuildAll() {
        return this.buildAll;
    }

    public void setBuildAll(boolean buildAll) {
        this.buildAll = buildAll;
    }

    public boolean isPageBuildIndex() {
        return this.pageBuildIndex;
    }

    public void setPageBuildIndex(boolean pageBuildIndex) {
        this.pageBuildIndex = pageBuildIndex;
    }

    public boolean isIncrementUpdate() {
        return this.incrementUpdate;
    }

    public void setIncrementUpdate(boolean incrementUpdate) {
        this.incrementUpdate = incrementUpdate;
    }

    public boolean isDrdsShardingTable() {
        return this.drdsShardingTable;
    }

    public void setDrdsShardingTable(boolean drdsShardingTable) {
        this.drdsShardingTable = drdsShardingTable;
    }

    public void setIndicesFieldTypeDefineFileName(String indicesFieldTypeDefineFileName) {
        this.indicesFieldTypeDefineFileName = indicesFieldTypeDefineFileName;
    }

    public boolean isPartialUpdate() {
        return this.partialUpdate;
    }

    public void setPartialUpdate(boolean partialUpdate) {
        this.partialUpdate = partialUpdate;
    }

    public Map<String, Object> getIndicesSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>(2);
        settings.put("index.number_of_shards", this.numberOfShards);
        settings.put("index.number_of_replicas", this.numberOfReplicas);
        return settings;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TableToIndexMappingDto [");
        if (this.tableName != null) {
            builder.append("tableName=");
            builder.append(this.tableName);
            builder.append(", ");
        }
        if (this.entityType != null) {
            builder.append("entityType=");
            builder.append(this.entityType);
            builder.append(", ");
        }
        if (this.getIndicesTypeName() != null) {
            builder.append("indicesTypeName=");
            builder.append(this.getIndicesTypeName());
            builder.append(", ");
        }
        if (this.entityName != null) {
            builder.append("entityName=");
            builder.append(this.entityName);
            builder.append(", ");
        }
        if (this.keyName != null) {
            builder.append("keyName=");
            builder.append(this.keyName);
            builder.append(", ");
        }
        if (this.keyClassType != null) {
            builder.append("keyClassType=");
            builder.append(this.keyClassType);
            builder.append(", ");
        }
        if (this.indicesStructureType != null) {
            builder.append("indicesStructureType=");
            builder.append((Object)this.indicesStructureType);
            builder.append(", ");
        }
        if (this.entityFieldNames != null) {
            builder.append("entityFieldNames=");
            builder.append(this.entityFieldNames);
            builder.append(", ");
        }
        if (this.getEntityIndicesServiceName() != null) {
            builder.append("entityIndicesServiceName=");
            builder.append(this.getEntityIndicesServiceName());
            builder.append(", ");
        }
        if (this.getEntityMapperName() != null) {
            builder.append("entityMapperName=");
            builder.append(this.getEntityMapperName());
            builder.append(", ");
        }
        if (this.getIndicesAliasesName() != null) {
            builder.append("indicesAliasesName=");
            builder.append(this.getIndicesAliasesName());
            builder.append(", ");
        }
        if (this.getIndicesPrefix() != null) {
            builder.append("indicesPrefix=");
            builder.append(this.getIndicesPrefix());
            builder.append(", ");
        }
        if (this.getIndicesFieldTypeDefineFileName() != null) {
            builder.append("indicesFieldTypeDefineFileName=");
            builder.append(this.getIndicesFieldTypeDefineFileName());
            builder.append(", ");
        }
        builder.append("drdsShardingTable=");
        builder.append(this.drdsShardingTable);
        builder.append(", ");
        builder.append("partialUpdate=");
        builder.append(this.partialUpdate);
        builder.append(", ");
        builder.append("pageBuildIndex=");
        builder.append(this.pageBuildIndex);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(TableToIndexMappingDto arg0) {
        return this.entityName.compareToIgnoreCase(arg0.entityName);
    }
}

