/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.datadistribute.event.Column;
import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.datadistribute.event.DbChangeDataDistributeEvent;
import com.dtyunxi.huieryun.datadistribute.event.EventType;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.utils.CustomStringUtils;
import com.dtyunxi.huieryun.searchindexbuilder.api.IDbChangeEventMessageProcessor;
import com.dtyunxi.huieryun.searchindexbuilder.api.IIndexBuilderService;
import com.dtyunxi.huieryun.searchindexbuilder.dto.TableToIndexMappingDto;
import com.dtyunxi.util.JacksonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractDbChangeEventMessageProcessor
implements IDbChangeEventMessageProcessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected TableToIndexMappingDto[] mappings;
    private ApplicationContext context;
    private static final String PATTERN_SPLIT_TABLE_RULE = "_\\d+$";
    private static ConcurrentHashMap<String, TableToIndexMappingDto> mappingMaps = new ConcurrentHashMap();

    public AbstractDbChangeEventMessageProcessor(ApplicationContext context, TableToIndexMappingDto[] mappings) {
        this.context = context;
        this.mappings = mappings;
    }

    @Override
    public MessageResponse processDbChangeEvent(DataDistributeEvent event) {
        DbChangeDataDistributeEvent dbChangeEvent;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("process data distribute event !event={}", (Object)JacksonUtil.toJson((Object)event));
        }
        if ((dbChangeEvent = (DbChangeDataDistributeEvent)event).getTableName() == null) {
            this.logger.warn("process data distribute event failure!event={}", (Object)event);
            return MessageResponse.SUCCESS;
        }
        String tableName = dbChangeEvent.getTableName();
        if (tableName == null) {
            return MessageResponse.SUCCESS;
        }
        TableToIndexMappingDto mapping = this.getTableToIndexMapping(tableName);
        if (mapping == null) {
            return MessageResponse.SUCCESS;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("mapping={}", (Object)mapping);
        }
        if (!mapping.isIncrementUpdate()) {
            return MessageResponse.SUCCESS;
        }
        Map<String, String> columns = this.columnsToMap(mapping, dbChangeEvent);
        if (columns == null || columns.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u6570\u636e\u65e0\u53d8\u66f4");
            }
            return MessageResponse.SUCCESS;
        }
        switch (event.getEventType()) {
            case INSERT: {
                try {
                    return this.processInsert(mapping, columns);
                }
                catch (Throwable e) {
                    this.logger.error("process insert event failure!", e);
                }
            }
            case DELOGIC: 
            case DELETE: {
                try {
                    return this.processDelete(mapping, columns);
                }
                catch (Throwable e) {
                    this.logger.error("process delete event failure!", e);
                }
            }
            case UPDATE: {
                try {
                    return this.processUpdate(mapping, columns);
                }
                catch (Throwable e) {
                    this.logger.error("process update event failure!", e);
                }
            }
        }
        return MessageResponse.SUCCESS;
    }

    protected MessageResponse processInsert(TableToIndexMappingDto mapping, Map<String, String> columns) {
        if (!this.context.containsBean(mapping.getEntityIndicesServiceName())) {
            return MessageResponse.SUCCESS;
        }
        IIndexBuilderService service = (IIndexBuilderService)this.context.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class);
        if (service == null) {
            this.logger.error("\u6dfb\u52a0\u7d22\u5f15\u5931\u8d25\uff0c\u5b9e\u4f53\u540d={} \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01", (Object)mapping.getEntityName());
            return MessageResponse.SUCCESS;
        }
        if (service.getMapping() == null) {
            service.setMapping(mapping);
        }
        return service.addIndex(columns);
    }

    protected MessageResponse processUpdate(TableToIndexMappingDto mapping, Map<String, String> columns) {
        if (!this.context.containsBean(mapping.getEntityIndicesServiceName())) {
            return MessageResponse.SUCCESS;
        }
        IIndexBuilderService service = (IIndexBuilderService)this.context.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class);
        if (service == null) {
            this.logger.error("\u66f4\u65b0\u7d22\u5f15\u5931\u8d25\uff0c\u5b9e\u4f53\u540d={} \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01", (Object)mapping.getEntityName());
            return MessageResponse.SUCCESS;
        }
        if (service.getMapping() == null) {
            service.setMapping(mapping);
        }
        return service.updateIndex(columns);
    }

    protected MessageResponse processDelete(TableToIndexMappingDto mapping, Map<String, String> columns) {
        if (!this.context.containsBean(mapping.getEntityIndicesServiceName())) {
            return MessageResponse.SUCCESS;
        }
        IIndexBuilderService service = (IIndexBuilderService)this.context.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class);
        if (service == null) {
            this.logger.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25\uff0c\u5b9e\u4f53\u540d={} \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01", (Object)mapping.getEntityName());
            return MessageResponse.SUCCESS;
        }
        if (service.getMapping() == null) {
            service.setMapping(mapping);
        }
        return service.deleteIndex(columns);
    }

    private Map<String, String> columnsToMap(TableToIndexMappingDto mapping, DbChangeDataDistributeEvent event) {
        List<String> fieldNames = mapping.getEntityFieldNames();
        HashMap<String, String> columns = new HashMap<String, String>(fieldNames.size());
        boolean changed = false;
        for (Column column : event.getColumns()) {
            String propertyName = CustomStringUtils.toClassPropertyName((String)column.getName());
            if (!fieldNames.contains(propertyName)) continue;
            if (column.isChanged()) {
                changed = column.isChanged();
            }
            if (StringUtils.isBlank((CharSequence)column.getValue())) continue;
            columns.put(propertyName, column.getValue());
        }
        if (event.getEventType().equals((Object)EventType.UPDATE) && !changed) {
            return null;
        }
        return columns;
    }

    protected TableToIndexMappingDto getTableToIndexMapping(String tableName) {
        if (mappingMaps.contains(tableName)) {
            return mappingMaps.get(tableName);
        }
        if (this.mappings == null) {
            return null;
        }
        if (this.mappings.length == 0) {
            return null;
        }
        for (TableToIndexMappingDto mapping : this.mappings) {
            if (!mapping.getTableName().equalsIgnoreCase(tableName)) continue;
            mappingMaps.put(tableName, mapping);
            return mapping;
        }
        Pattern r = Pattern.compile(PATTERN_SPLIT_TABLE_RULE);
        Matcher m = r.matcher(tableName);
        if (m.find()) {
            String tableNewName = tableName.substring(0, m.start());
            TableToIndexMappingDto[] tableToIndexMappingDtoArray = this.mappings;
            int n = tableToIndexMappingDtoArray.length;
            for (int i = 0; i < n; ++i) {
                TableToIndexMappingDto mapping = tableToIndexMappingDtoArray[i];
                if (!mapping.getTableName().equalsIgnoreCase(tableNewName)) continue;
                mappingMaps.put(tableName, mapping);
                return mapping;
            }
        }
        for (TableToIndexMappingDto mapping : this.mappings) {
            Pattern pattern = Pattern.compile(mapping.getTableName());
            Matcher matcher = pattern.matcher(tableName);
            if (!matcher.matches()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} {} \u6309\u6b63\u5219\u5339\u914d\uff0c\u627e\u5230mapping", (Object)tableName, (Object)mapping.getTableName());
            }
            mappingMaps.put(tableName, mapping);
            return mapping;
        }
        return null;
    }
}

