/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.exceptions.IndexNotExistsException;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.utils.MappingUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchIndexDocVo;
import com.dtyunxi.huieryun.searchindexbuilder.api.BaseMapper;
import com.dtyunxi.huieryun.searchindexbuilder.api.IIndexBuilderService;
import com.dtyunxi.huieryun.searchindexbuilder.constant.IndicesStructureType;
import com.dtyunxi.huieryun.searchindexbuilder.dto.ShardingTableTopologyDto;
import com.dtyunxi.huieryun.searchindexbuilder.dto.TableToIndexMappingDto;
import com.dtyunxi.huieryun.searchindexbuilder.vo.ExceptionIndicesVo;
import com.dtyunxi.huieryun.searchindexbuilder.vo.IndicesVo;
import com.dtyunxi.util.JacksonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractIndexBuilderService<K, T>
implements IIndexBuilderService<K, T>,
ApplicationContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IIndicesAdminService indicesAdminService;
    protected ISearchIndexService searchIndexService;
    protected BaseMapper<K, T> mapper;
    protected TableToIndexMappingDto mapping;
    @Value(value="${huieryun.searchindexbuilder.update.retryOnConflict:0}")
    protected int retryOnConflict = 0;
    @Value(value="${huieryun.opensearchvo.indexGlobalSettings:#{null}}")
    protected String indexGlobalSettings;
    private ApplicationContext context;

    protected String getAliasesName() {
        return this.mapping.getIndicesAliasesName();
    }

    protected String getIndicesTypeName() {
        return this.mapping.getIndicesTypeName();
    }

    protected void createIndexAndMapping(String indexName) {
        boolean result = false;
        result = StringUtils.isNotBlank((CharSequence)this.indexGlobalSettings) ? this.getIndicesAdminService().createIndex(indexName, this.indexGlobalSettings) : this.getIndicesAdminService().createIndex(indexName, this.mapping.getIndicesSettings());
        if (!result) {
            throw new RuntimeException("createIndex,indexName" + indexName + "is Failure!");
        }
        String indexMappingFileName = this.mapping.getIndicesFieldTypeDefineFileName();
        if (indexMappingFileName == null) {
            return;
        }
        String mappingSource = MappingUtils.getMappingJson((String)indexMappingFileName, null);
        if (mappingSource == null) {
            mappingSource = MappingUtils.getMappingJson((String)"/templates/dynamic_templates.json", (ClassLoader)AbstractIndexBuilderService.class.getClassLoader());
        }
        if (mappingSource == null) {
            return;
        }
        result = this.getIndicesAdminService().putMapping(indexName, this.mapping.getIndicesTypeName(), mappingSource);
        if (!result) {
            throw new RuntimeException("createMapping,indexName" + indexName + "is Failure!");
        }
    }

    protected String createIndexNewName(String aliasesName) {
        return String.format("%s_%s", aliasesName, SF_DATE_TIME.format(System.currentTimeMillis()));
    }

    protected void addOrUpdateIndexWithAliasesRef(String indexAliasesName, String newIndexName) {
        if (this.getIndicesAdminService().existsIndex(new String[]{indexAliasesName})) {
            String[] oldIndexNames;
            for (String oldIndexName : oldIndexNames = this.getIndicesAdminService().getIndexNames(indexAliasesName)) {
                this.getIndicesAdminService().updateAliasesIndexRef(indexAliasesName, oldIndexName, newIndexName);
            }
            this.getIndicesAdminService().deleteIndex(oldIndexNames);
        } else {
            this.getIndicesAdminService().addIndexAliases(indexAliasesName, newIndexName);
        }
    }

    @Override
    public void buildAllIndex() {
        this.buildAllIndex(null);
    }

    @Override
    public void buildAllIndex(Map<String, ?> params) {
        String indexAliasesName = this.getAliasesName();
        String newIndexName = this.createIndexNewName(indexAliasesName);
        this.createIndexAndMapping(newIndexName);
        if (this.mapping.isDrdsShardingTable()) {
            if (null == params || params.isEmpty()) {
                this.shardingTableBuildAllIndex(newIndexName);
            } else {
                this.shardingTableBuildAllIndex(params, newIndexName);
            }
        } else if (null == params || params.isEmpty()) {
            this.singleTableBuildAllIndex(newIndexName);
        } else {
            this.singleTableBuildAllIndex(params, newIndexName);
        }
        this.addOrUpdateIndexWithAliasesRef(indexAliasesName, newIndexName);
    }

    private void singleTableBuildAllIndex(String newIndexName) {
        long count = this.getMapper().countAll();
        if (count <= 1000L || !this.mapping.isPageBuildIndex()) {
            List<T> list = this.getMapper().findAll();
            this.batchAddIndex(newIndexName, list);
        } else {
            List<T> list;
            Map<String, K> map = this.getMapper().findMaxAndMinId();
            K minId = map.get("minId");
            Object actualMaxId = null;
            long actualCount = 0L;
            int runtime = 0;
            do {
                actualMaxId = this.getMapper().findMaxId(minId, 1000);
                list = this.getMapper().findByMaxAndMinId(minId, actualMaxId);
                if (list.isEmpty()) break;
                minId = actualMaxId;
                this.batchAddIndex(newIndexName, list);
                actualCount += (long)list.size();
                ++runtime;
            } while (list.size() >= 1000);
            this.logger.info("db record count={},fetch record count={},runtime={}", new Object[]{count, actualCount, runtime});
        }
    }

    private void singleTableBuildAllIndex(Map<String, ?> params, String newIndexName) {
        long count = this.getMapper().countAll(params);
        if (count <= 1000L || !this.mapping.isPageBuildIndex()) {
            List<T> list = this.getMapper().findAll(params);
            this.batchAddIndex(newIndexName, list);
        } else {
            List<T> list;
            Map<String, K> map = this.getMapper().findMaxAndMinId(params);
            K minId = map.get("minId");
            Object actualMaxId = null;
            long actualCount = 0L;
            int runtime = 0;
            do {
                actualMaxId = this.getMapper().findMaxId(minId, 1000, params);
                list = this.getMapper().findByMaxAndMinId(minId, actualMaxId, params);
                if (list.isEmpty()) break;
                minId = actualMaxId;
                this.batchAddIndex(newIndexName, list);
                actualCount += (long)list.size();
                ++runtime;
            } while (list.size() >= 1000);
            this.logger.info("db record count={},fetch record count={},runtime={}", new Object[]{count, actualCount, runtime});
        }
    }

    private void shardingTableBuildAllIndex(String newIndexName) {
        List<ShardingTableTopologyDto> tables = this.getMapper().showShardingTableTopology(this.mapping.getTableName());
        for (ShardingTableTopologyDto table : tables) {
            List<T> list;
            long count = this.getMapper().countAll(table.getNodeName(), table.getTableName());
            if (count <= 1000L || !this.mapping.isPageBuildIndex()) {
                List<T> list2 = this.getMapper().findAll(table.getNodeName(), table.getTableName());
                this.batchAddIndex(newIndexName, list2);
                continue;
            }
            Map<String, K> map = this.getMapper().findMaxAndMinId(table.getNodeName(), table.getTableName());
            K minId = map.get("minId");
            Object actualMaxId = null;
            long actualCount = 0L;
            int runtime = 0;
            do {
                actualMaxId = this.getMapper().findMaxId(table.getNodeName(), table.getTableName(), minId, 1000);
                list = this.getMapper().findByMaxAndMinId(table.getNodeName(), table.getTableName(), minId, actualMaxId);
                if (list.isEmpty()) break;
                minId = actualMaxId;
                this.batchAddIndex(newIndexName, list);
                actualCount += (long)list.size();
                ++runtime;
            } while (list.size() >= 1000);
            this.logger.info("db record count={},fetch record count={},runtime={}", new Object[]{count, actualCount, runtime});
        }
    }

    private void shardingTableBuildAllIndex(Map<String, ?> params, String newIndexName) {
        List<ShardingTableTopologyDto> tables = this.getMapper().showShardingTableTopology(this.mapping.getTableName());
        for (ShardingTableTopologyDto table : tables) {
            List<T> list;
            long count = this.getMapper().countAll(table.getNodeName(), table.getTableName(), params);
            if (count <= 1000L || !this.mapping.isPageBuildIndex()) {
                List<T> list2 = this.getMapper().findAll(table.getNodeName(), table.getTableName(), params);
                this.batchAddIndex(newIndexName, list2);
                continue;
            }
            Map<String, K> map = this.getMapper().findMaxAndMinId(table.getNodeName(), table.getTableName(), params);
            K minId = map.get("minId");
            Object actualMaxId = null;
            long actualCount = 0L;
            int runtime = 0;
            do {
                actualMaxId = this.getMapper().findMaxId(table.getNodeName(), table.getTableName(), minId, 1000, params);
                list = this.getMapper().findByMaxAndMinId(table.getNodeName(), table.getTableName(), minId, actualMaxId, params);
                if (list.isEmpty()) break;
                minId = actualMaxId;
                this.batchAddIndex(newIndexName, list);
                actualCount += (long)list.size();
                ++runtime;
            } while (list.size() >= 1000);
            this.logger.info("db record count={},fetch record count={},runtime={}", new Object[]{count, actualCount, runtime});
        }
    }

    protected void batchAddIndex(String newIndexName, List<T> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        List<Map<String, Object>> docValueMaps = this.wrapDocs(list);
        if (null == docValueMaps || docValueMaps.isEmpty()) {
            return;
        }
        List<IndexDocContentVo> docs = this.convertIndexDocContent(docValueMaps);
        this.getSearchIndexService().addData(new IndexDocumentVo(newIndexName, this.mapping.getIndicesTypeName(), docs));
    }

    protected List<Map<String, Object>> wrapDocs(List<T> docValues) {
        return CustomBeanUtils.objectsToMaps(docValues);
    }

    protected Map<String, Object> wrapDoc(T docValue) {
        return CustomBeanUtils.describe(docValue);
    }

    @Override
    public List<IndicesVo> getIndicesInfo() {
        if (!this.getIndicesAdminService().existsIndex(new String[]{this.getAliasesName()})) {
            return null;
        }
        Map indicesDocCounts = null;
        try {
            indicesDocCounts = this.getIndicesAdminService().getIndexDocCounts(new String[]{this.getAliasesName()});
        }
        catch (Exception e) {
            this.logger.error("get indicesInfo failure!", (Throwable)e);
        }
        if (indicesDocCounts == null || indicesDocCounts.isEmpty()) {
            return null;
        }
        long rowCount = -1L;
        if (this.mapping.isBuildAll()) {
            if (this.mapping.isDrdsShardingTable()) {
                List<ShardingTableTopologyDto> tables = this.getMapper().showShardingTableTopology(this.mapping.getTableName());
                for (ShardingTableTopologyDto table : tables) {
                    rowCount += this.getMapper().countAll(table.getNodeName(), table.getTableName());
                }
            } else {
                rowCount = this.getMapper().countAll();
            }
        }
        return this.wrapIndicesInfo(indicesDocCounts, rowCount);
    }

    protected List<IndicesVo> wrapIndicesInfo(Map<String, Long> indicesDocCounts, long rowCount) {
        ArrayList<IndicesVo> indicesVos = new ArrayList<IndicesVo>();
        IndicesVo indicesVo = null;
        for (Map.Entry<String, Long> entry : indicesDocCounts.entrySet()) {
            indicesVo = new IndicesVo();
            indicesVo.setAliasesName(this.getAliasesName());
            indicesVo.setTypeName(this.mapping.getIndicesTypeName());
            indicesVo.setIndicesName(entry.getKey());
            indicesVo.setIndicesDocCount(entry.getValue());
            if (rowCount >= 0L) {
                indicesVo.setTableRowCount(rowCount);
            } else {
                indicesVo.setTableRowCount(entry.getValue());
            }
            String[] keyArrays = entry.getKey().split("_");
            if (keyArrays.length > 2) {
                indicesVo.setLastUpdateTime(keyArrays[2]);
            }
            if (rowCount >= 0L && rowCount != entry.getValue()) {
                indicesVo.setStatusName("\u6570\u91cf\u5f02\u5e38");
            } else {
                indicesVo.setStatusName("\u6b63\u5e38");
            }
            indicesVos.add(indicesVo);
        }
        return indicesVos;
    }

    @Override
    public MessageResponse addIndex(Map<String, String> columns) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("process addIndex event,indicesTypeName={},columns={}", (Object)this.mapping.getIndicesTypeName(), (Object)JacksonUtil.toJson(columns));
        }
        Map<String, Object> convertMap = null;
        if (this.mapping.getIndicesStructureType() == IndicesStructureType.SINGLE) {
            convertMap = CustomBeanUtils.convertMap(columns);
        } else {
            try {
                convertMap = this.wrapDoc(CustomBeanUtils.populate(columns, this.mapping.getEntityType()));
            }
            catch (Exception e) {
                this.logger.error("wrapDoc failure!", (Throwable)e);
            }
        }
        if (convertMap == null) {
            return MessageResponse.SUCCESS;
        }
        try {
            IndexDocumentVo documentVo = this.convertIndexDocumentVo(convertMap);
            this.getSearchIndexService().addData(documentVo);
        }
        catch (IndexNotExistsException e) {
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    protected MessageResponse addIndex(String key, T docValue) {
        if (docValue == null) {
            return MessageResponse.SUCCESS;
        }
        IndexDocumentVo documentVo = this.convertIndexDocumentVo(CustomBeanUtils.describe(docValue));
        this.getSearchIndexService().addData(documentVo);
        return MessageResponse.SUCCESS;
    }

    @Override
    public MessageResponse updateIndex(Map<String, String> columns) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("process updateIndex event,getIndicesTypeName={},columns={}", (Object)this.getIndicesTypeName(), (Object)JacksonUtil.toJson(columns));
        }
        Map<String, Object> convertMap = null;
        if (this.mapping.getIndicesStructureType() == IndicesStructureType.SINGLE) {
            convertMap = CustomBeanUtils.convertMap(columns);
        } else {
            try {
                convertMap = this.wrapDoc(CustomBeanUtils.populate(columns, this.mapping.getEntityType()));
            }
            catch (Exception e) {
                this.logger.error("wrapDoc failure!", (Throwable)e);
            }
        }
        if (convertMap == null) {
            return MessageResponse.SUCCESS;
        }
        try {
            IndexDocumentVo documentVo = this.convertIndexDocumentVo(convertMap);
            if (this.mapping.isPartialUpdate()) {
                this.getSearchIndexService().updateData(documentVo);
            } else {
                this.getSearchIndexService().addData(documentVo);
            }
        }
        catch (IndexNotExistsException e) {
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    public MessageResponse updateIndices(Collection<T> docValues) {
        if (docValues == null) {
            return MessageResponse.SUCCESS;
        }
        if (!this.getIndicesAdminService().existsIndex(new String[]{this.getAliasesName()})) {
            this.createIndexAndMapping(this.getAliasesName());
        }
        IndexDocumentVo documentVo = this.convertIndexDocumentVo(CustomBeanUtils.objectsToMaps(docValues));
        if (this.mapping.isPartialUpdate()) {
            this.getSearchIndexService().updateData(documentVo);
        } else {
            this.getSearchIndexService().addData(documentVo);
        }
        return MessageResponse.SUCCESS;
    }

    private IndexDocumentVo convertIndexDocumentVo(String key) {
        ArrayList<IndexDocContentVo> docs = new ArrayList<IndexDocContentVo>(1);
        IndexDocContentVo doc = new IndexDocContentVo();
        doc.setIndexId(key);
        docs.add(doc);
        return new IndexDocumentVo(this.getAliasesName(), this.getIndicesTypeName(), docs);
    }

    private IndexDocumentVo convertIndexDocumentVo(Map<String, Object> docValueMap) {
        ArrayList<IndexDocContentVo> docs = new ArrayList<IndexDocContentVo>(1);
        IndexDocContentVo doc = this.wrapIndexDocContentVo(docValueMap);
        docs.add(doc);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.getAliasesName(), this.getIndicesTypeName(), docs);
        documentVo.setRetryOnConflict(this.retryOnConflict);
        return documentVo;
    }

    private IndexDocContentVo wrapIndexDocContentVo(Map<String, Object> docValueMap) {
        IndexDocContentVo doc = new IndexDocContentVo();
        Object key = docValueMap.get(this.mapping.getKeyName());
        if (!this.mapping.getKeyClassType().getName().startsWith("java.lang")) {
            docValueMap.remove(this.mapping.getKeyName());
            doc.setIndexId(key.toString().replaceAll("\"", ""));
        } else {
            doc.setIndexId(key.toString());
        }
        doc.setDocValueMap(docValueMap);
        return doc;
    }

    private IndexDocumentVo convertIndexDocumentVo(List<Map<String, Object>> docValueMaps) {
        List<IndexDocContentVo> docs = this.convertIndexDocContent(docValueMaps);
        return new IndexDocumentVo(this.getAliasesName(), this.getIndicesTypeName(), docs);
    }

    private List<IndexDocContentVo> convertIndexDocContent(List<Map<String, Object>> docValueMaps) {
        ArrayList<IndexDocContentVo> docs = new ArrayList<IndexDocContentVo>(docValueMaps.size());
        IndexDocContentVo doc = null;
        for (Map<String, Object> docValueMap : docValueMaps) {
            doc = this.wrapIndexDocContentVo(docValueMap);
            docs.add(doc);
        }
        return docs;
    }

    public MessageResponse updateIndex(String key, T docValue) {
        if (docValue == null) {
            return MessageResponse.SUCCESS;
        }
        try {
            IndexDocumentVo documentVo = this.convertIndexDocumentVo(CustomBeanUtils.describe(docValue));
            if (this.mapping.isPartialUpdate()) {
                this.getSearchIndexService().updateData(documentVo);
            } else {
                this.getSearchIndexService().addData(documentVo);
            }
        }
        catch (IndexNotExistsException e) {
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    @Override
    public MessageResponse updateIndexByCondition(List<FilterFieldVo> conditions, Map<String, Object> docValueMap) {
        SearchConditionVo conditionVo = new SearchConditionVo(this.getAliasesName(), this.getIndicesTypeName());
        conditionVo.setFilterFields(conditions);
        this.getSearchIndexService().updateDataByCondition(conditionVo, docValueMap);
        return MessageResponse.SUCCESS;
    }

    @Override
    public MessageResponse deleteIndex(Map<String, String> columns) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("process deleteIndex event,indicesTypeName()={},columns={}", (Object)this.getIndicesTypeName(), (Object)JacksonUtil.toJson(columns));
        }
        return this.deleteIndexByKey(columns.get(this.mapping.getKeyName()));
    }

    public MessageResponse deleteIndexByKey(String key) {
        try {
            this.getSearchIndexService().deleteData(this.convertIndexDocumentVo(key));
        }
        catch (IndexNotExistsException e) {
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    @Override
    public MessageResponse deleteIndexByCondition(List<FilterFieldVo> conditions) {
        SearchConditionVo conditionVo = new SearchConditionVo(this.getAliasesName(), this.getIndicesTypeName());
        conditionVo.setFilterFields(conditions);
        this.getSearchIndexService().deleteDataByCondition(conditionVo);
        return MessageResponse.SUCCESS;
    }

    public T getIndexByKey(String key) {
        try {
            IndexDocContentVo indexDoc = (IndexDocContentVo)this.getSearchIndexService().getIndexDocContent(new SearchIndexDocVo(this.getAliasesName(), this.getIndicesTypeName(), key)).get(0);
            return (T)indexDoc.getDocValue(this.mapping.getEntityType());
        }
        catch (IndexNotExistsException e) {
            return null;
        }
    }

    @Override
    public ExceptionIndicesVo fixExceptionIndices() {
        List<K> newList = this.getMapper().findAllKey();
        if (newList.size() > 50000) {
            throw new RuntimeException("\u7d22\u5f15\u91cf\u8fc7\u5927\uff0c\u5efa\u8bae\u91c7\u7528\u91cd\u65b0\u6784\u5efa\u65b9\u6cd5\u4fee\u590d\uff01");
        }
        List oldList = this.getIndicesAdminService().getIndexIds(this.getAliasesName(), 0, 1000);
        ExceptionIndicesVo vo = new ExceptionIndicesVo();
        vo.setAliasesName(this.getAliasesName());
        vo.setTypeName(this.getIndicesTypeName());
        ArrayList<String> missedKeys = new ArrayList<String>();
        ArrayList<String> deletedKeys = new ArrayList<String>();
        deletedKeys.addAll(oldList);
        for (K k : newList) {
            missedKeys.add(CustomBeanUtils.toJson(k));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("missedKeys.size={},deletedKeys.size={},oldList.size={}", new Object[]{missedKeys.size(), deletedKeys.size(), oldList.size()});
        }
        deletedKeys.removeAll(missedKeys);
        missedKeys.removeAll(oldList);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("missedKeys.size={},deletedKeys.size={},oldList.size={}", new Object[]{missedKeys.size(), deletedKeys.size(), oldList.size()});
        }
        vo.setDeletedKeys(deletedKeys);
        vo.setMissedKeys(missedKeys);
        if (!deletedKeys.isEmpty()) {
            ArrayList<Object> deletedDocs = new ArrayList<Object>(deletedKeys.size());
            if (this.mapping.getKeyClassFieldNames() != null) {
                SearchIndexDocVo searchCondition = new SearchIndexDocVo(this.getAliasesName(), this.getIndicesTypeName());
                searchCondition.setIds(deletedKeys.toArray(new String[deletedKeys.size()]));
                searchCondition.setIncludeFields(this.mapping.getKeyClassFieldNames().toArray(new String[this.mapping.getKeyClassFieldNames().size()]));
                List list = this.getSearchIndexService().getIndexDocContent(searchCondition);
                for (IndexDocContentVo doc : list) {
                    deletedDocs.add(doc.getDocValueMap());
                }
            } else {
                for (String deletedKey : deletedKeys) {
                    deletedDocs.add(deletedKey);
                }
            }
            vo.setDeletedDocs(deletedDocs);
            IndexDocumentVo doc = new IndexDocumentVo(this.getAliasesName(), this.getIndicesTypeName());
            ArrayList<IndexDocContentVo> contents = new ArrayList<IndexDocContentVo>(deletedKeys.size());
            for (String deletedKey : deletedKeys) {
                IndexDocContentVo content = new IndexDocContentVo();
                content.setIndexId(deletedKey);
                contents.add(content);
            }
            doc.setContents(contents);
            this.getSearchIndexService().deleteData(doc);
        }
        if (!missedKeys.isEmpty()) {
            ArrayList<Object> missedDocs = new ArrayList<Object>(missedKeys.size());
            block4: for (String missedKey : missedKeys) {
                for (K entity : newList) {
                    if (!CustomBeanUtils.toJson(entity).equals(missedKey)) continue;
                    missedDocs.add(entity.toString());
                    continue block4;
                }
            }
            vo.setMissedDocs(missedDocs);
        }
        return vo;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public IIndicesAdminService getIndicesAdminService() {
        if (this.indicesAdminService == null) {
            this.indicesAdminService = (IIndicesAdminService)this.context.getBean(IIndicesAdminService.class);
        }
        return this.indicesAdminService;
    }

    public ISearchIndexService getSearchIndexService() {
        if (this.searchIndexService == null) {
            this.searchIndexService = (ISearchIndexService)this.context.getBean(ISearchIndexService.class);
        }
        return this.searchIndexService;
    }

    protected BaseMapper<K, T> getMapper() {
        if (this.mapper == null) {
            this.mapper = (BaseMapper)this.context.getBean(this.mapping.getEntityMapperName(), BaseMapper.class);
        }
        return this.mapper;
    }

    protected void setMapper(BaseMapper<K, T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public TableToIndexMappingDto getMapping() {
        return this.mapping;
    }

    @Override
    public void setMapping(TableToIndexMappingDto mapping) {
        this.mapping = mapping;
    }
}

