/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.searchindexbuilder.api.IDbChangeEventMessageProcessor;
import com.dtyunxi.huieryun.searchindexbuilder.api.ILogEventMessageProcessor;
import com.dtyunxi.huieryun.searchindexbuilder.impl.RedisLockClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class DataCollectMessageProcessorImpl
implements IMessageProcessor<DataDistributeEvent> {
    private static final Logger logger = LoggerFactory.getLogger(DataCollectMessageProcessorImpl.class);
    @Autowired
    private ApplicationContext context;
    private RedisLockClient redisLockClient;
    private IDbChangeEventMessageProcessor dbChangeEventMessageProcessor;
    private ILogEventMessageProcessor logEventMessageProcessor;

    public MessageResponse process(DataDistributeEvent event) {
        logger.info("process data distribute event,event={}", (Object)event);
        if (event == null) {
            return MessageResponse.SUCCESS;
        }
        if (event.getEventType() == null) {
            logger.error("process data distribute event failure,event={}", (Object)event);
            return MessageResponse.SUCCESS;
        }
        switch (event.getEventType()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: 
            case DELOGIC: {
                if (this.getRedisLockClient().isLock().booleanValue()) {
                    return MessageResponse.ERROR;
                }
                return this.getDbChangeEventMessageProcessor().processDbChangeEvent(event);
            }
            case FRONTEND_BURYING_POINT_LOG: 
            case OPERATION_LOG: 
            case AUDIT_LOG: {
                return this.getLogEventMessageProcessor().processEvent(event);
            }
        }
        return MessageResponse.SUCCESS;
    }

    private IDbChangeEventMessageProcessor getDbChangeEventMessageProcessor() {
        if (this.dbChangeEventMessageProcessor == null) {
            this.dbChangeEventMessageProcessor = (IDbChangeEventMessageProcessor)this.context.getBean(IDbChangeEventMessageProcessor.class);
        }
        return this.dbChangeEventMessageProcessor;
    }

    private ILogEventMessageProcessor getLogEventMessageProcessor() {
        if (this.logEventMessageProcessor == null) {
            this.logEventMessageProcessor = (ILogEventMessageProcessor)this.context.getBean(ILogEventMessageProcessor.class);
        }
        return this.logEventMessageProcessor;
    }

    private RedisLockClient getRedisLockClient() {
        if (this.redisLockClient == null) {
            this.redisLockClient = (RedisLockClient)this.context.getBean(RedisLockClient.class);
        }
        return this.redisLockClient;
    }
}

