/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.searchindexbuilder.annotations.IndicesDtoComponentScan;
import com.dtyunxi.huieryun.searchindexbuilder.annotations.IndicesEntityMapping;
import com.dtyunxi.huieryun.searchindexbuilder.dto.TableToIndexMappingDto;
import com.dtyunxi.huieryun.searchindexbuilder.impl.IndicesDtoBeanPostProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class IndicesDtoBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(IndicesDtoBeanDefinitionRegistrar.class);
    private static final String RESOURCE_PATTERN = "**/*.class";
    private static final Map<String, Class<?>> UNDERLYING_MAPPING = new HashMap();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annAttr = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(IndicesDtoComponentScan.class.getName()));
        Object[] basePackages = annAttr.getStringArray("value");
        if (ObjectUtils.isEmpty((Object[])basePackages)) {
            return;
        }
        List<Class<?>> candidates = this.scanPackages((String[])basePackages);
        if (candidates.isEmpty()) {
            logger.info("\u626b\u63cf\u6307\u5b9a\u542b\u6709\u6570\u636e\u5e93\u8868\u4e0e\u7d22\u5f15\u6620\u5c04\u7c7b\u6ce8\u89e3\u7684\u57fa\u7840\u5305{}\u65f6\u672a\u53d1\u73b0\u5b9e\u4f53\u7c7b", (Object)basePackages.toString());
            return;
        }
        this.registerHsfBeanPostProcessor(registry);
        this.registerBeanDefinitions(candidates, registry);
    }

    private void registerBeanDefinitions(List<Class<?>> internalClasses, BeanDefinitionRegistry registry) {
        for (Class<?> clazz : internalClasses) {
            if (UNDERLYING_MAPPING.values().contains(clazz)) {
                logger.debug("\u91cd\u590d\u626b\u63cf{}\u7c7b,\u5ffd\u7565\u91cd\u590d\u6ce8\u518c", (Object)clazz.getName());
                continue;
            }
            String beanName = this.generateBeanName(clazz);
            RootBeanDefinition mappingBeanDef = new RootBeanDefinition(TableToIndexMappingDto.class);
            registry.registerBeanDefinition(beanName, (BeanDefinition)mappingBeanDef);
            RootBeanDefinition dtoBeanDef = new RootBeanDefinition(clazz);
            registry.registerBeanDefinition(ClassUtils.getShortNameAsProperty(clazz), (BeanDefinition)dtoBeanDef);
        }
    }

    private void registerHsfBeanPostProcessor(BeanDefinitionRegistry registry) {
        String beanName = ClassUtils.getShortNameAsProperty(IndicesDtoBeanPostProcessor.class);
        if (!registry.containsBeanDefinition(beanName)) {
            registry.registerBeanDefinition(beanName, (BeanDefinition)new RootBeanDefinition(IndicesDtoBeanPostProcessor.class));
        }
    }

    private String generateBeanName(Class<?> entity) {
        return ClassUtils.getShortNameAsProperty(entity).replaceAll("Dto", "IndexMapping");
    }

    private List<Class<?>> scanPackages(String[] basePackages) {
        ArrayList candidates = new ArrayList();
        for (String pkg : basePackages) {
            try {
                candidates.addAll(this.findCandidateClasses(pkg));
            }
            catch (IOException e) {
                logger.error("\u626b\u63cf\u6307\u5b9a\u542b\u6709\u6570\u636e\u5e93\u8868\u4e0e\u7d22\u5f15\u6620\u5c04\u7c7b\u6ce8\u89e3\u7684\u57fa\u7840\u5305{}\u65f6\u51fa\u73b0\u5f02\u5e38", (Object)pkg);
            }
        }
        return candidates;
    }

    private List<Class<?>> findCandidateClasses(String basePackage) throws IOException {
        Resource[] resources;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb\u626b\u63cf\u6307\u5b9a\u5305{}\u4e0b\u7684\u6240\u6709\u7c7b" + basePackage);
        }
        ArrayList candidates = new ArrayList();
        String packageSearchPath = this.replaceDotByDelimiter(basePackage) + '/' + RESOURCE_PATTERN;
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        SimpleMetadataReaderFactory readerFactory = new SimpleMetadataReaderFactory((ResourceLoader)resourceLoader);
        for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader).getResources(packageSearchPath)) {
            IndicesEntityMapping alias;
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            Class<?> candidateClass = this.transform(reader.getClassMetadata().getClassName());
            if (candidateClass == null || (alias = candidateClass.getAnnotation(IndicesEntityMapping.class)) == null) continue;
            candidates.add(candidateClass);
            logger.debug("\u626b\u63cf\u5230\u7b26\u5408\u542b\u6709\u6570\u636e\u5e93\u8868\u4e0e\u7d22\u5f15\u6620\u5c04\u7c7b\u6ce8\u89e3\u57fa\u7840\u7c7b:{}" + candidateClass.getName());
        }
        return candidates;
    }

    private String replaceDotByDelimiter(String path) {
        return StringUtils.replace((String)path, (String)".", (String)"/");
    }

    private Class<?> transform(String className) {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.info("\u672a\u627e\u5230\u6307\u5b9a\u542b\u6709\u6570\u636e\u5e93\u8868\u4e0e\u7d22\u5f15\u6620\u5c04\u7c7b\u6ce8\u89e3\u57fa\u7840\u7c7b:{}", (Object)className);
        }
        return clazz;
    }

    public static Class<?> getUnderlyingClass(String hsfBeanName) {
        return UNDERLYING_MAPPING.get(hsfBeanName);
    }
}

