/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.searchindexbuilder.api.IIndexBuilderService;
import com.dtyunxi.huieryun.searchindexbuilder.dto.TableToIndexMappingDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

public class IndicesDtoBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements InitializingBean,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(IndicesDtoBeanPostProcessor.class);
    private BeanFactory beanFactory;
    private String indicesPrefix;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.indicesPrefix = (String)this.beanFactory.getBean("indicesPrefix", String.class);
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        IIndexBuilderService indexBuilderService;
        if (!(bean instanceof TableToIndexMappingDto)) {
            return super.postProcessAfterInstantiation(bean, beanName);
        }
        logger.debug("beanName={}", (Object)beanName);
        TableToIndexMappingDto mapping = (TableToIndexMappingDto)bean;
        mapping.setIndicesPrefix(this.indicesPrefix);
        String dtoBeanName = beanName.replaceAll("IndexMapping", "Dto");
        if (!this.beanFactory.containsBean(dtoBeanName)) {
            return super.postProcessAfterInstantiation(bean, beanName);
        }
        Object dto = this.beanFactory.getBean(dtoBeanName);
        mapping.setEntityType(dto.getClass());
        logger.debug("set entity type,beanName={},entityType={}", (Object)beanName, dto.getClass());
        if (this.beanFactory.containsBean(mapping.getEntityIndicesServiceName()) && (indexBuilderService = (IIndexBuilderService)this.beanFactory.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class)) != null) {
            logger.debug("set mapping into indexBuilderService,beanName={},entityIndicesServiceName={}", (Object)beanName, (Object)mapping.getEntityIndicesServiceName());
            indexBuilderService.setMapping(mapping);
        }
        return super.postProcessAfterInstantiation(bean, beanName);
    }
}

