/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.searchindexbuilder.api.IIndexBuilderService;
import com.dtyunxi.huieryun.searchindexbuilder.api.IIndicesManagerService;
import com.dtyunxi.huieryun.searchindexbuilder.dto.TableToIndexMappingDto;
import com.dtyunxi.huieryun.searchindexbuilder.impl.RedisLockClient;
import com.dtyunxi.huieryun.searchindexbuilder.vo.ExceptionIndicesVo;
import com.dtyunxi.huieryun.searchindexbuilder.vo.IndicesVo;
import com.dtyunxi.rest.RestResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IndicesManagerServiceImpl
implements IIndicesManagerService,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(IndicesManagerServiceImpl.class);
    protected ApplicationContext context;
    protected RedisLockClient redisLockClient;
    protected TableToIndexMappingDto[] mappings;

    public IndicesManagerServiceImpl(TableToIndexMappingDto[] mappings) {
        this.mappings = mappings;
    }

    @Override
    public RestResponse<String> getAllIndices() {
        ArrayList<IndicesVo> list = new ArrayList<IndicesVo>();
        try {
            for (TableToIndexMappingDto mapping : this.mappings) {
                List<IndicesVo> indicesVos;
                IIndexBuilderService indexBuilderService;
                try {
                    indexBuilderService = (IIndexBuilderService)this.context.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class);
                }
                catch (Exception e) {
                    logger.warn("\u67e5\u770b\u7d22\u5f15\u5e93\u5931\u8d25\uff0c\u5b9e\u4f53\u540d={} \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01", (Object)mapping.getEntityName(), (Object)e);
                    continue;
                }
                if (indexBuilderService.getMapping() == null) {
                    indexBuilderService.setMapping(mapping);
                }
                if ((indicesVos = indexBuilderService.getIndicesInfo()) == null || indicesVos.isEmpty()) continue;
                list.addAll(list.size(), indicesVos);
            }
            return new RestResponse(list);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u7d22\u5f15\u5e93\u5931\u8d25:", (Throwable)e);
            return new RestResponse("-1", "\u67e5\u770b\u7d22\u5f15\u5e93\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @Override
    public RestResponse<String> buildAllIndices() {
        return this.buildAllIndices(null);
    }

    @Override
    public RestResponse<String> buildAllIndices(Map<String, ?> params) {
        if (!this.getRedisLockClient().lock().booleanValue()) {
            return new RestResponse("-1", "\u7d22\u5f15\u5e93\u521d\u59cb\u5316\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        int failureCount = 0;
        for (TableToIndexMappingDto mapping : this.mappings) {
            RestResponse<String> response;
            if (!mapping.isBuildAll() || !(response = this.buildIndices(mapping, params)).getResultCode().equals("-1")) continue;
            ++failureCount;
        }
        this.getRedisLockClient().unlock();
        if (failureCount > 0) {
            return new RestResponse("-1", "\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25\uff01");
        }
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<String> buildIndices(String aliasesName) {
        return this.buildIndices(aliasesName, null);
    }

    private RestResponse<String> buildIndices(TableToIndexMappingDto mapping, Map<String, ?> params) {
        IIndexBuilderService indexBuilderService = null;
        try {
            indexBuilderService = (IIndexBuilderService)this.context.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u7d22\u5f15\u5e93\u5931\u8d25\uff0c\u5b9e\u4f53\u540d={} \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01", (Object)mapping.getEntityName(), (Object)e);
            return new RestResponse("-1", "\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25\uff0c\u5b9e\u4f53\u540d=" + mapping.getEntityName() + " \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01");
        }
        if (indexBuilderService.getMapping() == null) {
            indexBuilderService.setMapping(mapping);
        }
        try {
            indexBuilderService.buildAllIndex(params);
        }
        catch (Exception e) {
            this.getRedisLockClient().unlock();
            logger.error("\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25:", (Throwable)e);
            return new RestResponse("-1", "\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25\uff01" + e.getMessage());
        }
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<String> buildIndices(String aliasesName, Map<String, ?> params) {
        if (!this.getRedisLockClient().lock().booleanValue()) {
            return new RestResponse("-1", "\u7d22\u5f15\u5e93\u521d\u59cb\u5316\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        TableToIndexMappingDto mapping = null;
        for (int i = 0; i < this.mappings.length; ++i) {
            if (!this.mappings[i].getIndicesAliasesName().equalsIgnoreCase(aliasesName)) continue;
            mapping = this.mappings[i];
            break;
        }
        if (mapping == null) {
            this.getRedisLockClient().unlock();
            return new RestResponse("-1", String.format("\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25\uff01aliasesName=%s\u4e0d\u5b58\u5728\uff01", aliasesName));
        }
        RestResponse<String> response = this.buildIndices(mapping, params);
        this.getRedisLockClient().unlock();
        return response;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    protected ApplicationContext getContext() {
        return this.context;
    }

    protected RedisLockClient getRedisLockClient() {
        if (this.redisLockClient == null) {
            this.redisLockClient = (RedisLockClient)this.context.getBean(RedisLockClient.class);
        }
        return this.redisLockClient;
    }

    public TableToIndexMappingDto[] getMappings() {
        return this.mappings;
    }

    @Override
    public RestResponse<?> fixExceptionIndices(String aliasesName) {
        TableToIndexMappingDto mapping = null;
        for (int i = 0; i < this.mappings.length; ++i) {
            if (!this.mappings[i].getIndicesAliasesName().equalsIgnoreCase(aliasesName)) continue;
            mapping = this.mappings[i];
            break;
        }
        if (mapping == null) {
            return new RestResponse("-1", String.format("\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25\uff01aliasesName=%s\u4e0d\u5b58\u5728\uff01", aliasesName));
        }
        IIndexBuilderService indexBuilderService = null;
        try {
            indexBuilderService = (IIndexBuilderService)this.context.getBean(mapping.getEntityIndicesServiceName(), IIndexBuilderService.class);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u7d22\u5f15\u5e93\u5931\u8d25\uff0c\u5b9e\u4f53\u540d={} \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01", (Object)mapping.getEntityName(), (Object)e);
            return new RestResponse("-1", "\u521d\u59cb\u7d22\u5f15\u5e93\u5931\u8d25\uff0c\u5b9e\u4f53\u540d=" + mapping.getEntityName() + " \u627e\u4e0d\u5230\u5bf9\u5e94\u6784\u5efa\u670d\u52a1\u7c7b\uff01");
        }
        if (indexBuilderService.getMapping() == null) {
            indexBuilderService.setMapping(mapping);
        }
        try {
            ExceptionIndicesVo indicesVo = indexBuilderService.fixExceptionIndices();
            return new RestResponse((Object)indicesVo);
        }
        catch (Exception e) {
            logger.warn("\u4fee\u590d\u7d22\u5f15\u5e93\u5931\u8d25\uff01", (Throwable)e);
            return new RestResponse("-1", "\u67e5\u770b\u7d22\u5f15\u5e93\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

