/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.impl;

import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.searchindexbuilder.api.IDataCollectClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class MqDataCollectClient
implements IDataCollectClient {
    private static final Logger logger = LoggerFactory.getLogger(MqDataCollectClient.class);
    @Autowired
    private IMQService mqService;
    @Value(value="${huieryun.datadistribute.mqtopic:}")
    private String topicName;
    @Value(value="${huieryun.searchindexbuilder.queuename:}")
    private String queueName;
    @Value(value="${huieryun.searchindexbuilder.usetopicasroutingkey:true}")
    private Boolean useTopicAsRoutingKey = true;
    @Autowired
    @Qualifier(value="dataCollectMessageProcessor")
    private IMessageProcessor<DataDistributeEvent> processor;

    @Override
    public void start() {
        logger.info("DataCollectClientService begin start");
        if (StringUtils.isBlank((CharSequence)this.topicName)) {
            throw new IllegalArgumentException("MQ \u4e3b\u9898\u540d\u5c1a\u672a\u914d\u7f6e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.queueName)) {
            throw new IllegalArgumentException("MQ \u961f\u5217\u540d\u5c1a\u672a\u914d\u7f6e\uff01");
        }
        IConsumer mqConsumer = this.mqService.createConsumer();
        if (this.useTopicAsRoutingKey.booleanValue()) {
            mqConsumer.subscribe(this.topicName, this.queueName, this.topicName, this.processor);
        } else {
            mqConsumer.subscribe(this.topicName, this.queueName, null, this.processor);
        }
        logger.info("DataCollectClientService started,MQ Consumer subscribed!");
    }

    @Override
    public void stop() {
        logger.info("DataCollectClientService stoped!");
    }
}

