/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.searchindexbuilder.interceptor;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DrdsShardingTableMybatisSqlInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrdsShardingTableMybatisSqlInterceptor.class);
    private static final String DRDS_SHARDING_TABLE_NAME = "drdsTableName";
    private static final String DRDS_NODE_NAME = "drdsNodeName";
    private static final String DRDS_HINT = "/!TDDL:node='${drdsNodeName}'*/";
    private static final String PATTERN_SPLIT_TABLE_RULE = "_\\d+$";
    private static final int MAPPED_STATEMENT_INDEX = 0;
    private static final int PARAMETER_INDEX = 1;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] queryArgs = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)queryArgs[0];
        Object parameter = queryArgs[1];
        if (null == parameter) {
            return invocation.proceed();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u5230\u7684parameterObject\uff1a{}", (Object)parameter.getClass().getName());
        }
        String nodeName = null;
        String tableName = null;
        if (null != parameter && parameter instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap parameterMap = (MapperMethod.ParamMap)parameter;
            if (parameterMap.containsKey((Object)DRDS_NODE_NAME)) {
                nodeName = (String)parameterMap.get((Object)DRDS_NODE_NAME);
            }
            if (parameterMap.containsKey((Object)DRDS_SHARDING_TABLE_NAME)) {
                tableName = (String)parameterMap.get((Object)DRDS_SHARDING_TABLE_NAME);
            }
        }
        if (StringUtils.isBlank(nodeName) && StringUtils.isBlank(tableName)) {
            return invocation.proceed();
        }
        BoundSql boundSql = queryArgs.length == 4 ? mappedStatement.getBoundSql(parameter) : (BoundSql)queryArgs[5];
        String sql = boundSql.getSql();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u5230\u7684SQL\uff1a{}", (Object)sql);
        }
        if (StringUtils.isBlank((CharSequence)sql)) {
            return invocation.proceed();
        }
        if (StringUtils.isNotBlank((CharSequence)nodeName) && StringUtils.isNotBlank((CharSequence)tableName)) {
            Pattern r = Pattern.compile(PATTERN_SPLIT_TABLE_RULE);
            Matcher m = r.matcher(tableName);
            if (m.find()) {
                String tableNewName = tableName.substring(0, m.start());
                sql = "/!TDDL:node='${drdsNodeName}'*/ " + sql.replaceAll(tableNewName, tableName);
            } else {
                sql = "/!TDDL:node='${drdsNodeName}'*/ " + sql;
            }
            BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, new BoundSqlSqlSource(newBoundSql));
            for (ParameterMapping mapping : boundSql.getParameterMappings()) {
                String prop = mapping.getProperty();
                if (!boundSql.hasAdditionalParameter(prop)) continue;
                newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
            }
            queryArgs[0] = newMs;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(ms.getKeyProperties()[0]);
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

