/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.datadistribute.canal;

import com.dtyunxi.huieryun.datadistribute.DataDistributeClient;
import com.dtyunxi.huieryun.datadistribute.DataDistributeClientFactory;
import com.dtyunxi.huieryun.datadistribute.DataEventHandler;
import com.dtyunxi.huieryun.datadistribute.constant.DataDistributeProviderEnum;
import com.dtyunxi.huieryun.datadistribute.impl.CanalConfig;
import com.dtyunxi.huieryun.datadistribute.impl.CanalDataDistributeClient;
import com.dtyunxi.huieryun.datadistribute.impl.CanalEventHandler;
import com.dtyunxi.huieryun.datadistribute.listener.DataDistributeClientStarter;
import com.dtyunxi.huieryun.starter.datadistribute.canal.CanalDatadistributeRegistryProperties;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CanalDataDistributeClient.class})
@ConditionalOnProperty(name={"huieryun.datadistribute.provider"}, havingValue="canal")
@EnableConfigurationProperties(value={CanalDatadistributeRegistryProperties.class})
public class CanalDatadistributeAutoConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CanalDatadistributeAutoConfiguration.class);
    private final CanalConfig properties;

    public CanalDatadistributeAutoConfiguration(CanalConfig properties) {
        this.properties = properties;
    }

    @Bean(name={"threadPool"})
    public ExecutorService threadPool(CanalConfig properties) {
        int availProcessors = Runtime.getRuntime().availableProcessors();
        availProcessors = properties.getConsumeThreadNums() > availProcessors ? properties.getConsumeThreadNums() : availProcessors;
        return new ThreadPoolExecutor(availProcessors * 2, availProcessors * 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat("CanalEventHandler-pool-%d").build());
    }

    @Bean
    @ConditionalOnMissingBean
    public DataEventHandler canalEventHandler(ExecutorService threadPool) {
        return new CanalEventHandler(threadPool);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataDistributeClient canalDataDistributeClient(CanalEventHandler canalEventHandler, CanalConfig properties) {
        return new CanalDataDistributeClient(properties, canalEventHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataDistributeClientFactory dataDistributeClientFactory() {
        return new DataDistributeClientFactory(DataDistributeProviderEnum.CANAL);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataDistributeClientStarter dataDistributeClientStarter() {
        return new DataDistributeClientStarter();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.properties == null) {
            logger.error("\u81ea\u52a8\u88c5\u914d\u5931\u8d25\uff0ccanal\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
    }
}

