/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.dtyunxi.huieryun.localcache.api.ILocalCacheService;
import com.dtyunxi.huieryun.starter.localcache.CacheMessage;
import com.dtyunxi.huieryun.starter.localcache.LocalCache;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheManager;
import com.dtyunxi.util.FastJsonUtil;
import com.dtyunxi.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEventListener
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CacheEventListener.class);
    private final LocalCacheManager cacheManager;

    public CacheEventListener(LocalCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        if (this.cacheManager.getProperties().getLocalCache() != null) {
            this.subscribeKeyEvictEvent();
            if (this.cacheManager.getProperties().isRemoteCache() && this.cacheManager.getCacheService() != null) {
                this.subscribeKeyExpiredEvent();
            }
        }
    }

    protected void subscribeKeyEvictEvent() {
        IRedisSubProcessor processor = (channel, message) -> {
            CacheMessage cacheMessage;
            if (log.isInfoEnabled()) {
                log.info("process key evict event,channel={},message={}", (Object)channel, message);
            }
            if ((cacheMessage = (CacheMessage)JacksonUtil.readValue((String)message, CacheMessage.class)) == null) {
                log.warn("message can't cast CacheMessage object!");
                return;
            }
            if (LocalCacheManager.COMMON_SRC.equals(cacheMessage.getPublisher())) {
                return;
            }
            String cacheName = cacheMessage.getCacheName();
            if (StrUtil.isBlank((CharSequence)cacheName)) {
                log.warn("can't found cacheName={} from CacheMessage object!", (Object)cacheName);
                return;
            }
            LocalCache localCache = (LocalCache)this.cacheManager.getCacheMap().get(cacheName);
            if (localCache == null) {
                log.warn("can't found cacheName={} from LocalCache object!", (Object)cacheName);
                return;
            }
            ILocalCacheService localCacheService = localCache.getLocalCacheService();
            if (localCacheService == null) {
                log.warn("can't found cacheName={} from ILocalCacheService object!", (Object)cacheName);
                return;
            }
            switch (cacheMessage.getEvent()) {
                case EVICT: {
                    if (cacheMessage.getGroup() != null) {
                        localCacheService.delCache(cacheMessage.getGroup(), cacheMessage.getKey());
                        return;
                    }
                    localCacheService.delCache(cacheMessage.getKey());
                    return;
                }
                case CLEAR: {
                    localCacheService.cleanUp();
                    return;
                }
                case PUT: {
                    Object value;
                    try {
                        String parameterTypes = cacheMessage.getParameterTypes();
                        if (StrUtil.isBlank((CharSequence)parameterTypes)) {
                            log.warn("can't found object classType from CacheMessage object!");
                            value = cacheMessage.getValue();
                        } else {
                            value = FastJsonUtil.parseObject((String)cacheMessage.getValue(), Class.forName(parameterTypes));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        value = cacheMessage.getValue();
                        log.warn("redis\u7f13\u5b58\u540c\u6b65\u672c\u5730\u6570\u636e\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
                    }
                    if (StrUtil.isBlank((CharSequence)cacheMessage.getGroup())) {
                        localCacheService.setCache(cacheMessage.getGroup(), cacheMessage.getKey(), value);
                        return;
                    }
                    localCacheService.setCache(cacheMessage.getKey(), value);
                    return;
                }
            }
        };
        if (this.cacheManager.getProperties().getCacheSyncGroups() != null) {
            for (String group : this.cacheManager.getProperties().getCacheSyncGroups()) {
                this.cacheManager.getCacheService().subscribe(group, this.cacheManager.getProperties().getCacheSyncTopic(), processor);
            }
        }
        this.cacheManager.getCacheService().subscribe(this.cacheManager.getProperties().getCacheSyncTopic(), processor);
    }

    protected void subscribeKeyExpiredEvent() {
        IRedisSubProcessor processor = (channel, message) -> {
            String[] messages;
            if (log.isDebugEnabled()) {
                log.debug("process key expired event,channel={},message={}", (Object)channel, message);
            }
            if ((messages = message.split(":")) != null && messages.length >= 3) {
                ILocalCacheService localCacheService = ((LocalCache)this.cacheManager.getCacheMap().get(messages[1])).getLocalCacheService();
                if (messages.length > 3) {
                    localCacheService.delCache(messages[2], messages[3]);
                } else {
                    localCacheService.delCache(messages[2]);
                }
            }
        };
        this.cacheManager.getCacheService().subscribeKeyExpiredEvent(processor);
    }
}

