/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import com.dtyunxi.huieryun.starter.localcache.LocalCache;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;

public class CacheReturnTypeSourceAdvisor
extends AbstractBeanFactoryPointcutAdvisor {
    private static final long serialVersionUID = -5001494934841634227L;

    public CacheReturnTypeSourceAdvisor(CacheManager cacheManager) {
        this.setAdvice((Advice)new CacheReturnTypeInterceptor(cacheManager));
        this.setOrder(0);
    }

    public Pointcut getPointcut() {
        return new CacheReturnTypeSourcePointcut();
    }

    private static class CacheReturnTypeInterceptor
    implements MethodInterceptor {
        private static final Logger log = LoggerFactory.getLogger(CacheReturnTypeInterceptor.class);
        private final CacheManager cacheManager;

        public CacheReturnTypeInterceptor(CacheManager cacheManager) {
            this.cacheManager = cacheManager;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Cacheable cacheable = method.getDeclaredAnnotation(Cacheable.class);
            if (cacheable != null) {
                LocalCache cache;
                if (log.isInfoEnabled()) {
                    log.info("invoke Cacheable Annotation method,key={},return Type = {}", (Object)cacheable.key(), method.getReturnType());
                }
                for (String cacheName : cacheable.value()) {
                    cache = (LocalCache)this.cacheManager.getCache(cacheName);
                    if (cache == null) continue;
                    LocalCacheContext.getContext().setReturnType(method.getGenericReturnType());
                    if (!log.isInfoEnabled()) continue;
                    log.info("set returnType into serviceContext,name={},key={},return Type = {}", new Object[]{cacheName, cacheable.key(), method.getReturnType()});
                }
                for (String cacheName : cacheable.cacheNames()) {
                    cache = (LocalCache)this.cacheManager.getCache(cacheName);
                    if (cache == null) continue;
                    LocalCacheContext.getContext().setReturnType(method.getGenericReturnType());
                    if (!log.isInfoEnabled()) continue;
                    log.info("set returnType into serviceContext,name={},key={},return Type = {}", new Object[]{cacheName, cacheable.key(), method.getReturnType()});
                }
            }
            return invocation.proceed();
        }
    }

    private static class CacheReturnTypeSourcePointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        private static final long serialVersionUID = -5869891205896736218L;

        private CacheReturnTypeSourcePointcut() {
        }

        public boolean matches(Method method, Class<?> targetClass) {
            Cacheable batchCache = method.getAnnotation(Cacheable.class);
            return batchCache != null;
        }
    }
}

