/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.localcache;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.starter.localcache.CacheEventListener;
import com.dtyunxi.huieryun.starter.localcache.LocalCache;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheRegistryProperties;
import com.dtyunxi.util.IdGenrator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.CollectionUtils;

public class LocalCacheManager
implements CacheManager {
    private final LocalCacheRegistryProperties properties;
    public static final String COMMON_SRC = IdGenrator.getWorkerId().toString();
    private final ICacheService cacheService;
    private final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();

    public LocalCacheManager(LocalCacheRegistryProperties properties, ICacheService cacheService) {
        this.properties = properties;
        this.cacheService = cacheService;
        Thread cacheEventThread = new Thread(new CacheEventListener(this));
        cacheEventThread.setDaemon(true);
        cacheEventThread.start();
    }

    public Cache getCache(String name) {
        if (this.cacheMap.containsKey(name)) {
            return (Cache)this.cacheMap.get(name);
        }
        LocalCache cache = null;
        if (!CollectionUtils.isEmpty(this.properties.getCustomCaches())) {
            Class<LocalCache> cacheClass = this.properties.getCustomCaches().getOrDefault(name, LocalCache.class);
            try {
                Constructor constructor = cacheClass.getConstructor(String.class, LocalCacheRegistryProperties.class, ICacheService.class);
                cache = (Cache)constructor.newInstance(name, this.properties, this.cacheService);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u81ea\u5b9a\u4e49LocalCache!", e);
            }
        } else {
            cache = new LocalCache(name, this.properties, this.cacheService);
        }
        this.cacheMap.put(name, cache);
        return cache;
    }

    public Collection<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    public LocalCacheRegistryProperties getProperties() {
        return this.properties;
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }

    public ConcurrentMap<String, Cache> getCacheMap() {
        return this.cacheMap;
    }
}

