/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.starter.searchindexbuilder;

import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.opensearch.api.BuilderCustomizer;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.searchindexbuilder.api.IDataCollectClient;
import com.dtyunxi.huieryun.searchindexbuilder.api.IIndicesManagerService;
import com.dtyunxi.huieryun.searchindexbuilder.config.ItemIndexCondition;
import com.dtyunxi.huieryun.searchindexbuilder.controller.IndicesManagerController;
import com.dtyunxi.huieryun.searchindexbuilder.dto.TableToIndexMappingDto;
import com.dtyunxi.huieryun.searchindexbuilder.impl.AbstractDbChangeEventMessageProcessor;
import com.dtyunxi.huieryun.searchindexbuilder.impl.BooleanRedisTemplate;
import com.dtyunxi.huieryun.searchindexbuilder.impl.DataCollectClientFactory;
import com.dtyunxi.huieryun.searchindexbuilder.impl.DataCollectMessageProcessorImpl;
import com.dtyunxi.huieryun.searchindexbuilder.impl.IndicesManagerServiceImpl;
import com.dtyunxi.huieryun.searchindexbuilder.impl.MqDataCollectClient;
import com.dtyunxi.huieryun.searchindexbuilder.impl.RedisLockClient;
import com.dtyunxi.huieryun.starter.searchindexbuilder.CacheRegistryProperties;
import com.dtyunxi.huieryun.starter.searchindexbuilder.DataCollectClientStarter;
import com.dtyunxi.huieryun.starter.searchindexbuilder.OpenSearchRegistryProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={IndicesManagerServiceImpl.class, DataCollectClientStarter.class, AbstractDbChangeEventMessageProcessor.class, LettuceConnectionFactory.class})
@ConditionalOnBean(value={IOpenSearchService.class, ISearchIndexService.class, IIndicesAdminService.class})
@EnableConfigurationProperties(value={OpenSearchRegistryProperties.class, CacheRegistryProperties.class})
public class SearchIndexBuilderAutoConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SearchIndexBuilderAutoConfiguration.class);
    private final OpenSearchRegistryProperties openSearchVo;
    private final CacheRegistryProperties cacheRegistryVo;
    private final ApplicationContext context;
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix:}")
    private String indexPrefixproperties;
    @Value(value="${huieryun.searchindexbuilder.redis.dbIndx:0}")
    private Integer dbIndex;
    private TableToIndexMappingDto[] mappings;

    public SearchIndexBuilderAutoConfiguration(OpenSearchRegistryProperties openSearchVo, ObjectProvider<List<BuilderCustomizer>> builderCustomizerProviders, CacheRegistryProperties cacheRegistryVo, ApplicationContext context) {
        List builderCustomizers = (List)builderCustomizerProviders.getIfAvailable();
        if (!CollectionUtils.isEmpty((Collection)builderCustomizers)) {
            openSearchVo.setCustomizers(builderCustomizers);
        }
        this.openSearchVo = openSearchVo;
        this.cacheRegistryVo = cacheRegistryVo;
        this.context = context;
    }

    @Bean
    @ConditionalOnMissingBean
    public String indicesPrefix() {
        if (StringUtils.isEmpty((Object)this.indexPrefixproperties)) {
            return this.openSearchVo.getIndexPrefix();
        }
        return this.indexPrefixproperties;
    }

    @Bean
    @Conditional(value={ItemIndexCondition.class})
    @ConditionalOnMissingBean
    public LettuceConnectionFactory connectionFactory() {
        if (this.dbIndex == null) {
            this.dbIndex = 0;
        }
        LettuceConnectionFactory connectionFactory = null;
        switch (this.cacheRegistryVo.getWorkModel().toLowerCase()) {
            case "cluster": {
                if (this.cacheRegistryVo.getAddresses() == null) break;
                RedisClusterConfiguration cluster = new RedisClusterConfiguration(Arrays.asList(this.cacheRegistryVo.getAddresses()));
                cluster.setPassword(RedisPassword.of((String)this.cacheRegistryVo.getAppSecret()));
                connectionFactory = new LettuceConnectionFactory(cluster);
                break;
            }
            default: {
                RedisStandaloneConfiguration clientConfig = new RedisStandaloneConfiguration(this.cacheRegistryVo.getHost(), Integer.valueOf(this.cacheRegistryVo.getPort()).intValue());
                if (this.dbIndex > 0) {
                    clientConfig.setDatabase(this.dbIndex.intValue());
                }
                clientConfig.setPassword(RedisPassword.of((String)this.cacheRegistryVo.getAppSecret()));
                connectionFactory = new LettuceConnectionFactory(clientConfig);
            }
        }
        return connectionFactory;
    }

    @Bean
    @Conditional(value={ItemIndexCondition.class})
    @ConditionalOnMissingBean
    public BooleanRedisTemplate booleanRedisTemplate(@Qualifier(value="connectionFactory") RedisConnectionFactory connectionFactory) {
        BooleanRedisTemplate redisTemplate = new BooleanRedisTemplate(connectionFactory);
        return redisTemplate;
    }

    @Bean
    @Conditional(value={ItemIndexCondition.class})
    @ConditionalOnMissingBean
    public RedisLockClient redisLockClient(@Qualifier(value="booleanRedisTemplate") BooleanRedisTemplate booleanRedisTemplate) {
        return new RedisLockClient(booleanRedisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public IMessageProcessor<DataDistributeEvent> dataCollectMessageProcessor() {
        return new DataCollectMessageProcessorImpl();
    }

    private TableToIndexMappingDto[] getMappings() {
        if (this.mappings == null) {
            Map mappingsMap = this.context.getBeansOfType(TableToIndexMappingDto.class);
            this.mappings = new TableToIndexMappingDto[mappingsMap.size()];
            ArrayList list = new ArrayList(mappingsMap.values());
            Collections.sort(list);
            this.mappings = list.toArray(this.mappings);
        }
        return this.mappings;
    }

    @Bean
    @Conditional(value={ItemIndexCondition.class})
    @ConditionalOnMissingBean
    public IIndicesManagerService indicesManagerService() {
        return new IndicesManagerServiceImpl(this.getMappings());
    }

    @Bean
    @Conditional(value={ItemIndexCondition.class})
    @ConditionalOnMissingBean
    public AbstractDbChangeEventMessageProcessor dbChangeEventMessageProcessor() {
        return new AbstractDbChangeEventMessageProcessor(this.context, this.getMappings()){};
    }

    @Bean
    @ConditionalOnProperty(name={"huieryun.searchindexbuilder.synchro.mode"}, havingValue="mq")
    @ConditionalOnMissingBean
    public IDataCollectClient mqDataCollectClient() {
        return new MqDataCollectClient();
    }

    @Bean
    @ConditionalOnProperty(name={"huieryun.searchindexbuilder.synchro.mode"}, havingValue="mq")
    @ConditionalOnMissingBean
    public DataCollectClientFactory dataCollectClientFactory() {
        return new DataCollectClientFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"huieryun.searchindexbuilder.synchro.mode"}, havingValue="mq")
    @ConditionalOnMissingBean
    public DataCollectClientStarter dataCollectClientStarter() {
        return new DataCollectClientStarter();
    }

    @Bean
    @ConditionalOnMissingBean
    public IndicesManagerController indicesManagerController() {
        return new IndicesManagerController();
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.openSearchVo) {
            logger.error("openSearchVo \u5c1a\u672a\u914d\u7f6e");
        }
        if (null == this.cacheRegistryVo) {
            logger.error("cacheRegistryVo \u5c1a\u672a\u914d\u7f6e");
        }
        if (null != this.openSearchVo && null != this.cacheRegistryVo) {
            logger.info("SearchIndexBuilderAutoConfiguration \u5df2\u88c5\u8f7d");
        }
    }
}

