/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins;

import com.dtyunxi.huieryun.maven.plugins.CubeAbstractMojo;
import com.dtyunxi.huieryun.maven.plugins.filter.ApiClassMigrationArtifactFilter;
import com.dtyunxi.huieryun.maven.plugins.util.FileUtils;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="api-class-migration", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ApiClassMigrationMojo
extends CubeAbstractMojo {
    private Template template;
    @Parameter(property="temp.dir")
    private String templateDir;
    @Parameter(property="group.pattern")
    private String groupPattern;
    @Parameter(property="group.prefix")
    private List<String> groupPrefixs;
    @Parameter(property="artifact.pattern")
    private String artifactPattern;
    private List<String> dependencyFilePath = new ArrayList<String>();
    @Parameter(defaultValue="${project}")
    public MavenProject project;

    @Override
    protected void executeInner() throws IOException {
        this.unzipJarClassToOutputDirectory();
    }

    private void unzipJarClassToOutputDirectory() {
        this.project.setArtifacts(null);
        this.project.setArtifactFilter((ArtifactFilter)new ApiClassMigrationArtifactFilter(this.groupPattern, this.artifactPattern, this.groupPrefixs));
        Set artifacts = this.project.getArtifacts();
        String outputDirectory = this.getOutputDirectory();
        for (Artifact dependencyArtifact : artifacts) {
            if (dependencyArtifact == null || dependencyArtifact.getFile() == null) continue;
            FileUtils.unzip(new File(dependencyArtifact.getFile().getAbsolutePath()), outputDirectory, zipEntry -> !zipEntry.getName().startsWith("META-INF"), zipEntry -> zipEntry.getName().endsWith(".class"));
        }
    }
}

