/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class CubeAbstractMojo
extends AbstractMojo {
    public static final String YX_GENERATE_PATH = "yx_gen";
    protected String generationJavaResult = String.format("%sMETA-INF%sgeneration%sresult.json", File.separator, File.separator, File.separator);
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.basedir}")
    private File basedir;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDir;
    @Parameter(defaultValue="${project.resources}")
    private List<Resource> resources;
    @Parameter(defaultValue="${project.testResources}")
    private List<Resource> testResources;
    @Parameter(defaultValue="${classPath}")
    private String classPath;
    @Deprecated
    @Parameter(property="prjClassName", defaultValue="org.springframework.core.env.Profiles")
    private String prjClassName;
    @Parameter(property="extension.main.module")
    protected Boolean mainModule = null;

    public void execute() throws MojoExecutionException {
        try {
            this.executeInner();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected abstract void executeInner() throws MojoExecutionException, IOException, DependencyResolutionRequiredException, ClassNotFoundException, TemplateException;

    protected boolean isExecutableTarget() {
        return this.isWar() || this.isFatjar();
    }

    protected boolean isFatjar() {
        return this.getMavenProject().getPluginArtifacts().stream().filter(pat -> pat.getGroupId().equalsIgnoreCase("org.springframework.boot") && pat.getArtifactId().equalsIgnoreCase("spring-boot-maven-plugin")).count() == 1L;
    }

    protected boolean isWar() {
        return this.getMavenProject().getPackaging().equalsIgnoreCase("war");
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public CubeAbstractMojo setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        return this;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public CubeAbstractMojo setBasedir(File basedir) {
        this.basedir = basedir;
        return this;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public CubeAbstractMojo setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
        return this;
    }

    public File getTestSourceDir() {
        return this.testSourceDir;
    }

    public CubeAbstractMojo setTestSourceDir(File testSourceDir) {
        this.testSourceDir = testSourceDir;
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public CubeAbstractMojo setResources(List<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public List<Resource> getTestResources() {
        return this.testResources;
    }

    public CubeAbstractMojo setTestResources(List<Resource> testResources) {
        this.testResources = testResources;
        return this;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public CubeAbstractMojo setClassPath(String classPath) {
        this.classPath = classPath;
        return this;
    }

    public String getPrjClassName() {
        return this.prjClassName;
    }

    public CubeAbstractMojo setPrjClassName(String prjClassName) {
        this.prjClassName = prjClassName;
        return this;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public CubeAbstractMojo setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }
}

