/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.icommerce.biz.service.item.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.biz.service.item.ISellerSkuPriceService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.bitem.biz.price.PriceRuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.dto.request.ItemPricePageReqDto;
import com.yx.tcbj.center.api.dto.response.ItemPricePageRespDto;
import com.yx.tcbj.center.api.dto.response.SpecsPriceRespDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SellerSkuPriceServiceImpl
implements ISellerSkuPriceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private ICustomerQueryApi iCenterCustomerQueryApi;
    @Resource
    private ISellerQueryApi iSellerQueryApi;
    @Resource
    private IItemCenterQueryApi iItemCenterQueryApi;
    @Resource
    private IShopQueryApi iShopQueryApi;
    @Resource
    private IContext context;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;
    @Autowired
    private IBItemPriceService bItemPriceService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Autowired
    private PriceRuleHelper priceRuleHelper;

    @Override
    public PageInfo<ItemPricePageRespDto> queryPriceByPage(ItemPricePageReqDto filter) {
        if (!StringUtils.isEmpty((CharSequence)filter.getCustomerCode())) {
            CustomerRespDto customerRespDto = (CustomerRespDto)this.iCenterCustomerQueryApi.queryCustomerByCode(filter.getCustomerCode()).getData();
            if (Objects.nonNull(customerRespDto)) {
                ArrayList<Long> customerIds = new ArrayList<Long>();
                customerIds.add(customerRespDto.getId());
                filter.setCustomerIds(customerIds);
                this.logger.info("CustomerCode-customerIds=====>:{}", customerIds);
            }
        } else if (!StringUtils.isEmpty((CharSequence)filter.getCustomerName())) {
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setName(filter.getCustomerName());
            String customerSearchJSON = JSONObject.toJSONString((Object)customerSearchReqDto);
            List customerRespDtos = (List)this.iCustomerQueryApi.queryByList(customerSearchJSON).getData();
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                List customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                filter.setCustomerIds(customerIds);
                this.logger.info("CustomerName-customerIds=====>:{}", customerIds);
            }
        }
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        if (restResponse == null || !"0".equals(restResponse.getResultCode())) {
            throw new BizException("\u672a\u627e\u5230\u767b\u5f55\u7528\u6237\u7ec4\u7ec7ID");
        }
        Long orgId = (Long)restResponse.getData();
        RestResponse customerResp = this.customerExtQueryApi.queryOneByOrgId(orgId);
        if (customerResp == null || !"0".equals(customerResp.getResultCode())) {
            throw new BizException("\u672a\u627e\u5230\u767b\u5f55\u7528\u6237\u7ec4\u7ec7");
        }
        filter.setSellerId(((CustomerRespDto)customerResp.getData()).getId());
        this.logger.info("filter=====>:{}", (Object)JSONObject.toJSONString((Object)filter));
        PageInfo dtoPageInfo = (PageInfo)this.iItemCenterQueryApi.queryPriceByPage(filter).getData();
        this.logger.info("dtoPageInfo=====>:{}", (Object)JSONObject.toJSONString((Object)dtoPageInfo));
        List itemList = dtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            HashSet idSet;
            List shopDtos;
            List shopIds;
            ArrayList shopConditionList = Lists.newArrayList();
            ArrayList skuPriceReqDtos = Lists.newArrayList();
            HashSet customerIdSet = Sets.newHashSet();
            for (ItemPricePageRespDto itemPricePageRespDto : itemList) {
                customerIdSet.add(itemPricePageRespDto.getCustomerId());
                if (itemPricePageRespDto.getShopId() == null || !CollectionUtils.isNotEmpty((Collection)itemPricePageRespDto.getSpecsPriceRespDtos())) continue;
                for (SpecsPriceRespDto specsPriceRespDto : itemPricePageRespDto.getSpecsPriceRespDtos()) {
                    ItemSkuPriceConditionQueryReqDto priceQueryDto = new ItemSkuPriceConditionQueryReqDto();
                    priceQueryDto.setShopId(itemPricePageRespDto.getShopId());
                    priceQueryDto.setSkuId(specsPriceRespDto.getSkuId());
                    shopConditionList.add(priceQueryDto);
                    CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                    skuPriceReqDto.setSkuId(specsPriceRespDto.getSkuId());
                    skuPriceReqDto.setItemId(itemPricePageRespDto.getId());
                    skuPriceReqDto.setShopId(itemPricePageRespDto.getShopId());
                    skuPriceReqDtos.add(skuPriceReqDto);
                }
            }
            Map<Object, Object> costRetailPriceMap = Maps.newHashMap();
            if (this.priceRuleHelper.isUseCenterPrice(((ItemPricePageRespDto)itemList.get(0)).getShopId())) {
                ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
                itemSkuPriceQueryReqDto.setShopConditionList((List)shopConditionList);
                itemSkuPriceQueryReqDto.setPriceTypeIdStr(PriceTypeEnum.RETAIL_PRICE.getTypeId() + "," + PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId());
                List skuPriceQueryRespList = (List)RestResponseHelper.extractData((RestResponse)this.basePriceItemQueryApi.queryRetailSkuPrice(itemSkuPriceQueryReqDto));
                costRetailPriceMap = skuPriceQueryRespList.stream().filter(dto -> Objects.nonNull(dto.getCostRetailPrice())).collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + PriceTypeEnum.RETAIL_PRICE.getTypeId(), ItemSkuPriceQueryRespDto::getCostRetailPrice, (o1, o2) -> o1));
            }
            CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
            communalPriceQueryReqDto.setSkuList((List)skuPriceReqDtos);
            communalPriceQueryReqDto.setCustomerIds(new ArrayList(customerIdSet));
            List itemPolicyPriceRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.bItemPriceService.getItemPrice(communalPriceQueryReqDto));
            this.logger.info("\u653f\u7b56\u4ef7\u6216\u8005\u81ea\u5b9a\u4e49\u96f6\u552e\u4ef7\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)itemPolicyPriceRespDtos));
            Map policyPriceMap = itemPolicyPriceRespDtos.stream().collect(Collectors.toMap(skuInfo -> {
                String key = skuInfo.getShopId() + "-" + skuInfo.getSkuId() + "-" + skuInfo.getCustId();
                return key;
            }, Function.identity(), (o1, o2) -> o2));
            List customerIds = itemList.stream().map(ItemPricePageRespDto::getCustomerId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(customerIds)) {
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                customerSearchReqDto.setIdList(customerIds);
                List customerRespDtos = (List)this.iCustomerQueryApi.queryByList(JSONObject.toJSONString((Object)customerSearchReqDto)).getData();
                if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                    Map<Long, CustomerRespDto> customerItemMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, p -> p));
                    Map<Object, Object> finalCostRetailPriceMap = costRetailPriceMap;
                    dtoPageInfo.getList().forEach(d -> {
                        CustomerRespDto customerRespDto = (CustomerRespDto)customerItemMap.get(d.getCustomerId());
                        if (Objects.nonNull(customerRespDto)) {
                            d.setCustomerName(customerRespDto.getName());
                            d.setCustomerCode(customerRespDto.getCode());
                        }
                        Long shopId = d.getShopId();
                        if (CollectionUtils.isNotEmpty((Collection)d.getSpecsPriceRespDtos())) {
                            for (SpecsPriceRespDto specsPriceRespDto : d.getSpecsPriceRespDtos()) {
                                String retailPriceKey = shopId + "_" + specsPriceRespDto.getSkuId() + "_" + PriceTypeEnum.RETAIL_PRICE.getTypeId();
                                String policyPricKey = shopId + "-" + specsPriceRespDto.getSkuId() + "-" + d.getCustomerId();
                                BigDecimal supplyPrice = this.itemPriceHelper.getDefaultMatchPrice((ItemPolicyPriceRespDto)policyPriceMap.get(policyPricKey), null);
                                specsPriceRespDto.setSupplyPrice(supplyPrice);
                                BigDecimal retailPrice = (BigDecimal)finalCostRetailPriceMap.get(retailPriceKey);
                                if (retailPrice != null) {
                                    specsPriceRespDto.setRetailPrice(retailPrice);
                                }
                                d.setPrice(retailPrice != null ? retailPrice.toString() : null);
                                d.setSupplyPrice(supplyPrice != null ? supplyPrice.toString() : null);
                            }
                        }
                    });
                }
            }
            if (CollectionUtils.isNotEmpty(shopIds = itemList.stream().map(ItemPricePageRespDto::getShopId).collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(shopDtos = (List)this.iShopQueryApi.queryByIds(idSet = new HashSet(shopIds)).getData()))) {
                Map<Long, ShopDto> shopMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getId, p -> p));
                dtoPageInfo.getList().forEach(d -> {
                    ShopDto shopDto = (ShopDto)shopMap.get(d.getShopId());
                    if (Objects.nonNull(shopDto)) {
                        d.setShopName(shopDto.getName());
                    }
                });
            }
        }
        return dtoPageInfo;
    }
}

