/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.icommerce.biz.service.item.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.biz.service.item.IItemBatchOnShelfService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemBatchOnShelfServiceImpl
implements IItemBatchOnShelfService {
    private static Logger logger = LoggerFactory.getLogger(ItemBatchOnShelfServiceImpl.class);
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;

    @Override
    public RestResponse<List<Map<String, Object>>> batchOnShelfItem(String longCode, Long shopId) {
        return new RestResponse(this.jointData(longCode, "on-shelf", shopId));
    }

    @Override
    public RestResponse<List<Map<String, Object>>> offShelf(String longCode, Long shopId) {
        return new RestResponse(this.jointData(longCode, "offSale", shopId));
    }

    private List<Map<String, Object>> jointData(String longCode, String type, Long shopId) {
        logger.info("\u5546\u54c1\u957f\u7f16\u7801\u5165\u53c2\uff1a{}", (Object)longCode);
        List<String> list = Arrays.asList(longCode.split(","));
        logger.info("==========================\u300b \u51c6\u5907\u5f00\u59cb{}", (Object)(type.equals("on-shelf") ? "\u4e0a\u67b6" : "\u4e0b\u67b6"));
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        list.stream().forEach(t -> {
            List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{t})).getData();
            logger.info("\u67e5\u8be2sku\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
            if (CollectionUtils.isNotEmpty((Collection)skuRespDtos)) {
                ItemAuthReqDto queryCondition = new ItemAuthReqDto();
                queryCondition.setBusinessId(((ItemSkuRespDto)skuRespDtos.get(0)).getId());
                queryCondition.setTargetType(Integer.valueOf(2));
                List itemAuthRespDtoList = (List)this.itemAuthQueryApi.queryByTargetIds(queryCondition).getData();
                if (CollectionUtils.isNotEmpty((Collection)itemAuthRespDtoList)) {
                    if (shopId != null) {
                        itemAuthRespDtoList.stream().filter(i -> Objects.equals(i.getTargetId(), shopId)).map(ItemAuthRespDto::getTargetId).distinct().forEach(o -> {
                            HashMap<String, Number> map = new HashMap<String, Number>();
                            map.put("itemId", ((ItemSkuRespDto)skuRespDtos.get(0)).getItemId());
                            map.put("shopId", (Number)o);
                            map.put("skuId", ((ItemSkuRespDto)skuRespDtos.get(0)).getId());
                            if (type.equals("on-shelf")) {
                                map.put("busType", 0);
                                map.put("itemType", 1);
                            }
                            lists.add(map);
                        });
                    } else {
                        itemAuthRespDtoList.stream().map(ItemAuthRespDto::getTargetId).distinct().forEach(o -> {
                            HashMap<String, Number> map = new HashMap<String, Number>();
                            map.put("itemId", ((ItemSkuRespDto)skuRespDtos.get(0)).getItemId());
                            map.put("shopId", (Number)o);
                            map.put("skuId", ((ItemSkuRespDto)skuRespDtos.get(0)).getId());
                            if (type.equals("on-shelf")) {
                                map.put("busType", 0);
                                map.put("itemType", 1);
                            }
                            lists.add(map);
                        });
                    }
                }
            }
        });
        logger.info("\u5165\u53c2\u6570\u91cf\uff1a{}", (Object)list.size());
        return lists;
    }
}

