/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.icommerce.biz.service.item.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.biz.dto.request.ReCheckRefundReqDto;
import com.dtyunxi.icommerce.biz.enums.IsAllowReturnEnum;
import com.dtyunxi.icommerce.biz.service.item.IReCheckRefundService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IErpOrderApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.FinanceAuditReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ReviewSaleReturnInHeadReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.SaleReturnItem;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.UnauditReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerRelationQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.recipt.ITcbjReciptApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusToBEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.FinReviewToBReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.RefundDetailTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.RefundTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.IOptLogApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ReCheckRefundServiceImpl
implements IReCheckRefundService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReCheckRefundServiceImpl.class);
    private static final String SUB_TENANT_SRC = "1";
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private ITcbjReciptApi tcbjReciptApi;
    @Resource
    private IErpOrderApi iErpOrderApi;
    @Resource
    private IAfterSalesTobApi afterSalesTobApi;
    @Resource
    private IContext iContext;
    @Resource
    private IOptLogApi optLogApi;
    @Resource
    private ICsReceiveResultOrderApi receiveResultOrderApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private ICsReceiveNoticeOrderApi receiveNoticeOrderApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IErpOrderApi erpOrderApi;
    @Autowired
    private ICustomerRelationQueryApi customerRelationQueryApi;

    @Override
    public RestResponse<Void> reCheckRefundItemRest(ReCheckRefundReqDto reCheckRefundReqDto) {
        ServiceContext serviceContext = ServiceContext.getContext();
        String object = serviceContext.getAttachment("yes.req.cus.b2b.organizationid");
        LOGGER.info("request cloud market tenantInfo , param is {} ", (Object)object);
        if (object == null) {
            throw new BizException("\u7ec4\u7ec7id\u4e3a\u7a7a");
        }
        RestResponse orgAdvDetailRespDtoRestResponse = this.organizationQueryExtApi.queryById(Long.valueOf(String.valueOf(object)));
        LOGGER.info("response cloud market tenantInfo , param is {} ", (Object)JSON.toJSONString((Object)orgAdvDetailRespDtoRestResponse));
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)orgAdvDetailRespDtoRestResponse.getData();
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(reCheckRefundReqDto.getReCheckRefundReturnNo(), "");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)returnDetailRespDtoRestResponse.getData();
        LOGGER.info("\u67e5\u8be2\u9000\u8d27\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)returnDetailRespDto));
        switch (reCheckRefundReqDto.getReCheckRefundStatus()) {
            case 1: {
                List returnOmniItemRespDtoList = returnDetailRespDto.getReturnOmniItemRespDtoList();
                if (ObjectUtils.isEmpty((Object)returnOmniItemRespDtoList)) {
                    return new RestResponse("0001", "\u5f53\u524d\u8ba2\u5355\u6682\u65e0\u8ba2\u5355\u660e\u7ec6");
                }
                ArrayList reCheckDetailReqDtoList = Lists.newArrayList();
                List filterAllowReturnOmniItemRespDto = returnOmniItemRespDtoList.stream().filter(c -> c.getIsAllowReturn() != null && c.getIsAllowReturn().equals(IsAllowReturnEnum.ISALLOWRETURNENUM_SUCCESS.getValue())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(filterAllowReturnOmniItemRespDto)) {
                    return new RestResponse("0001", "\u5f53\u524d\u8ba2\u5355\u6682\u65e0\u5141\u8bb8\u9000\u8ba2\u5355\u660e\u7ec6");
                }
                ArrayList<SaleReturnItem> saleReturnItemList = new ArrayList<SaleReturnItem>();
                for (ReturnOmniItemRespDto c2 : filterAllowReturnOmniItemRespDto) {
                    if (StringUtils.isEmpty((CharSequence)c2.getBatchNo())) continue;
                    if (c2.getBatchNo().contains(",")) {
                        String[] splitBatchNo;
                        for (String batchNo : splitBatchNo = c2.getBatchNo().split(",")) {
                            this.constructPram(reCheckDetailReqDtoList, saleReturnItemList, c2, batchNo);
                        }
                        continue;
                    }
                    this.constructPram(reCheckDetailReqDtoList, saleReturnItemList, c2, c2.getBatchNo());
                }
                ReturnOmniItemRespDto returnOmniItemRespDto = (ReturnOmniItemRespDto)returnOmniItemRespDtoList.stream().findFirst().get();
                ReviewSaleReturnInHeadReqDto reviewSaleReturnInHeadReqDto = new ReviewSaleReturnInHeadReqDto();
                reviewSaleReturnInHeadReqDto.setNumber(returnOmniItemRespDto.getReturnNo());
                reviewSaleReturnInHeadReqDto.setOtherNumber(returnOmniItemRespDto.getReturnNo());
                reviewSaleReturnInHeadReqDto.setTenantId(orgAdvDetailRespDto.getCode());
                reviewSaleReturnInHeadReqDto.setItemList(saleReturnItemList);
                if (StringUtils.isNotBlank((CharSequence)returnDetailRespDto.getExtlReturnSerial())) {
                    reviewSaleReturnInHeadReqDto.setBillSrc(SUB_TENANT_SRC);
                    reviewSaleReturnInHeadReqDto.setSrcBillNo(returnOmniItemRespDto.getReturnNo());
                }
                LOGGER.info("request cloud market reviewSaleReturnInHead , param is {} ", (Object)JSON.toJSONString((Object)reviewSaleReturnInHeadReqDto));
                Map resultMap = this.iErpOrderApi.reviewSaleReturnInHead(reviewSaleReturnInHeadReqDto);
                LOGGER.info("response cloud market reviewSaleReturnInHead , result is {} ", (Object)JSON.toJSONString((Object)resultMap));
                if (!resultMap.getOrDefault("errorMessage", "").toString().equals("success")) {
                    return new RestResponse(resultMap.getOrDefault("errorCode", "").toString(), resultMap.getOrDefault("errorMessage", "").toString());
                }
                this.dealWithSuccessOperate(reCheckRefundReqDto, returnDetailRespDto, reCheckRefundReqDto.getRealRefundAmont(), reCheckDetailReqDtoList);
                break;
            }
            case 0: {
                this.checkFailOperator(reCheckRefundReqDto, orgAdvDetailRespDto, returnDetailRespDto);
                break;
            }
        }
        return new RestResponse();
    }

    private void dealWithSuccessOperate(ReCheckRefundReqDto reCheckRefundReqDto, ReturnDetailRespDto returnDetailRespDto, BigDecimal refundAmout, List<TcbjReCheckDetailReqDto> reCheckDetailReqDtoList) {
        TcbjReCheckReqDto tcbjReCheckReqDto = new TcbjReCheckReqDto();
        tcbjReCheckReqDto.setRefundOrderNo(returnDetailRespDto.getReturnNo());
        tcbjReCheckReqDto.setWarehouseCode(returnDetailRespDto.getWarehouseCode());
        tcbjReCheckReqDto.setReCheckDetailReqDtoList(reCheckDetailReqDtoList);
        LOGGER.info("request center inventory2 refundModifyNotifyStatus , param is {} ", (Object)JSON.toJSONString((Object)tcbjReCheckReqDto));
        RestResponse voidRestResponse = this.receiveResultOrderApi.reCheckInInventory(tcbjReCheckReqDto);
        LOGGER.info("response center inventory2 refundModifyNotifyStatus , result is {} ", (Object)JSON.toJSONString((Object)voidRestResponse));
        FinReviewToBReqDto finReviewToBReqDto = new FinReviewToBReqDto();
        finReviewToBReqDto.setRefundTotalAmount(refundAmout);
        finReviewToBReqDto.setPayMethod("REBATE_ACCOUNT");
        RefundTobReqDto refundTobReqDto = new RefundTobReqDto();
        refundTobReqDto.setRefundPerson(this.iContext.userName());
        refundTobReqDto.setReturnNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
        refundTobReqDto.setRefundTotalAmount(refundAmout);
        finReviewToBReqDto.setAuditResult(Integer.valueOf(1));
        finReviewToBReqDto.setReturnNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
        finReviewToBReqDto.setAuditor(this.iContext.userName());
        finReviewToBReqDto.setOrderNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
        ArrayList refundDetailList = Lists.newArrayList();
        RefundDetailTobReqDto refundDetailReqDto = new RefundDetailTobReqDto();
        refundDetailReqDto.setRefundAmount(refundAmout);
        refundDetailReqDto.setPayMethod("REBATE_ACCOUNT");
        refundDetailList.add(refundDetailReqDto);
        refundTobReqDto.setRefundDetails((List)refundDetailList);
        finReviewToBReqDto.setRefundTobReqDto(refundTobReqDto);
        RestResponse stringRestResponse = this.afterSalesTobApi.finReviewOrder(reCheckRefundReqDto.getReCheckRefundReturnNo(), finReviewToBReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
    }

    private void checkFailOperator(ReCheckRefundReqDto reCheckRefundReqDto, OrgAdvDetailRespDto orgAdvDetailRespDto, ReturnDetailRespDto returnData) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)reCheckRefundReqDto.getReCheckRefundReason()), (String)"100002", (String)"\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)returnData.getExtlReturnSerial())) {
            FinanceAuditReqDto financeAuditReqDto = new FinanceAuditReqDto();
            financeAuditReqDto.setOrderNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
            financeAuditReqDto.setOrgCode(orgAdvDetailRespDto.getCode());
            financeAuditReqDto.setType(Integer.valueOf(2));
            LOGGER.info("request cloud market financeCancelAudit , param is {} ", (Object)JSON.toJSONString((Object)financeAuditReqDto));
            RestResponseHelper.extractData((RestResponse)this.iErpOrderApi.financeCancelAudit(financeAuditReqDto));
        } else {
            CustomerRespDto subTenantCustomer = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryMiddleCustomerInfo(Long.valueOf(returnData.getCustomerId()), null));
            LOGGER.info("\u4e2db\u79df\u6237\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)subTenantCustomer));
            if (subTenantCustomer != null) {
                UnauditReqDto unauditReqDto = new UnauditReqDto();
                unauditReqDto.setTenantId(this.getOrgCode(returnData.getOrganizationId()));
                unauditReqDto.setNumber(returnData.getExtlReturnSerial());
                RestResponseHelper.extractData((RestResponse)this.erpOrderApi.subrtnOrderUnaudit(unauditReqDto));
                CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
                releasePreemptOperateReqDto.setSourceNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
                releasePreemptOperateReqDto.setSourceType(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
                LOGGER.info("\u4e2db\u552e\u540e\u5355\u590d\u6838\u4e0d\u901a\u8fc7\u91ca\u653e\u9884\u5360\uff0c\u8ba2\u5355\u5e93\u5b58\u56de\u6eda\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)releasePreemptOperateReqDto));
                Boolean releaseFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.csInventoryExposedApi.releaseInventoryByPreemption(releasePreemptOperateReqDto));
                LOGGER.info("\u4e2db\u552e\u540e\u5355\u590d\u6838\u4e0d\u901a\u8fc7\u91ca\u653e\u9884\u5360\uff0c\u8ba2\u5355\u5e93\u5b58\u56de\u6eda\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)releaseFlag));
            }
        }
        ReturnModTobReqDto returnModTobReqDto = new ReturnModTobReqDto();
        returnModTobReqDto.setReturnNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
        returnModTobReqDto.setRefundStatus("CLOSE");
        returnModTobReqDto.setReturnStatus(ReturnStatusToBEnum.CLOSE.getCode());
        returnModTobReqDto.setReqReason(reCheckRefundReqDto.getReCheckRefundReason());
        this.afterSalesTobApi.modifyReturnInfo(returnModTobReqDto);
        this.receiveNoticeOrderApi.updateOrderStatus(reCheckRefundReqDto.getReCheckRefundReturnNo(), CsDocumentActionEnum.REVERSE_AUDIT_REFUSE.getCode());
        this.saveOperateLog(reCheckRefundReqDto, "\u552e\u540e\u7533\u8bf7\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0:" + reCheckRefundReqDto.getReCheckRefundReason());
    }

    private void constructPram(List<TcbjReCheckDetailReqDto> reCheckDetailReqDtoList, List<SaleReturnItem> saleReturnItemList, ReturnOmniItemRespDto returnOmniItemRespDto, String batchNo) {
        Integer returnNum = returnOmniItemRespDto.getReturnNum();
        if (batchNo.contains("#")) {
            String[] split = batchNo.split("#");
            batchNo = split[0];
            returnNum = Integer.valueOf(split[1]);
        }
        SaleReturnItem saleReturnItem = new SaleReturnItem();
        saleReturnItem.setLot(batchNo);
        saleReturnItem.setOperNumber(String.valueOf(returnNum));
        saleReturnItem.setMaterialNo(returnOmniItemRespDto.getSkuCode());
        BigDecimal price = returnOmniItemRespDto.getItemPrice().add(Optional.ofNullable(returnOmniItemRespDto.getAdjustNum()).orElse(BigDecimal.ZERO));
        saleReturnItem.setPrice(String.valueOf(price));
        saleReturnItem.setTaxPrice(String.valueOf(price));
        saleReturnItem.setSrcSalePrice(String.valueOf(returnOmniItemRespDto.getItemPrice()));
        saleReturnItemList.add(saleReturnItem);
        TcbjReCheckDetailReqDto tcbjResGenItemReqDto = new TcbjReCheckDetailReqDto();
        tcbjResGenItemReqDto.setBatch(batchNo);
        tcbjResGenItemReqDto.setCargoCode(returnOmniItemRespDto.getSkuCode());
        tcbjResGenItemReqDto.setRefundNum(new BigDecimal(returnNum));
        reCheckDetailReqDtoList.add(tcbjResGenItemReqDto);
    }

    private void saveOperateLog(ReCheckRefundReqDto reCheckRefundReqDto, String reason) {
        OptLogReqDto optLogDto = new OptLogReqDto();
        optLogDto.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogDto.setBizNo(reCheckRefundReqDto.getReCheckRefundReturnNo());
        optLogDto.setOptTime(new Date());
        optLogDto.setOptPerson(this.iContext.userName());
        optLogDto.setOptType(OptTypeEnum.RETURN_AUDIT.getType());
        optLogDto.setDescription(reason);
        RestResponse response = this.optLogApi.addBoOptLog(optLogDto);
        RestResponseHelper.extractData((RestResponse)response);
    }

    private String getOrgCode(Long orgId) {
        RestResponse organizationDtoRestResponse = this.organizationQueryApi.queryById(orgId, "");
        LOGGER.info("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)organizationDtoRestResponse));
        if (ObjectUtil.isNotEmpty((Object)organizationDtoRestResponse.getData())) {
            return ((OrganizationDto)organizationDtoRestResponse.getData()).getCode();
        }
        return "";
    }
}

