/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerRelationQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IItemAuthApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.MatchAuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IAuthItemRuleQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBCustomerBuyScopeService;
import com.dtyunxi.yundt.module.bitem.api.constants.CustomerStatusEnum;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemAuthCustomerRespDto;
import com.dtyunxi.yundt.module.bitem.biz.dto.RequestBaseData;
import com.dtyunxi.yundt.module.bitem.biz.service.IAuthItemRuleService;
import com.dtyunxi.yundt.module.bitem.biz.util.AuthItemCachUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class AuthItemRuleServiceImpl
implements IAuthItemRuleService {
    private static final Logger log = LoggerFactory.getLogger(AuthItemRuleServiceImpl.class);
    @Autowired
    private IAuthItemRuleApi authItemRuleApi;
    @Autowired
    private IAuthItemRuleQueryApi authItemRuleQueryApi;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private ISellerExtQueryApi sellerExtQueryApi;
    @Autowired
    private AuthItemCachUtil authItemCachUtil;
    @Resource
    private ICustomerRelationQueryApi customerRelationQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IBCustomerBuyScopeService customerBuyScopeService;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IItemAuthApi itemAuthApi;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public RestResponse<Long> saveAuthItemRule(AuthItemRuleReqDto authItemRuleReqDto) {
        Long id = null;
        if (authItemRuleReqDto.getId() == null) {
            id = (Long)RestResponseHelper.extractData((RestResponse)this.authItemRuleApi.addAuthItemRule(authItemRuleReqDto));
        } else {
            RestResponseHelper.extractData((RestResponse)this.authItemRuleApi.modifyAuthItemRule(authItemRuleReqDto));
            id = authItemRuleReqDto.getId();
        }
        this.authItemCachUtil.delAuthItemCache(authItemRuleReqDto.getCustomerId());
        Thread thread = new Thread(() -> this.extracted(authItemRuleReqDto));
        thread.start();
        return new RestResponse((Object)id);
    }

    private void extracted(AuthItemRuleReqDto authItemRuleReqDto) {
        CustomerRelationRespDto customerRelationRespDto = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(authItemRuleReqDto.getCustomerId()));
        log.info("\u6821\u9a8c\u5f53\u524d\u662f\u5426\u5b58\u5728\u4e2dB\u5173\u7cfb result => {}", (Object)JSON.toJSONString((Object)customerRelationRespDto));
        if (ObjectUtils.isEmpty((Object)customerRelationRespDto)) {
            return;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(customerRelationRespDto.getParentCusId()));
        Assert.isTrue((!ObjectUtils.isEmpty((Object)customerRespDto) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4e2dB\u79df\u6237\u4e0d\u5b58\u5728");
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(customerRespDto.getOrgInfoId()));
        Assert.isTrue((!ObjectUtils.isEmpty((Object)shopDtos) ? 1 : 0) != 0, (String)"\u5f53\u524d\u4e2dB\u79df\u6237\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        List shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(authItemRuleReqDto.getOrganizationId()));
        ShopBaseDto shopBaseDto = (ShopBaseDto)shopBaseDtos.stream().findFirst().get();
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        itemSearchQueryReqDto.setShopId(shopBaseDto.getId());
        itemSearchQueryReqDto.setShopIds((List)Lists.newArrayList((Object[])new Long[]{shopBaseDto.getId()}));
        itemSearchQueryReqDto.setSearch(Boolean.valueOf(false));
        ItemDepthQueryReqDto itemDepthReqDto = new ItemDepthQueryReqDto();
        itemDepthReqDto.setCustomerIdList((List)Lists.newArrayList());
        itemDepthReqDto.setCustomerId(authItemRuleReqDto.getCustomerId());
        itemDepthReqDto.setShopId(shopBaseDto.getId());
        this.customerBuyScopeService.setCustomerItemAuth(itemDepthReqDto, itemSearchQueryReqDto, null);
        itemSearchQueryReqDto.setStatus(Integer.valueOf(1));
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        List itemRespDtoList = itemSearchRespDto.getPageInfo().getList();
        if (CollectionUtils.isNotEmpty((Collection)itemRespDtoList)) {
            List itemIds;
            List itemSkuRespDtoList = itemRespDtoList.stream().map(c -> c.getItemSkuList()).flatMap(Collection::stream).collect(Collectors.toList());
            Map<Long, Long> skuIdAndItemIdMap = itemSkuRespDtoList.stream().collect(Collectors.toMap(key -> key.getId(), val -> val.getItemId(), (v1, v2) -> v1));
            List skuIds = itemSkuRespDtoList.stream().map(c -> c.getId()).collect(Collectors.toList());
            ShopBaseDto shopDto = (ShopBaseDto)shopDtos.stream().findFirst().get();
            ItemAuthReqDto queryCondition = new ItemAuthReqDto();
            queryCondition.setTargetIdList((List)Lists.newArrayList((Object[])new Long[]{shopDto.getId()}));
            queryCondition.setTargetType(Integer.valueOf(2));
            List itemAuthRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.queryByTargetIds(queryCondition));
            List authSkuIds = itemAuthRespDtoList.stream().map(c -> c.getBusinessId()).collect(Collectors.toList());
            skuIds.removeAll(authSkuIds);
            List itemAuthReqDtoList = skuIds.stream().map(c -> {
                ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setTargetType(Integer.valueOf(2));
                itemAuthReqDto.setTargetId(shopDto.getId());
                itemAuthReqDto.setBusinessType("SKU");
                itemAuthReqDto.setBusinessId(c);
                itemAuthReqDto.setStatus(Integer.valueOf(1));
                itemAuthReqDto.setInstanceId(this.requestBaseData.getInstanceId());
                itemAuthReqDto.setTenantId(this.requestBaseData.getTenantId());
                return itemAuthReqDto;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(itemAuthReqDtoList)) {
                try {
                    this.itemAuthApi.batchAddItemAuth(itemAuthReqDtoList);
                }
                catch (Exception e) {
                    log.info("\u6388\u6743\u4fe1\u606f\u5165\u5e93\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString(itemAuthReqDtoList));
                }
            }
            if (CollectionUtils.isNotEmpty(itemIds = skuIds.stream().map(c -> (Long)skuIdAndItemIdMap.get(c)).collect(Collectors.toList()))) {
                log.info("\u6267\u884c\u624b\u52a8\u4e0a\u67b6\uff1a{}", (Object)JSONObject.toJSONString(itemIds));
                HashMap onShelfShopMap = new HashMap();
                onShelfShopMap.put(shopDto.getId().toString(), itemIds);
                this.commonsMqService.sendSingleMessageAsync("ITEM-SYNC-ONSHELF", onShelfShopMap);
            }
        }
    }

    @Override
    public RestResponse<AuthItemRuleRespDto> queryByCustomerId(Long customerId) {
        return this.authItemRuleQueryApi.queryByCustomerId(customerId);
    }

    @Override
    public RestResponse<PageInfo<AuthItemRuleRespDto>> queryByPage(AuthItemRuleReqDto authItemRuleReqDto) {
        return this.authItemRuleQueryApi.queryByPage(authItemRuleReqDto);
    }

    @Override
    public RestResponse<PageInfo<ItemAuthCustomerRespDto>> queryRulePageByCondition(MatchAuthItemRuleReqDto matchAuthItemRuleReqDto) {
        PageInfo resultPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.authItemRuleQueryApi.queryRulePageByCondition(matchAuthItemRuleReqDto));
        ArrayList itemAuthCustomerRespDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultPage.getList())) {
            SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(matchAuthItemRuleReqDto.getOrganizationId()));
            List customerIds = resultPage.getList().stream().map(AuthItemRuleRespDto::getCustomerId).distinct().collect(Collectors.toList());
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIds));
            Map<Long, CustomerRespDto> customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, e -> e, (e1, e2) -> e1));
            for (AuthItemRuleRespDto authItemRuleRespDto : resultPage.getList()) {
                ItemAuthCustomerRespDto itemAuthCustomerRespDto = new ItemAuthCustomerRespDto();
                BeanUtil.copyProperties((Object)authItemRuleRespDto, (Object)itemAuthCustomerRespDto, (String[])new String[0]);
                itemAuthCustomerRespDto.setCustomerId(matchAuthItemRuleReqDto.getOrganizationId());
                CustomerRespDto customerRespDto = customerRespDtoMap.get(authItemRuleRespDto.getCustomerId());
                if (customerRespDto != null) {
                    itemAuthCustomerRespDto.setCustomerTypeId(customerRespDto.getCustomerTypeId());
                    itemAuthCustomerRespDto.setCustomerTypeName(customerRespDto.getCustomerTypeName());
                    itemAuthCustomerRespDto.setRegionCodeList(customerRespDto.getRegionCodeList());
                    itemAuthCustomerRespDto.setRegionNames(customerRespDto.getRegionNames());
                    itemAuthCustomerRespDto.setStatusId(customerRespDto.getStatusId());
                    itemAuthCustomerRespDto.setStatusName(CustomerStatusEnum.getStatusNameById((Long)customerRespDto.getStatusId()));
                }
                if (sellerRespDto != null) {
                    itemAuthCustomerRespDto.setOrganizationName(sellerRespDto.getName());
                }
                itemAuthCustomerRespDtos.add(itemAuthCustomerRespDto);
            }
        }
        PageInfo pageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)resultPage, (Object)pageInfo, (String[])new String[]{"list"});
        pageInfo.setList((List)itemAuthCustomerRespDtos);
        return new RestResponse((Object)pageInfo);
    }

    public static void main(String[] args) {
        System.out.println(CustomerStatusEnum.getStatusNameById((Long)1256288005151458333L));
    }
}

